/*
 * Decompiled with CFR 0.152.
 */
package opennlp.bratann;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import opennlp.bratann.NameFinderResource;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.sentdetect.NewlineSentenceDetector;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.SimpleTokenizer;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class NameFinderAnnService {
    public static SentenceDetector sentenceDetector = new NewlineSentenceDetector();
    public static Tokenizer tokenizer = WhitespaceTokenizer.INSTANCE;
    public static TokenNameFinder[] nameFinders;

    public static void main(String[] args) throws Exception {
        int tokenizerModelIndex;
        int ruleBasedTokenizerIndex;
        int sentenceModelIndex;
        if (args.length == 0) {
            System.out.println("Usage:");
            System.out.println("[NameFinderAnnService -serverPort port] [-tokenizerModel file] [-ruleBasedTokenizer whitespace|simple] [-sentenceDetectorModel file] namefinderFile|nameFinderURI");
            return;
        }
        List<String> argList = Arrays.asList(args);
        int serverPort = 8080;
        int serverPortIndex = argList.indexOf("-serverPort") + 1;
        if (serverPortIndex > 0 && serverPortIndex < args.length) {
            serverPort = Integer.parseInt(args[serverPortIndex]);
        }
        if ((sentenceModelIndex = argList.indexOf("-sentenceDetectorModel") + 1) > 0 && sentenceModelIndex < args.length) {
            sentenceDetector = new SentenceDetectorME(new SentenceModel(new File(args[sentenceModelIndex])));
        }
        if ((ruleBasedTokenizerIndex = argList.indexOf("-ruleBasedTokenizer") + 1) > 0 && ruleBasedTokenizerIndex < args.length) {
            if ("whitespace".equals(args[ruleBasedTokenizerIndex])) {
                tokenizer = WhitespaceTokenizer.INSTANCE;
            } else if ("simple".equals(args[ruleBasedTokenizerIndex])) {
                tokenizer = SimpleTokenizer.INSTANCE;
            } else {
                System.out.println("unkown tokenizer: " + args[ruleBasedTokenizerIndex]);
                return;
            }
        }
        if ((tokenizerModelIndex = argList.indexOf("-tokenizerModel") + 1) > 0 && tokenizerModelIndex < args.length) {
            tokenizer = new TokenizerME(new TokenizerModel(new File(args[tokenizerModelIndex])));
        }
        nameFinders = new TokenNameFinder[]{new NameFinderME(new TokenNameFinderModel(new File(args[args.length - 1])))};
        URI baseUri = UriBuilder.fromUri("http://localhost/").port(serverPort).build(new Object[0]);
        ResourceConfig config = new ResourceConfig(NameFinderResource.class);
        GrizzlyHttpServerFactory.createHttpServer(baseUri, config);
    }
}

