/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import morfologik.fsa.FSA;
import morfologik.tools.CliTool;
import morfologik.tools.ExitStatus;
import morfologik.tools.ValidateFileExists;
import morfologik.tools.ValidateParentDirExists;

@Parameters(commandNames={"fsa_decompile"}, commandDescription="Dumps all sequences encoded in an automaton.")
public class FSADecompile
extends CliTool {
    @Parameter(names={"-i", "--input"}, description="The input automaton.", required=true, validateValueWith=ValidateFileExists.class)
    private Path input;
    @Parameter(names={"-o", "--output"}, description="The output file for byte sequences.", required=true, validateValueWith=ValidateParentDirExists.class)
    private Path output;

    FSADecompile() {
    }

    public FSADecompile(Path input, Path output) {
        this.input = FSADecompile.checkNotNull(input);
        this.output = FSADecompile.checkNotNull(output);
    }

    @Override
    public ExitStatus call() throws Exception {
        FSA fsa;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(this.input, new OpenOption[0]));){
            fsa = FSA.read(is);
        }
        var3_2 = null;
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(this.output, new OpenOption[0]));){
            for (ByteBuffer bb : fsa) {
                int o = bb.arrayOffset();
                ((OutputStream)os).write(bb.array(), o + bb.position(), o + bb.remaining());
                ((OutputStream)os).write(10);
            }
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        return ExitStatus.SUCCESS;
    }

    public static void main(String[] args) {
        FSADecompile.main(args, (CliTool)new FSADecompile());
    }
}

