/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.worlddata;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import mod.akrivus.kagic.init.KAGIC;
import mod.heimrarnadalr.kagic.worlddata.WarpPadDataEntry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class WorldDataWarpPad
extends WorldSavedData {
    private static final String DATA_NAME = "kagic_warppads";
    private final Map<BlockPos, WarpPadDataEntry> warpPadData = new LinkedHashMap<BlockPos, WarpPadDataEntry>();

    public WorldDataWarpPad() {
        super(DATA_NAME);
    }

    public WorldDataWarpPad(String identifier) {
        super(identifier);
    }

    public static WorldDataWarpPad get(World world) {
        if (!world.field_72995_K) {
            MapStorage storage = world.getPerWorldStorage();
            WorldDataWarpPad instance = (WorldDataWarpPad)storage.func_75742_a(WorldDataWarpPad.class, DATA_NAME);
            if (instance == null) {
                instance = new WorldDataWarpPad();
                storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }
        KAGIC.instance.chatInfoMessage("Tried to get world data from client");
        return null;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        Iterator<Map.Entry<BlockPos, WarpPadDataEntry>> it = this.warpPadData.entrySet().iterator();
        while (it.hasNext()) {
            NBTTagCompound tc = new NBTTagCompound();
            Map.Entry<BlockPos, WarpPadDataEntry> pair = it.next();
            tc.func_74778_a("name", pair.getValue().name);
            tc.func_74757_a("valid", pair.getValue().valid);
            tc.func_74757_a("clear", pair.getValue().clear);
            tc.func_74768_a("x", pair.getKey().func_177958_n());
            tc.func_74768_a("y", pair.getKey().func_177956_o());
            tc.func_74768_a("z", pair.getKey().func_177952_p());
            list.func_74742_a((NBTBase)tc);
        }
        compound.func_74782_a("pads", (NBTBase)list);
        return compound;
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("pads", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            BlockPos pos = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
            String name = tc.func_74779_i("name");
            boolean valid = tc.func_74767_n("valid");
            boolean clear = tc.func_74767_n("clear");
            this.warpPadData.put(pos, new WarpPadDataEntry(name, valid, clear));
        }
    }

    public void addWarpPadEntry(String name, boolean valid, boolean clear, BlockPos pos) {
        this.warpPadData.put(pos, new WarpPadDataEntry(name, valid, clear));
        this.func_76185_a();
    }

    public void removeWarpPadEntry(BlockPos pos) {
        if (this.warpPadData.containsKey(pos)) {
            this.warpPadData.remove(pos);
            this.func_76185_a();
        }
    }

    public String getNameFromPos(BlockPos pos) {
        if (this.warpPadData.containsKey(pos)) {
            return this.warpPadData.get((Object)pos).name;
        }
        KAGIC.instance.chatInfoMessage("Tried getting name of nonexistent BlockPos");
        return null;
    }

    public Map<BlockPos, WarpPadDataEntry> getWarpPadData() {
        return this.warpPadData;
    }

    public static SortedMap<Double, BlockPos> getSortedPositions(Map<BlockPos, WarpPadDataEntry> data, BlockPos pos) {
        TreeMap<Double, BlockPos> sortedPoses = new TreeMap<Double, BlockPos>();
        Set<Map.Entry<BlockPos, WarpPadDataEntry>> entrySet = data.entrySet();
        Iterator<Map.Entry<BlockPos, WarpPadDataEntry>> it = entrySet.iterator();
        while (it.hasNext()) {
            BlockPos otherPos = it.next().getKey();
            if (otherPos.equals((Object)pos)) continue;
            double dist = pos.func_177954_c((double)otherPos.func_177958_n(), (double)otherPos.func_177956_o(), (double)otherPos.func_177952_p());
            sortedPoses.put(dist, otherPos);
        }
        return sortedPoses;
    }
}

