/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.worlddata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mod.akrivus.kagic.init.KAGIC;
import mod.heimrarnadalr.kagic.worlddata.ChunkLocation;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class WorldDataRuins
extends WorldSavedData {
    private static final String DATA_NAME = "kagic_ruins";
    private final Map<ChunkLocation, String> ruins = new HashMap<ChunkLocation, String>();
    private final Map<String, ArrayList<BlockPos>> locations = new HashMap<String, ArrayList<BlockPos>>();

    public WorldDataRuins() {
        super(DATA_NAME);
    }

    public WorldDataRuins(String identifier) {
        super(identifier);
    }

    public static WorldDataRuins get(World world) {
        if (!world.field_72995_K) {
            MapStorage storage = world.getPerWorldStorage();
            WorldDataRuins instance = (WorldDataRuins)storage.func_75742_a(WorldDataRuins.class, DATA_NAME);
            if (instance == null) {
                instance = new WorldDataRuins();
                storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }
        KAGIC.instance.chatInfoMessage("Tried to get world data from client");
        return null;
    }

    public void func_76184_a(NBTTagCompound comp) {
        NBTTagList ruinsList = comp.func_150295_c("ruins", 10);
        for (int i = 0; i < ruinsList.func_74745_c(); ++i) {
            NBTTagCompound tc = ruinsList.func_150305_b(i);
            ChunkLocation chunk = new ChunkLocation(tc.func_74762_e("x"), tc.func_74762_e("z"));
            String type = tc.func_74779_i("type");
            this.ruins.put(chunk, type);
        }
        NBTTagCompound locationsListList = (NBTTagCompound)comp.func_74781_a("locations");
        for (String type : locationsListList.func_150296_c()) {
            NBTTagList locationsList = locationsListList.func_150295_c(type, 10);
            ArrayList<BlockPos> locs = new ArrayList<BlockPos>();
            for (int i = 0; i < locationsList.func_74745_c(); ++i) {
                NBTTagCompound tc = locationsList.func_150305_b(i);
                BlockPos location = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
                locs.add(location);
            }
            this.locations.put(type, locs);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound comp) {
        NBTTagList ruinsList = new NBTTagList();
        Iterator<Map.Entry<ChunkLocation, String>> it = this.ruins.entrySet().iterator();
        while (it.hasNext()) {
            NBTTagCompound tc = new NBTTagCompound();
            Map.Entry<ChunkLocation, String> pair = it.next();
            tc.func_74768_a("x", pair.getKey().getX());
            tc.func_74768_a("z", pair.getKey().getZ());
            tc.func_74778_a("type", pair.getValue());
            ruinsList.func_74742_a((NBTBase)tc);
        }
        comp.func_74782_a("ruins", (NBTBase)ruinsList);
        NBTTagCompound locationsListList = new NBTTagCompound();
        for (String type : this.locations.keySet()) {
            NBTTagList locationsList = new NBTTagList();
            for (BlockPos location : this.locations.get(type)) {
                NBTTagCompound tc = new NBTTagCompound();
                tc.func_74768_a("x", location.func_177958_n());
                tc.func_74768_a("y", location.func_177956_o());
                tc.func_74768_a("z", location.func_177952_p());
                locationsList.func_74742_a((NBTBase)tc);
            }
            locationsListList.func_74782_a(type, (NBTBase)locationsList);
        }
        comp.func_74782_a("locations", (NBTBase)locationsListList);
        return comp;
    }

    public boolean chunkHasRuin(ChunkLocation chunk) {
        return this.ruins.containsKey(chunk);
    }

    public boolean chunkHasSpecificRuin(ChunkLocation chunk, String type) {
        if (this.ruins.containsKey(chunk)) {
            return this.ruins.get(chunk).equals(type);
        }
        return false;
    }

    public void setChunk(ChunkLocation chunk, String type) {
        if (this.chunkHasRuin(chunk)) {
            KAGIC.instance.chatInfoMessage("WARNING: double-setting chunk " + chunk.toString());
        }
        this.ruins.put(chunk, type);
        this.func_76185_a();
    }

    public void setLocation(String type, BlockPos location) {
        if (this.locations.containsKey(type)) {
            this.locations.get(type).add(location);
        } else {
            ArrayList<BlockPos> locs = new ArrayList<BlockPos>();
            locs.add(location);
            this.locations.put(type, locs);
        }
        this.func_76185_a();
    }

    public boolean checkDistances(String type, BlockPos location, double minDistanceSq) {
        if (this.locations.containsKey(type)) {
            for (BlockPos ruinPos : this.locations.get(type)) {
                if (!(location.func_177951_i((Vec3i)ruinPos) < minDistanceSq)) continue;
                return false;
            }
        }
        return true;
    }
}

