/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.world.structure;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.init.ModBlocks;
import mod.akrivus.kagic.tileentity.TileEntityGalaxyPadCore;
import mod.akrivus.kagic.tileentity.TileEntityWarpPadCore;
import mod.heimrarnadalr.kagic.world.structure.StructureData;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Schematic {
    public static StructureData loadSchematic(String schematic) {
        NBTTagCompound schematicData;
        try {
            schematicData = CompressedStreamTools.func_74796_a((InputStream)Schematic.class.getResourceAsStream(schematic));
        }
        catch (Exception e) {
            KAGIC.instance.chatInfoMessage("Failed to load schematic " + schematic + "; trying uncompressed read");
            try {
                File file = new File(Schematic.class.getResource(schematic).toExternalForm());
                schematicData = CompressedStreamTools.func_74797_a((File)file);
            }
            catch (Exception e1) {
                KAGIC.instance.chatInfoMessage("Failed to load schematic " + schematic);
                return null;
            }
        }
        HashMap<BlockPos, IBlockState> structureBlocks = new HashMap<BlockPos, IBlockState>();
        boolean schematicaFormat = false;
        short length = schematicData.func_74765_d("Length");
        short width = schematicData.func_74765_d("Width");
        short height = schematicData.func_74765_d("Height");
        byte[] blocks = schematicData.func_74770_j("Blocks");
        byte[] additionalBlocks = null;
        HashMap<Short, String> additionalBlockNames = new HashMap<Short, String>();
        if (schematicData.func_74764_b("AddBlocks") && schematicData.func_74764_b("SchematicaMapping")) {
            schematicaFormat = true;
            byte[] addBlocks = schematicData.func_74770_j("AddBlocks");
            additionalBlocks = new byte[addBlocks.length * 2];
            for (int i = 0; i < addBlocks.length; ++i) {
                additionalBlocks[i * 2] = (byte)(addBlocks[i] >> 4 & 0xF);
                additionalBlocks[i * 2 + 1] = (byte)(addBlocks[i] & 0xF);
            }
            NBTTagCompound blockNames = (NBTTagCompound)schematicData.func_74781_a("SchematicaMapping");
            for (String name : blockNames.func_150296_c()) {
                additionalBlockNames.put(blockNames.func_74765_d(name), name);
            }
        }
        byte[] data = schematicData.func_74770_j("Data");
        NBTTagList tileEntities = schematicData.func_150295_c("TileEntities", 10);
        NBTTagList entities = schematicData.func_150295_c("Entities", 10);
        for (short y = 0; y < height; y = (short)(y + 1)) {
            for (short z = 0; z < length; z = (short)(z + 1)) {
                for (short x = 0; x < width; x = (short)(x + 1)) {
                    try {
                        int index = (y * length + z) * width + x;
                        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
                        IBlockState blockState = null;
                        if (schematicaFormat && additionalBlocks != null) {
                            short blockID = (short)Byte.toUnsignedInt(blocks[index]);
                            blockID = (short)(blockID | (additionalBlocks[index] & 0xFF) << 8);
                            blockState = Block.func_149684_b((String)((String)additionalBlockNames.get(blockID))).func_176203_a(Byte.toUnsignedInt(data[index]));
                        } else {
                            blockState = Block.func_149729_e((int)Byte.toUnsignedInt(blocks[index])).func_176203_a(Byte.toUnsignedInt(data[index]));
                        }
                        structureBlocks.put(pos, blockState);
                        continue;
                    }
                    catch (Exception e) {
                        KAGIC.instance.chatInfoMessage("Unable to create block at " + x + ", " + y + ", " + z);
                        structureBlocks.put(new BlockPos((int)x, (int)y, (int)z), Blocks.field_150407_cf.func_176223_P());
                    }
                }
            }
        }
        return new StructureData(width, height, length, structureBlocks, tileEntities, entities, schematicaFormat);
    }

    public static void GenerateStructureAtPoint(StructureData structure, World world, BlockPos pos, boolean keepTerrain, byte rotation) {
        Rotation rot;
        KAGIC.instance.chatInfoMessage("Using rotation " + rotation);
        Map<BlockPos, IBlockState> structureBlocks = structure.getStructureBlocks();
        switch (rotation % 4) {
            case 1: {
                rot = Rotation.CLOCKWISE_90;
                break;
            }
            case 2: {
                rot = Rotation.CLOCKWISE_180;
                break;
            }
            case 3: {
                rot = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                rot = Rotation.NONE;
            }
        }
        for (BlockPos offset : structureBlocks.keySet()) {
            if (keepTerrain && structureBlocks.get(offset).func_177230_c() == Blocks.field_150350_a || structureBlocks.get(offset).func_177230_c() == Blocks.field_189881_dj) continue;
            BlockPos bP = Schematic.getRotatedPos(offset, structure.getWidth(), structure.getLength(), rotation);
            world.func_175656_a(pos.func_177971_a((Vec3i)bP), structureBlocks.get(offset).func_185907_a(rot));
        }
        for (NBTBase nbt : structure.getTileEntities()) {
            TileEntity te = TileEntity.func_190200_a((World)world, (NBTTagCompound)((NBTTagCompound)nbt));
            if (te == null) continue;
            int x = ((NBTTagCompound)nbt).func_74762_e("x");
            int y = ((NBTTagCompound)nbt).func_74762_e("y");
            int z = ((NBTTagCompound)nbt).func_74762_e("z");
            BlockPos tePos = Schematic.getRotatedPos(new BlockPos(x, y, z), structure.getWidth(), structure.getLength(), rotation);
            if (te instanceof TileEntityGalaxyPadCore) {
                world.func_175656_a(pos.func_177971_a((Vec3i)tePos), ModBlocks.GALAXY_PAD_CORE.func_176223_P());
            } else if (te instanceof TileEntityWarpPadCore) {
                world.func_175656_a(pos.func_177971_a((Vec3i)tePos), ModBlocks.WARP_PAD_CORE.func_176223_P());
            } else if (te instanceof TileEntityLockableLoot) {
                KAGIC.instance.chatInfoMessage("Found chest at unrotated pos " + x + ", " + y + ", " + z);
                structure.chests.add((TileEntityLockableLoot)te);
            } else {
                KAGIC.instance.chatInfoMessage("Found tile entity of type " + te.getClass().getName());
            }
            world.func_175690_a(pos.func_177971_a((Vec3i)tePos), te);
        }
        if (structure.schematicaFormat) {
            KAGIC.instance.chatInfoMessage("Attempting to spawn entities from structure file");
            for (NBTBase nbt : structure.getEntities()) {
                NBTTagList nbtPos = ((NBTTagCompound)nbt).func_150295_c("Pos", 6);
                double x = nbtPos.func_150309_d(0);
                double y = nbtPos.func_150309_d(1);
                double z = nbtPos.func_150309_d(2);
                BlockPos ePos = Schematic.getRotatedPos(new BlockPos(x, y, z), structure.getWidth(), structure.getLength(), rotation);
                Entity e = EntityList.func_75615_a((NBTTagCompound)((NBTTagCompound)nbt), (World)world);
                if (e == null) continue;
                e.func_70012_b((double)(pos.func_177958_n() + ePos.func_177958_n()) + 0.5, (double)(pos.func_177956_o() + ePos.func_177956_o()), (double)(pos.func_177952_p() + ePos.func_177952_p()) + 0.5, e.field_70177_z, e.field_70125_A);
                world.func_72838_d(e);
            }
        }
    }

    public static BlockPos getRotatedPos(BlockPos original, int width, int length, byte rotation) {
        if (rotation < 0 || rotation > 3) {
            KAGIC.instance.chatInfoMessage("WARNING: using nonstandard rotation " + rotation);
        }
        int rotationCorrectionX = width % 2 == 0 ? -1 : 0;
        int rotationCorrectionZ = length % 2 == 0 ? -1 : 0;
        BlockPos bP = original;
        if (rotation % 4 != 0) {
            bP = original.func_177982_a(-width / 2, 0, -length / 2);
            switch (rotation % 4) {
                case 1: {
                    bP = new BlockPos(-bP.func_177952_p() + rotationCorrectionX, bP.func_177956_o(), bP.func_177958_n());
                    break;
                }
                case 2: {
                    bP = new BlockPos(-bP.func_177958_n() + rotationCorrectionX, bP.func_177956_o(), -bP.func_177952_p() + rotationCorrectionZ);
                    break;
                }
                case 3: {
                    bP = new BlockPos(bP.func_177952_p(), bP.func_177956_o(), -bP.func_177958_n() + rotationCorrectionZ);
                }
            }
            bP = rotation == 1 || rotation == 3 ? bP.func_177982_a(length / 2, 0, width / 2) : bP.func_177982_a(width / 2, 0, length / 2);
        }
        return bP;
    }
}

