/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.world.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mod.akrivus.kagic.init.KAGIC;
import mod.heimrarnadalr.kagic.world.structure.Schematic;
import mod.heimrarnadalr.kagic.world.structure.StructureData;
import mod.heimrarnadalr.kagic.worlddata.ChunkLocation;
import mod.heimrarnadalr.kagic.worlddata.WorldDataRuins;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class RuinStructure
extends WorldGenerator {
    protected final String type;
    private final int foundationDepth;
    private final boolean keepTerrain;
    private final boolean randomRotation;
    private final int minDistance;
    protected List<String> structures = new ArrayList<String>();
    protected int width;
    protected int height;
    protected int length;
    protected byte rotation = (byte)-1;
    protected final IBlockState foundationBlock;
    protected Set<Biome> allowedBiomes = new HashSet<Biome>();
    protected Set<BiomeDictionary.Type> allowedBiomeTypes = new HashSet<BiomeDictionary.Type>();
    protected boolean canContainAnyType = false;
    protected Set<IBlockState> allowedBlocks = new HashSet<IBlockState>();
    protected Map<BlockPos, ResourceLocation> chestTables = new HashMap<BlockPos, ResourceLocation>();
    protected Map<BlockPos, Class<? extends EntityLiving>> entities = new HashMap<BlockPos, Class<? extends EntityLiving>>();

    public RuinStructure(String type, int foundationDepth, IBlockState foundation, boolean keepTerrain, boolean randomRotation) {
        this.type = type;
        this.foundationDepth = foundationDepth;
        this.foundationBlock = foundation;
        this.keepTerrain = keepTerrain;
        this.randomRotation = randomRotation;
        this.minDistance = 2000;
    }

    public String getRandomVariant(Random rand) {
        if (this.structures.size() == 0) {
            throw new IllegalStateException("No structures defined for " + this.type + "!");
        }
        return this.structures.get(rand.nextInt(this.structures.size()));
    }

    Set<ChunkLocation> getAffectedChunks(World world, BlockPos pos) {
        HashSet<ChunkLocation> chunks = new HashSet<ChunkLocation>();
        ChunkLocation nearCorner = new ChunkLocation(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        BlockPos far = this.rotation % 2 == 0 ? pos.func_177982_a(this.width, 0, this.length) : pos.func_177982_a(this.length, 0, this.width);
        ChunkLocation farCorner = new ChunkLocation(far.func_177958_n() >> 4, far.func_177952_p() >> 4);
        for (int x = nearCorner.getX(); x <= farCorner.getX(); ++x) {
            for (int z = nearCorner.getZ(); z <= farCorner.getZ(); ++z) {
                chunks.add(new ChunkLocation(x, z));
            }
        }
        return chunks;
    }

    protected boolean checkBiome(World world, BlockPos pos) {
        if (this.allowedBiomes.isEmpty() && this.allowedBiomeTypes.isEmpty()) {
            return true;
        }
        Biome biome = world.func_180494_b(pos);
        if (this.allowedBiomes.contains(biome)) {
            return true;
        }
        if (!this.allowedBiomes.isEmpty()) {
            return false;
        }
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        if (biomeTypes.containsAll(this.allowedBiomeTypes)) {
            return true;
        }
        return this.canContainAnyType && !Collections.disjoint(this.allowedBiomeTypes, biomeTypes);
    }

    protected boolean checkCorners(World world, BlockPos pos) {
        int xFar = pos.func_177958_n() + (this.rotation % 2 == 0 ? this.width : this.length) - 1;
        int zFar = pos.func_177952_p() + (this.rotation % 2 == 0 ? this.length : this.width) - 1;
        BlockPos corner1 = world.func_175672_r(pos).func_177977_b();
        BlockPos corner2 = world.func_175672_r(new BlockPos(xFar, 255, pos.func_177952_p())).func_177977_b();
        BlockPos corner3 = world.func_175672_r(new BlockPos(pos.func_177958_n(), 255, zFar)).func_177977_b();
        BlockPos corner4 = world.func_175672_r(new BlockPos(xFar, 255, zFar)).func_177977_b();
        if (!this.allowedBlocks.contains(world.func_180495_p(corner1))) {
            return false;
        }
        if (!this.allowedBlocks.contains(world.func_180495_p(corner2)) || Math.abs(corner2.func_177956_o() - corner1.func_177956_o()) > this.foundationDepth) {
            return false;
        }
        if (!this.allowedBlocks.contains(world.func_180495_p(corner3)) || Math.abs(corner3.func_177956_o() - corner1.func_177956_o()) > this.foundationDepth) {
            return false;
        }
        return this.allowedBlocks.contains(world.func_180495_p(corner4)) && Math.abs(corner4.func_177956_o() - corner1.func_177956_o()) <= this.foundationDepth;
    }

    protected boolean checkDistance(World world, BlockPos pos) {
        WorldDataRuins existingRuins = WorldDataRuins.get(world);
        return existingRuins.checkDistances(this.type, pos, this.minDistance * this.minDistance);
    }

    protected boolean checkHeight(World world, BlockPos pos) {
        return pos.func_177956_o() + this.height < world.func_72940_L();
    }

    protected boolean checkChunks(World world, Set<ChunkLocation> chunks) {
        WorldDataRuins existingRuins = WorldDataRuins.get(world);
        for (ChunkLocation chunk : chunks) {
            if (!existingRuins.chunkHasRuin(chunk)) continue;
            return false;
        }
        return true;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        StructureData ruin = Schematic.loadSchematic(this.getRandomVariant(rand));
        if (ruin == null) {
            KAGIC.instance.chatInfoMessage("ERROR: could not generate ruin " + this.type);
            return false;
        }
        this.width = ruin.getWidth();
        this.height = ruin.getHeight();
        this.length = ruin.getLength();
        boolean wasNegative = false;
        if (this.rotation == -1) {
            this.rotation = (byte)(this.randomRotation ? rand.nextInt(4) : 0);
            wasNegative = true;
        }
        if (!this.checkBiome(world, pos)) {
            return false;
        }
        if (!this.checkDistance(world, pos)) {
            return false;
        }
        if (!this.checkCorners(world, pos)) {
            return false;
        }
        if (!this.checkHeight(world, pos)) {
            return false;
        }
        Set<ChunkLocation> affectedChunks = this.getAffectedChunks(world, pos);
        if (!this.checkChunks(world, affectedChunks)) {
            return false;
        }
        KAGIC.instance.chatInfoMessage("Generating " + this.type);
        KAGIC.instance.chatInfoMessage("Generating at " + pos);
        this.markChunks(world, affectedChunks, pos);
        this.generateFoundation(world, pos);
        Schematic.GenerateStructureAtPoint(ruin, world, pos, this.keepTerrain, this.rotation);
        if (!ruin.chests.isEmpty()) {
            for (Map.Entry<BlockPos, Object> entry : this.chestTables.entrySet()) {
                BlockPos chestPos = Schematic.getRotatedPos(entry.getKey(), this.width, this.length, this.rotation);
                TileEntity chest = world.func_175625_s(pos.func_177971_a((Vec3i)chestPos));
                if (chest != null && chest instanceof TileEntityLockableLoot) {
                    ((TileEntityLockableLoot)chest).func_189404_a((ResourceLocation)entry.getValue(), rand.nextLong());
                    continue;
                }
                KAGIC.instance.chatInfoMessage("ERROR: could not find chest at position " + chestPos);
            }
        }
        for (Map.Entry<BlockPos, Object> entry : this.entities.entrySet()) {
            BlockPos entityPos = Schematic.getRotatedPos(entry.getKey(), this.width, this.length, this.rotation);
            try {
                EntityLiving entity = (EntityLiving)((Class)entry.getValue()).getDeclaredConstructor(World.class).newInstance(world);
                entity.func_70012_b((double)(pos.func_177958_n() + entityPos.func_177958_n()), (double)(pos.func_177956_o() + entityPos.func_177956_o()), (double)(pos.func_177952_p() + entityPos.func_177952_p()), 0.0f, 0.0f);
                if (world.func_72838_d((Entity)entity)) {
                    entity.func_180482_a(world.func_175649_E(entityPos), null);
                    continue;
                }
                KAGIC.instance.chatInfoMessage("ERROR: failed to create entity " + ((Class)entry.getValue()).getName() + " for structure " + this.type);
            }
            catch (Exception e) {
                KAGIC.instance.chatInfoMessage("ERROR: failed to create entity " + ((Class)entry.getValue()).getName() + " for structure " + this.type);
                e.printStackTrace();
            }
        }
        this.rotation = (byte)(wasNegative ? -1 : (int)this.rotation);
        return true;
    }

    protected void generateFoundation(World world, BlockPos pos) {
        if (this.foundationDepth == 0) {
            return;
        }
        int width = this.rotation % 2 == 0 ? this.width : this.length;
        int length = this.rotation % 2 == 0 ? this.length : this.width;
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                for (int y = 1; y <= this.foundationDepth; ++y) {
                    world.func_175656_a(pos.func_177982_a(x, -y, z), this.foundationBlock);
                }
            }
        }
    }

    protected void markChunks(World world, Set<ChunkLocation> chunks, BlockPos pos) {
        WorldDataRuins existingRuins = WorldDataRuins.get(world);
        for (ChunkLocation chunk : chunks) {
            existingRuins.setChunk(chunk, this.type);
        }
        existingRuins.setLocation(this.type, pos);
    }
}

