/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.world.biome;

import java.util.List;
import java.util.Random;
import mod.akrivus.kagic.blocks.BlockIncubator;
import mod.akrivus.kagic.blocks.BlockInjector;
import mod.akrivus.kagic.init.ModBlocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeKindergarten
extends Biome {
    private static final Biome.BiomeProperties PROPERTIES = new Biome.BiomeProperties("Kindergarten");
    protected static final IBlockState DRAINED_BLOCK = ModBlocks.DRAINED_BLOCK.func_176223_P();
    protected static final IBlockState DRAINED_BLOCK_2 = ModBlocks.DRAINED_BLOCK_2.func_176223_P();
    protected static final IBlockState DRAINED_BANDS = ModBlocks.DRAINED_BANDS.func_176223_P();
    protected static final int SEALEVELOFFSET = -10;
    private long worldSeed;
    private NoiseGeneratorPerlin cliffNoise;
    private NoiseGeneratorPerlin cliffRoofNoise;

    public BiomeKindergarten() {
        this(PROPERTIES);
    }

    public BiomeKindergarten(Biome.BiomeProperties properties) {
        super(properties);
        this.setRegistryName("kindergarten");
        this.field_76752_A = field_185366_b;
        this.field_76753_B = field_185366_b;
        this.field_76762_K.clear();
        this.field_82914_M.clear();
        this.field_76755_L.clear();
        this.field_76761_J.clear();
        for (List list : this.modSpawnableLists.values()) {
            list.clear();
        }
        this.field_76760_I.field_76807_J = 0;
        this.field_76760_I.field_76800_F = 0;
        this.field_76760_I.field_76806_I = 0;
        this.field_76760_I.field_76804_C = 0;
        this.field_76760_I.field_76802_A = 0;
        this.field_76760_I.field_76803_B = 0;
        this.field_76760_I.field_76801_G = 0;
        this.field_76760_I.field_76798_D = 0;
        this.field_76760_I.field_76799_E = 0;
        this.field_76760_I.field_76805_H = 0;
        this.field_76760_I.field_76832_z = 2;
        this.field_76760_I.field_76833_y = 0;
        this.field_76760_I.field_76808_K = false;
    }

    public BiomeDecorator func_76729_a() {
        return new Decorator();
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer chunkPrimer, int x, int z, double noiseVal) {
        if (this.cliffNoise == null || this.cliffRoofNoise == null || this.worldSeed != world.func_72905_C()) {
            this.worldSeed = world.func_72905_C();
            Random peakRandom = new Random(this.worldSeed);
            this.cliffNoise = new NoiseGeneratorPerlin(peakRandom, 8);
            this.cliffRoofNoise = new NoiseGeneratorPerlin(peakRandom, 2);
        }
        double peakHeight = 0.0;
        int i = (x & 0xFFFFFFF0) + (z & 0xF);
        int j = (z & 0xFFFFFFF0) + (x & 0xF);
        double d0 = Math.min(Math.abs(noiseVal), Math.abs(this.cliffNoise.func_151601_a((double)i * 1.0, (double)j * 1.0)));
        if (d0 > 0.0) {
            peakHeight = d0 * d0 * 8.0;
            double d2 = Math.abs(this.cliffRoofNoise.func_151601_a((double)i * 0.001953125, (double)j * 0.001953125));
            double peakOffset = Math.ceil(d2 * 25.0) + 40.0;
            if (peakHeight > peakOffset) {
                peakHeight = peakOffset;
            }
            peakHeight += 64.0;
        }
        int chunkX = x & 0xF;
        int chunkZ = z & 0xF;
        int seaLevel = world.func_181545_F();
        int l = -1;
        IBlockState drainedBlockState = DRAINED_BLOCK;
        for (int height = 255; height >= 0; --height) {
            drainedBlockState = height % 6 == 0 || height % 6 == 1 ? DRAINED_BLOCK_2 : (height % 5 == 0 ? DRAINED_BANDS : DRAINED_BLOCK);
            if (chunkPrimer.func_177856_a(chunkZ, height, chunkX).func_185904_a() == Material.field_151579_a && height < (int)peakHeight) {
                chunkPrimer.func_177855_a(chunkZ, height, chunkX, field_185365_a);
            }
            if (height <= rand.nextInt(5)) {
                chunkPrimer.func_177855_a(chunkZ, height, chunkX, field_185367_c);
                continue;
            }
            if (chunkPrimer.func_177856_a(chunkZ, height, chunkX).func_177230_c() != Blocks.field_150348_b && chunkPrimer.func_177856_a(chunkZ, height, chunkX).func_177230_c() != field_185372_h) continue;
            chunkPrimer.func_177855_a(chunkZ, height, chunkX, drainedBlockState);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 3681839;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 6903134;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return 0xD7D3DD;
    }

    static {
        PROPERTIES.func_185398_c(0.1f);
        PROPERTIES.func_185400_d(0.0f);
        PROPERTIES.func_185396_a();
        PROPERTIES.func_185402_a(0x646400);
    }

    class Decorator
    extends BiomeDecorator {
        private static final float HOLE_CHANCE = 0.9f;
        private static final int HOLE_HEIGHT = 3;
        private static final int HOLE_DEPTH = 4;
        private static final float INJECTOR_CHANCE = 0.05f;
        private static final float GEM_CHANCE = 1.0E-4f;

        private Decorator() {
        }

        private void generateInjector(World world, BlockPos pos, EnumFacing direction) {
            world.func_175656_a(pos, ModBlocks.GEM_DRILL.func_176223_P());
            world.func_175656_a(pos.func_177981_b(1), ModBlocks.INJECTOR.func_176223_P().func_177226_a((IProperty)BlockInjector.FACING, (Comparable)direction));
            world.func_175656_a(pos.func_177981_b(2), ModBlocks.INCUBATOR.func_176223_P().func_177226_a((IProperty)BlockIncubator.FACING, (Comparable)direction));
        }

        private boolean canMakeHole(World world, BlockPos pos, EnumFacing direction) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 2; z < 6; ++z) {
                    if (world.func_175665_u(pos.func_177981_b(y).func_177967_a(direction, z)) && world.func_175665_u(pos.func_177981_b(y).func_177967_a(direction, z).func_177972_a(direction.func_176746_e())) && world.func_175665_u(pos.func_177981_b(y).func_177967_a(direction, z).func_177972_a(direction.func_176735_f()))) continue;
                    return false;
                }
            }
            return true;
        }

        private void generateHole(World world, BlockPos pos, EnumFacing direction, Random rand) {
            if (rand.nextFloat() < 1.0E-4f) {
                world.func_175656_a(pos.func_177967_a(direction, 4), ModBlocks.GEM_SEED.func_176223_P());
                world.func_175656_a(pos.func_177984_a().func_177967_a(direction, 4), Blocks.field_150449_bY.func_176223_P());
            } else {
                for (int y = 0; y < 3; ++y) {
                    for (int l = 0; l <= 4; ++l) {
                        world.func_175698_g(pos.func_177981_b(y).func_177967_a(direction, l));
                    }
                }
            }
        }

        private EnumFacing generateExitHole(World world, BlockPos pos, Random random) {
            if (random.nextFloat() > 0.9f) {
                return EnumFacing.DOWN;
            }
            if (this.canMakeHole(world, pos, EnumFacing.SOUTH)) {
                this.generateHole(world, pos, EnumFacing.SOUTH, random);
                return EnumFacing.SOUTH;
            }
            if (this.canMakeHole(world, pos, EnumFacing.WEST)) {
                this.generateHole(world, pos, EnumFacing.WEST, random);
                return EnumFacing.WEST;
            }
            if (this.canMakeHole(world, pos, EnumFacing.NORTH)) {
                this.generateHole(world, pos, EnumFacing.NORTH, random);
                return EnumFacing.NORTH;
            }
            if (this.canMakeHole(world, pos, EnumFacing.EAST)) {
                this.generateHole(world, pos, EnumFacing.EAST, random);
                return EnumFacing.EAST;
            }
            return EnumFacing.DOWN;
        }

        protected void func_150513_a(Biome biome, World world, Random random) {
            for (int x = 8; x < 24; x += 2) {
                for (int z = 8; z < 24; z += 2) {
                    BlockPos potentialHolePos = world.func_175672_r(this.field_180294_c.func_177982_a(x, 0, z));
                    if (potentialHolePos.func_177956_o() > 120) continue;
                    EnumFacing holeDirection = EnumFacing.DOWN;
                    for (int y = 0; y < 60; y += 5) {
                        EnumFacing dir = this.generateExitHole(world, potentialHolePos.func_177981_b(y), random);
                        if (dir == EnumFacing.DOWN) continue;
                        holeDirection = dir;
                    }
                    if (holeDirection == EnumFacing.DOWN || !(random.nextFloat() < 0.05f)) continue;
                    this.generateInjector(world, world.func_175672_r(this.field_180294_c.func_177982_a(x, 0, z).func_177984_a().func_177967_a(holeDirection, 4)), holeDirection);
                }
            }
        }

        protected void func_76797_b(World worldIn, Random random) {
        }
    }
}

