/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.world.biome;

import java.util.Random;
import mod.heimrarnadalr.kagic.world.structure.WorldGenFloatingIslands;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeFloatingPeaks
extends Biome {
    private static final Biome.BiomeProperties PROPERTIES = new Biome.BiomeProperties("Floating Peaks");
    private final WorldGenSavannaTree tree = new WorldGenSavannaTree(false);
    private long worldSeed;
    private NoiseGeneratorPerlin peakNoise;
    private NoiseGeneratorPerlin peakRoofNoise;
    private static final int FILLERDEPTH = 1;

    public BiomeFloatingPeaks() {
        super(PROPERTIES);
        this.setRegistryName("floatingpeaks");
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        this.field_76760_I.field_76808_K = false;
        this.field_76760_I.field_76801_G = 0;
        this.field_76760_I.field_76805_H = 0;
        this.field_76760_I.field_76832_z = 1;
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityLlama.class, 12, 2, 3));
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer chunkPrimer, int x, int z, double noiseVal) {
        if (this.peakNoise == null || this.peakRoofNoise == null || this.worldSeed != world.func_72905_C()) {
            this.worldSeed = world.func_72905_C();
            Random peakRandom = new Random(this.worldSeed);
            this.peakNoise = new NoiseGeneratorPerlin(peakRandom, 12);
            this.peakRoofNoise = new NoiseGeneratorPerlin(peakRandom, 16);
        }
        double peakHeight = 0.0;
        int i = (x & 0xFFFFFFF0) + (z & 0xF);
        int j = (z & 0xFFFFFFF0) + (x & 0xF);
        double d0 = Math.min(Math.abs(noiseVal), this.peakNoise.func_151601_a((double)i * 0.5, (double)j * 0.5));
        if (d0 > 0.0) {
            peakHeight = d0 * d0 * 4.0;
            double d2 = Math.abs(this.peakRoofNoise.func_151601_a((double)i * 0.05, (double)j * 0.05));
            double peakOffset = Math.ceil(d2 * 50.0) + 50.0;
            if (peakHeight > peakOffset) {
                peakHeight = peakOffset;
            }
            peakHeight += 64.0;
        }
        int chunkX = x & 0xF;
        int chunkZ = z & 0xF;
        int seaLevel = world.func_181545_F();
        int l = -1;
        for (int height = 255; height >= 0; --height) {
            if (chunkPrimer.func_177856_a(chunkZ, height, chunkX).func_185904_a() == Material.field_151579_a && height < (int)peakHeight) {
                chunkPrimer.func_177855_a(chunkZ, height, chunkX, field_185365_a);
            }
            if (height <= rand.nextInt(5)) {
                chunkPrimer.func_177855_a(chunkZ, height, chunkX, field_185367_c);
                continue;
            }
            IBlockState iblockstate1 = chunkPrimer.func_177856_a(chunkZ, height, chunkX);
            if (iblockstate1.func_185904_a() == Material.field_151579_a) {
                l = -1;
                continue;
            }
            if (iblockstate1.func_177230_c() != Blocks.field_150348_b) continue;
            if (l == -1) {
                chunkPrimer.func_177855_a(chunkZ, height, chunkX, this.field_76752_A);
                ++l;
                continue;
            }
            if (l < 0) {
                chunkPrimer.func_177855_a(chunkZ, height, chunkX, this.field_76753_B);
                ++l;
                continue;
            }
            if (l == 0) {
                l = 1;
                chunkPrimer.func_177855_a(chunkZ, height, chunkX, this.field_76753_B);
                continue;
            }
            if (l <= 0) continue;
            chunkPrimer.func_177855_a(chunkZ, height, chunkX, field_185365_a);
        }
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return this.tree;
    }

    public BiomeDecorator func_76729_a() {
        return new Decorator();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 8079202;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 15003788;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return 16312548;
    }

    static {
        PROPERTIES.func_185398_c(0.4f);
        PROPERTIES.func_185400_d(0.05f);
        PROPERTIES.func_185410_a(0.9f);
        PROPERTIES.func_185395_b(0.5f);
        PROPERTIES.func_185402_a(15400956);
    }

    class Decorator
    extends BiomeDecorator {
        private final WorldGenFloatingIslands floatGenerator = new WorldGenFloatingIslands(5.0f, 9.0f, 10.0f, 18.0f, false);
        private static final int FLOATCHANCERECIPROCAL = 8;
        private static final int VERTICALOFFSET = 20;
        private static final int OFFSETVARIANCE = 10;

        Decorator() {
        }

        protected void func_150513_a(Biome biome, World world, Random random) {
            if (random.nextInt(8) == 0) {
                int j = random.nextInt(16) + 8;
                int k = random.nextInt(16) + 8;
                int offset = random.nextInt(10) + 38;
                BlockPos floatPos = world.func_175672_r(this.field_180294_c.func_177982_a(j, 0, k)).func_177981_b(offset);
                if (floatPos.func_177956_o() < 175) {
                    this.floatGenerator.func_180709_b(world, random, floatPos);
                }
            }
            super.func_150513_a(biome, world, random);
        }
    }
}

