/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.world;

import mod.akrivus.kagic.init.ModBiomes;
import mod.akrivus.kagic.init.ModBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Fogger {
    private static final ResourceLocation RES_UNDERTEARS_OVERLAY = new ResourceLocation("kagic:textures/blocks/rose_tears_overlay.png");
    private static final int FADE_TICKS = 60;
    private int fadeTicksLeft = 0;
    private float fogColor1;
    private float fogColor2;

    private static float[] getBiomeFogColor(Biome biome) {
        if (biome == ModBiomes.FLOATINGPEAKS) {
            return new float[]{0.96862745f, 0.8627451f, 0.85490197f};
        }
        if (biome == ModBiomes.KINDERGARTEN) {
            return new float[]{0.84313726f, 0.827451f, 0.8666667f};
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @SubscribeEvent
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        Entity entity;
        this.fogColor2 = this.fogColor1;
        World world = entity.field_70170_p;
        entity = event.getEntity();
        Biome biome = world.func_180494_b(entity.func_180425_c());
        if (biome == ModBiomes.FLOATINGPEAKS || biome == ModBiomes.KINDERGARTEN || this.fadeTicksLeft > 0) {
            int i;
            float f9;
            float[] biomeColor = Fogger.getBiomeFogColor(biome);
            float red = event.getRed() + (biomeColor[0] - event.getRed()) * ((float)this.fadeTicksLeft / 60.0f);
            float green = event.getGreen() + (biomeColor[1] - event.getGreen()) * ((float)this.fadeTicksLeft / 60.0f);
            float blue = event.getBlue() + (biomeColor[2] - event.getBlue()) * ((float)this.fadeTicksLeft / 60.0f);
            float partialTicks = (float)event.getRenderPartialTicks();
            float celestialAngle = world.func_72826_c(partialTicks);
            float f = 0.25f + 0.75f * (float)Minecraft.func_71410_x().field_71474_y.field_151451_c / 32.0f;
            f = 1.0f - (float)Math.pow(f, 0.25);
            Vec3d vec3d = world.func_72833_a(entity, partialTicks);
            float f1 = (float)vec3d.field_72450_a;
            float f2 = (float)vec3d.field_72448_b;
            float f3 = (float)vec3d.field_72449_c;
            float f3_2 = world.func_175724_o(new BlockPos(Minecraft.func_71410_x().func_175606_aa()));
            float f2_2 = f3_2 * (1.0f - f) + f;
            this.fogColor1 += (f2_2 - this.fogColor1) * 0.1f;
            if (Minecraft.func_71410_x().field_71474_y.field_151451_c >= 4) {
                float[] afloat;
                double d0 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) > 0.0f ? -1.0 : 1.0;
                Vec3d vec3d2 = new Vec3d(d0, 0.0, 0.0);
                float f5 = (float)entity.func_70676_i(partialTicks).func_72430_b(vec3d2);
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                if (f5 > 0.0f && (afloat = world.field_73011_w.func_76560_a(celestialAngle, partialTicks)) != null) {
                    red = red * (1.0f - (f5 *= afloat[3])) + afloat[0] * f5;
                    green = green * (1.0f - f5) + afloat[1] * f5;
                    blue = blue * (1.0f - f5) + afloat[2] * f5;
                }
            }
            red += (f1 - red) * f;
            green += (f2 - green) * f;
            blue += (f3 - blue) * f;
            float baseScale = MathHelper.func_76131_a((float)(MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
            red *= baseScale * 0.94f + 0.06f;
            green *= baseScale * 0.94f + 0.06f;
            blue *= baseScale * 0.91f + 0.09f;
            float f8 = world.func_72867_j(partialTicks);
            if (f8 > 0.0f) {
                float f4 = 1.0f - f8 * 0.5f;
                float f10 = 1.0f - f8 * 0.4f;
                red *= f4;
                green *= f4;
                blue *= f10;
            }
            if ((f9 = world.func_72819_i(partialTicks)) > 0.0f) {
                float f11 = 1.0f - f9 * 0.5f;
                red *= f11;
                green *= f11;
                blue *= f11;
            }
            IBlockState iblockstate = ActiveRenderInfo.func_186703_a((World)world, (Entity)entity, (float)partialTicks);
            Vec3d viewport = ActiveRenderInfo.func_178806_a((Entity)entity, (double)partialTicks);
            BlockPos viewportPos = new BlockPos(viewport);
            IBlockState viewportState = world.func_180495_p(viewportPos);
            Vec3d inMaterialColor = viewportState.func_177230_c().getFogColor(world, viewportPos, viewportState, entity, new Vec3d((double)red, (double)green, (double)blue), partialTicks);
            red = (float)inMaterialColor.field_72450_a;
            green = (float)inMaterialColor.field_72448_b;
            blue = (float)inMaterialColor.field_72449_c;
            float f13 = this.fogColor2 + (this.fogColor1 - this.fogColor2) * partialTicks;
            red *= f13;
            green *= f13;
            blue *= f13;
            double d1 = (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks) * world.field_73011_w.func_76565_k();
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
                i = ((EntityLivingBase)entity).func_70660_b(MobEffects.field_76440_q).func_76459_b();
                d1 = i < 20 ? (d1 *= (double)(1.0f - (float)i / 20.0f)) : 0.0;
            }
            if (d1 < 1.0) {
                if (d1 < 0.0) {
                    d1 = 0.0;
                }
                d1 *= d1;
                red = (float)((double)red * d1);
                green = (float)((double)green * d1);
                blue = (float)((double)blue * d1);
            }
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
                i = ((EntityLivingBase)entity).func_70660_b(MobEffects.field_76439_r).func_76459_b();
                float f15 = i > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i - partialTicks) * (float)Math.PI * 0.2f)) * 0.3f;
                float f6 = 1.0f / red;
                if (f6 > 1.0f / green) {
                    f6 = 1.0f / green;
                }
                if (f6 > 1.0f / blue) {
                    f6 = 1.0f / blue;
                }
                red = red * (1.0f - f15) + red * f6 * f15;
                green = green * (1.0f - f15) + green * f6 * f15;
                blue = blue * (1.0f - f15) + blue * f6 * f15;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                float f16 = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
                float f17 = (red * 30.0f + green * 70.0f) / 100.0f;
                float f7 = (red * 30.0f + blue * 70.0f) / 100.0f;
                red = f16;
                green = f17;
                blue = f7;
            }
            event.setRed(red);
            event.setGreen(green);
            event.setBlue(blue);
        }
        this.fadeTicksLeft = biome == ModBiomes.FLOATINGPEAKS || biome == ModBiomes.KINDERGARTEN ? Math.min(++this.fadeTicksLeft, 60) : Math.max(0, --this.fadeTicksLeft);
    }

    @SubscribeEvent
    public void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        if (event.getPlayer().field_70170_p.func_180495_p(event.getBlockPos()).func_177230_c() == ModBlocks.ROSE_TEARS) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_UNDERTEARS_OVERLAY);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            float f = Minecraft.func_71410_x().field_71439_g.func_70013_c();
            GlStateManager.func_179131_c((float)f, (float)f, (float)f, (float)0.5f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            float f1 = 4.0f;
            float f2 = -1.0f;
            float f3 = 1.0f;
            float f4 = -1.0f;
            float f5 = 1.0f;
            float f6 = -0.5f;
            float f7 = -event.getPlayer().field_70177_z / 64.0f;
            float f8 = event.getPlayer().field_70125_A / 64.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(4.0f + f8)).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(4.0f + f8)).func_181675_d();
            bufferbuilder.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(0.0f + f8)).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(0.0f + f8)).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            event.setCanceled(true);
        }
    }
}

