/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.networking;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import mod.akrivus.kagic.init.KAGIC;
import mod.heimrarnadalr.kagic.worlddata.GalaxyPadLocation;
import mod.heimrarnadalr.kagic.worlddata.WarpPadDataEntry;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PadDataMessage
implements IMessage {
    private NBTTagCompound padDataCompound;
    private int x;
    private int y;
    private int z;

    public PadDataMessage() {
    }

    public PadDataMessage(NBTTagCompound padDataCompound, int x, int y, int z) {
        this.padDataCompound = padDataCompound;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        int count = buf.readInt();
        byte[] dataBytes = new byte[count];
        buf.readBytes(dataBytes);
        ByteArrayInputStream padDataStream = new ByteArrayInputStream(dataBytes);
        try {
            this.padDataCompound = CompressedStreamTools.func_74796_a((InputStream)padDataStream);
        }
        catch (IOException e) {
            KAGIC.instance.chatInfoMessage("IOException in toBytes");
            e.printStackTrace();
        }
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteArrayOutputStream padDataStream = new ByteArrayOutputStream();
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.padDataCompound, (OutputStream)padDataStream);
            buf.writeInt(padDataStream.size());
            buf.writeBytes(padDataStream.toByteArray());
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
        }
        catch (IOException e) {
            KAGIC.instance.chatInfoMessage("IOException in toBytes");
            e.printStackTrace();
        }
    }

    public static class PadDataMessageHandler
    implements IMessageHandler<PadDataMessage, IMessage> {
        public IMessage onMessage(PadDataMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private LinkedHashMap<GalaxyPadLocation, WarpPadDataEntry> decodeGalaxyData(NBTTagCompound padDataCompound) {
            LinkedHashMap<GalaxyPadLocation, WarpPadDataEntry> padDataMap = new LinkedHashMap<GalaxyPadLocation, WarpPadDataEntry>();
            NBTTagList list = padDataCompound.func_150295_c("pads", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tc = list.func_150305_b(i);
                int dim = tc.func_74762_e("dim");
                BlockPos pos = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
                String name = tc.func_74779_i("name");
                boolean valid = tc.func_74767_n("valid");
                boolean clear = tc.func_74767_n("clear");
                padDataMap.put(new GalaxyPadLocation(dim, pos), new WarpPadDataEntry(name, valid, clear));
            }
            return padDataMap;
        }

        private LinkedHashMap<BlockPos, WarpPadDataEntry> decodePadData(NBTTagCompound padDataCompound) {
            LinkedHashMap<BlockPos, WarpPadDataEntry> padDataMap = new LinkedHashMap<BlockPos, WarpPadDataEntry>();
            NBTTagList list = padDataCompound.func_150295_c("pads", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tc = list.func_150305_b(i);
                BlockPos pos = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
                String name = tc.func_74779_i("name");
                boolean valid = tc.func_74767_n("valid");
                boolean clear = tc.func_74767_n("clear");
                padDataMap.put(pos, new WarpPadDataEntry(name, valid, clear));
            }
            return padDataMap;
        }

        private void handle(PadDataMessage message, MessageContext ctx) {
            if (message.padDataCompound.func_74767_n("galaxy")) {
                LinkedHashMap<GalaxyPadLocation, WarpPadDataEntry> padData = this.decodeGalaxyData(message.padDataCompound);
                KAGIC.proxy.openGalaxyPadSelectionGUI(padData, message.x, message.y, message.z);
            } else {
                LinkedHashMap<BlockPos, WarpPadDataEntry> padData = this.decodePadData(message.padDataCompound);
                KAGIC.proxy.openWarpPadSelectionGUI(padData, message.x, message.y, message.z);
            }
        }
    }
}

