/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.networking;

import io.netty.buffer.ByteBuf;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.tileentity.TileEntityGalaxyPadCore;
import mod.heimrarnadalr.kagic.worlddata.GalaxyPadLocation;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GalaxySignalMessage
implements IMessage {
    private BlockPos sourcePad;
    private GalaxyPadLocation destinationPad;

    public GalaxySignalMessage(BlockPos source, GalaxyPadLocation dest) {
        this.sourcePad = source;
        this.destinationPad = dest;
    }

    public GalaxySignalMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.sourcePad = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.destinationPad = new GalaxyPadLocation(buf.readInt(), new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.sourcePad.func_177958_n());
        buf.writeInt(this.sourcePad.func_177956_o());
        buf.writeInt(this.sourcePad.func_177952_p());
        buf.writeInt(this.destinationPad.getDimension());
        buf.writeInt(this.destinationPad.getPos().func_177958_n());
        buf.writeInt(this.destinationPad.getPos().func_177956_o());
        buf.writeInt(this.destinationPad.getPos().func_177952_p());
    }

    public static class GalaxySignalMessageHandler
    implements IMessageHandler<GalaxySignalMessage, IMessage> {
        public IMessage onMessage(GalaxySignalMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(GalaxySignalMessage message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            World world = playerEntity.func_130014_f_();
            TileEntityGalaxyPadCore te = (TileEntityGalaxyPadCore)world.func_175625_s(message.sourcePad);
            if (te != null) {
                te.beginWarp(message.destinationPad);
            } else {
                KAGIC.instance.chatInfoMessage("TE was null!");
            }
        }
    }
}

