/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.util.injector;

import java.util.HashMap;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.EntitySlag;
import mod.akrivus.kagic.event.CruxCheckEvent;
import mod.akrivus.kagic.event.DrainBlockEvent;
import mod.akrivus.kagic.event.GemSpawnEvent;
import mod.akrivus.kagic.event.PostInjectionEvent;
import mod.akrivus.kagic.event.PreInjectionEvent;
import mod.akrivus.kagic.event.SlagSpawnEvent;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.init.ModBlocks;
import mod.akrivus.kagic.init.ModEntities;
import mod.akrivus.kagic.util.injector.ExitHole;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;

public class InjectorResult {
    private EntityGem gem;
    private final BlockPos position;
    private final double defectiveRate;
    private final boolean createSlags;
    private final boolean isPrimary;
    private final ExitHole exitHole;
    private boolean stale;
    private static final float drainedPercentage = 0.75f;

    public InjectorResult() {
        this(null, null, 0.0, false, false, null);
        this.stale = true;
    }

    public InjectorResult(EntityGem gem, BlockPos pos, double defectiveRate, boolean createSlags, boolean isPrimary, ExitHole exitHole) {
        this.gem = gem;
        this.position = pos;
        this.defectiveRate = defectiveRate;
        this.createSlags = createSlags;
        this.isPrimary = isPrimary;
        this.exitHole = exitHole;
    }

    public EntityGem getGem() {
        return this.gem;
    }

    public String getName() {
        return this.gem.func_70005_c_();
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public double getDefectivity() {
        return this.defectiveRate;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean canCreateSlags() {
        return this.createSlags;
    }

    public ExitHole getExitHole() {
        return this.exitHole;
    }

    public void generate(World world) {
        if (!this.stale) {
            if (this.canCreateSlags()) {
                int totalSlags = world.field_73012_v.nextInt(9) + 1;
                for (int i = 0; i <= totalSlags; ++i) {
                    boolean failed = true;
                    int attempts = 0;
                    while (failed && attempts < 10) {
                        BlockPos spawn = this.getPosition().func_177982_a(world.field_73012_v.nextInt(9), 0, world.field_73012_v.nextInt(9));
                        ChunkPos c = world.func_175726_f(spawn).func_76632_l();
                        boolean bl = failed = !world.func_175623_d(spawn);
                        if (!failed) {
                            EntitySlag slag = new EntitySlag(world);
                            slag.func_70107_b(spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p());
                            slag.setVariant(Math.abs((c.field_77276_a + c.field_77275_b) % ModEntities.MINERALS.size()));
                            SlagSpawnEvent e1 = new SlagSpawnEvent(world, spawn, slag);
                            if (MinecraftForge.EVENT_BUS.post((Event)e1)) continue;
                            world.func_72838_d((Entity)slag);
                            slag.func_180482_a(world.func_175649_E(spawn), null);
                            continue;
                        }
                        ++attempts;
                    }
                }
                world.func_175655_b(this.position, false);
            } else {
                if (this.exitHole != null) {
                    this.exitHole.emerge(world);
                }
                if ((double)this.gem.field_70170_p.field_73012_v.nextFloat() < this.defectiveRate) {
                    this.gem.setDefective(true);
                } else if (this.exitHole.createRockMelt()) {
                    this.gem.setPrimary(true);
                }
                world.func_72838_d((Entity)this.gem);
                this.gem.func_180482_a(world.func_175649_E(this.getPosition()), null);
            }
        }
    }

    public static InjectorResult create(World world, BlockPos pos, boolean drain) {
        GemSpawnEvent e4;
        HashMap<Class<EntityGem>, Double> resultTable = new HashMap<Class<EntityGem>, Double>();
        HashMap<Class<EntityGem>, Double> defectivity = new HashMap<Class<EntityGem>, Double>();
        HashMap<Class<EntityGem>, Double> friction = new HashMap<Class<EntityGem>, Double>();
        float drainedCount = 0.0f;
        float baseMinerals = 0.0f;
        boolean drainedChecked = false;
        PreInjectionEvent e1 = new PreInjectionEvent(world, pos, drain);
        if (MinecraftForge.EVENT_BUS.post((Event)e1)) {
            return new InjectorResult();
        }
        for (String gemType : ModEntities.GEMS.keySet()) {
            Class<EntityGem> gemClass = null;
            HashMap yield = null;
            double defectivityMultiplier = 1.0;
            boolean fieldFound = false;
            try {
                gemClass = ModEntities.GEMS.get(gemType);
                yield = (HashMap)gemClass.getField((gemType + "_yields").toUpperCase()).get(null);
                defectivityMultiplier = (Double)gemClass.getField((gemType + "_defectivity_multiplier").toUpperCase()).get(null);
                fieldFound = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!fieldFound) continue;
            try {
                double pressureFactor = 1.0;
                double depthFactor = 1.0;
                if (world.field_73011_w.func_76569_d()) {
                    try {
                        depthFactor = (Double)gemClass.getField((gemType + "_depth_threshold").toUpperCase()).get(null);
                        if (depthFactor > 0.0) {
                            pressureFactor = depthFactor / (double)pos.func_177956_o();
                            depthFactor = Math.min(1.0, pressureFactor);
                        } else {
                            depthFactor = 1.0;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                double defectivityRate = 1.0;
                double frictionFactor = 0.0;
                for (int x = -4; x <= 4; ++x) {
                    for (int y = -4; y <= 4; ++y) {
                        for (int z = -4; z <= 4; ++z) {
                            IBlockState state;
                            BlockPos ore = pos.func_177982_a(x, y, z);
                            CruxCheckEvent e2 = new CruxCheckEvent(world, pos, ore, state = world.func_180495_p(ore), gemClass);
                            if (MinecraftForge.EVENT_BUS.post((Event)e2)) continue;
                            try {
                                Block block;
                                if (!resultTable.containsKey(gemClass)) {
                                    resultTable.put(gemClass, 0.0);
                                }
                                if (yield.containsKey(state)) {
                                    double result = (Double)yield.get(state);
                                    result = result > 1.98 ? (result *= Math.max(pressureFactor, 1.0)) : (result *= depthFactor);
                                    resultTable.put(gemClass, resultTable.get(gemClass) + result);
                                    frictionFactor += 0.0036;
                                    defectivityRate -= 0.2;
                                } else {
                                    ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
                                    if (!stack.func_190926_b()) {
                                        int[] oreIDs;
                                        for (int oreID : oreIDs = OreDictionary.getOreIDs((ItemStack)stack)) {
                                            if (!OreDictionary.getOreName((int)oreID).startsWith("ore") && !OreDictionary.getOreName((int)oreID).startsWith("block")) continue;
                                            defectivityRate -= 0.2;
                                        }
                                    }
                                }
                                if (!(drainedChecked || (block = state.func_177230_c()) != ModBlocks.DRAINED_BLOCK && block != Blocks.field_150351_n && block != Blocks.field_150350_a)) {
                                    drainedCount += 1.0f;
                                }
                                if (state.func_185904_a() == Material.field_151577_b) {
                                    defectivityRate -= 0.4;
                                    if (drainedChecked) continue;
                                    baseMinerals += 1.0f;
                                    continue;
                                }
                                if (state.func_185904_a() != Material.field_151595_p && state.func_185904_a() != Material.field_151578_c) continue;
                                defectivityRate -= 0.1;
                                continue;
                            }
                            catch (Exception e) {
                                KAGIC.instance.chatInfoMessage("A problem occurred when analyzing the block " + state.func_177230_c().func_149739_a() + ". It has been skipped. Please report this to HeimrArnadalr.");
                            }
                        }
                    }
                }
                drainedChecked = true;
                defectivity.put(gemClass, Math.max(0.0, defectivityRate * defectivityMultiplier));
                resultTable.put(gemClass, resultTable.get(gemClass));
                friction.put(gemClass, frictionFactor * pressureFactor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PostInjectionEvent e3 = new PostInjectionEvent(world, pos, defectivity, resultTable, friction);
        if (MinecraftForge.EVENT_BUS.post((Event)e3)) {
            return new InjectorResult();
        }
        boolean canSpawnGem = false;
        Class<? extends EntityGem> mostLikelyGem = null;
        double highestYield = 0.0;
        for (Class<EntityGem> gemClass : resultTable.keySet()) {
            if (gemClass.getName().contains("Diamond")) continue;
            boolean forget = world.field_73012_v.nextBoolean();
            if (resultTable.get(gemClass) > 0.1 && world.field_73012_v.nextInt((int)(resultTable.get(gemClass) * 10.0) + 1) == 0) {
                highestYield = resultTable.get(gemClass);
                mostLikelyGem = gemClass;
                canSpawnGem = true;
                continue;
            }
            double result = resultTable.get(gemClass);
            if (result == highestYield && result > 0.0) {
                highestYield = forget ? resultTable.get(gemClass) : highestYield;
                mostLikelyGem = forget ? gemClass : mostLikelyGem;
                canSpawnGem = true;
                continue;
            }
            if (!(result > highestYield) || !(result > 0.0)) continue;
            highestYield = resultTable.get(gemClass);
            mostLikelyGem = gemClass;
            canSpawnGem = true;
        }
        boolean mineralSpawned = false;
        if (highestYield <= 0.0 && (drainedCount - baseMinerals) / 729.0f < 0.75f) {
            ChunkPos c = world.func_175726_f(pos).func_76632_l();
            int chunkPos = (c.field_77276_a + c.field_77275_b) % ModEntities.MINERALS.size();
            mostLikelyGem = ModEntities.MINERALS.get(Math.abs(chunkPos));
            mineralSpawned = true;
            canSpawnGem = true;
        }
        EntityGem gemSpawned = null;
        if (canSpawnGem) {
            try {
                gemSpawned = (EntityGem)((Object)mostLikelyGem.getConstructors()[0].newInstance(world));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error creating gem: " + e.getMessage());
                canSpawnGem = false;
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(e4 = new GemSpawnEvent(world, pos, gemSpawned, mineralSpawned, canSpawnGem, drainedCount, baseMinerals, highestYield)))) {
            return new InjectorResult();
        }
        ExitHole exitHole = null;
        if (drain && gemSpawned != null) {
            Double gemFriction = friction.get(((Object)((Object)gemSpawned)).getClass());
            if (gemFriction == null) {
                gemFriction = 0.0;
            }
            exitHole = ExitHole.create(world, pos, Math.ceil(gemSpawned.field_70131_O), gemFriction >= 1.0);
            exitHole.emerge(world);
            gemSpawned.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        }
        if (drain) {
            for (int x = -4; x <= 4; ++x) {
                for (int y = -4; y <= 4; ++y) {
                    for (int z = -4; z <= 4; ++z) {
                        if (!world.field_73012_v.nextBoolean()) continue;
                        BlockPos ore = pos.func_177982_a(x, y, z);
                        InjectorResult.drainBlock(world, ore);
                    }
                }
            }
        }
        return new InjectorResult(gemSpawned, pos, mineralSpawned ? 1.0 : (gemSpawned == null ? 0.0 : defectivity.get(((Object)((Object)gemSpawned)).getClass())), !canSpawnGem, canSpawnGem ? friction.get(((Object)((Object)gemSpawned)).getClass()) >= 1.0 : false, exitHole);
    }

    public static void drainBlock(World world, BlockPos ore) {
        Block block;
        IBlockState state = world.func_180495_p(ore);
        DrainBlockEvent e1 = new DrainBlockEvent(world, ore, state, block = state.func_177230_c());
        if (MinecraftForge.EVENT_BUS.post((Event)e1)) {
            return;
        }
        if (block instanceof BlockBush) {
            world.func_175655_b(ore, false);
            return;
        }
        if (block == Blocks.field_150357_h) {
            return;
        }
        if (state == Blocks.field_150425_aM.func_176223_P()) {
            world.func_175656_a(ore, Blocks.field_150354_m.func_176223_P());
        } else if (state == Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT) || state == Blocks.field_150354_m.func_176223_P()) {
            world.func_175656_a(ore, Blocks.field_150351_n.func_176223_P());
        } else if (state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151578_c) {
            world.func_175656_a(ore, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
        } else if (block instanceof BlockFalling && state.func_185917_h()) {
            String oreName;
            ItemStack oreItem = new ItemStack(block);
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)oreItem);
            String string = oreName = oreIDs.length != 0 ? OreDictionary.getOreName((int)oreIDs[0]) : "";
            if (oreIDs.length != 0 && (oreName.startsWith("ore") || oreName.startsWith("gravel"))) {
                world.func_175656_a(ore, ModBlocks.DRAINED_GRAVEL.func_176223_P());
            }
        } else if ((state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151573_f || block instanceof BlockGlowstone) && (state.func_185917_h() || block instanceof BlockShulkerBox)) {
            if (block instanceof BlockShulkerBox) {
                TileEntityShulkerBox shulker = (TileEntityShulkerBox)world.func_175625_s(ore);
                shulker.func_174888_l();
                shulker.func_190579_a(true);
                shulker.func_190575_a(null);
                shulker.func_189404_a(null, 0L);
            }
            if (ore.func_177956_o() % 6 == 0 || ore.func_177956_o() % 6 == 1) {
                world.func_175656_a(ore, ModBlocks.DRAINED_BLOCK_2.func_176223_P());
            } else if (ore.func_177956_o() % 5 == 0) {
                world.func_175656_a(ore, ModBlocks.DRAINED_BANDS.func_176223_P());
            } else {
                world.func_175656_a(ore, ModBlocks.DRAINED_BLOCK.func_176223_P());
            }
        }
    }
}

