/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.util.injector;

import java.util.ArrayList;
import java.util.PriorityQueue;
import mod.akrivus.kagic.event.ExitHoleEvent;
import mod.akrivus.kagic.init.ModBlocks;
import mod.akrivus.kagic.util.injector.ExitPotential;
import mod.akrivus.kagic.util.injector.InjectorResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ExitHole {
    private final BlockPos[] blocks;
    private final boolean canCreate;
    private final boolean meltRocks;
    private final boolean xDirection;
    private final int minY;

    public ExitHole(BlockPos[] blocks, boolean canCreate, boolean meltRocks, boolean direction, int y) {
        this.blocks = blocks;
        this.canCreate = canCreate;
        this.meltRocks = meltRocks;
        this.xDirection = direction;
        this.minY = y;
    }

    public boolean canCreate() {
        return this.canCreate;
    }

    public boolean createRockMelt() {
        return this.meltRocks;
    }

    public void emerge(World world) {
        for (BlockPos block : this.blocks) {
            ExitHoleEvent e1 = new ExitHoleEvent(world, block);
            if (MinecraftForge.EVENT_BUS.post((Event)e1)) {
                return;
            }
            world.func_175655_b(block, false);
            InjectorResult.drainBlock(world, this.xDirection ? block.func_177978_c() : block.func_177974_f());
            InjectorResult.drainBlock(world, this.xDirection ? block.func_177968_d() : block.func_177976_e());
            if (block.func_177956_o() == this.minY) {
                InjectorResult.drainBlock(world, block.func_177977_b());
                if (!this.meltRocks || world.func_175623_d(block.func_177977_b())) continue;
                world.func_175656_a(block, ModBlocks.ROCK_MELT.func_176223_P());
                continue;
            }
            InjectorResult.drainBlock(world, block.func_177984_a());
        }
    }

    public static ExitHole create(World world, BlockPos pos, double height, boolean meltRocks) {
        int z;
        int light;
        boolean seesSky;
        BlockPos check;
        int x;
        ArrayList<BlockPos> blocksToDelete = new ArrayList<BlockPos>();
        PriorityQueue<ExitPotential> exitQueue = new PriorityQueue<ExitPotential>(4, new ExitPotential());
        exitQueue.add(new ExitPotential(false, 0, 10, 'o'));
        for (x = -1; x >= -9; --x) {
            check = pos.func_177982_a(x, 0, 0);
            if (!world.func_175623_d(check)) continue;
            seesSky = world.func_175678_i(check);
            light = world.func_175699_k(check);
            exitQueue.add(new ExitPotential(seesSky, light, -x, 'w'));
            break;
        }
        for (x = 1; x <= 9; ++x) {
            check = pos.func_177982_a(x, 0, 0);
            if (!world.func_175623_d(check)) continue;
            seesSky = world.func_175678_i(check);
            light = world.func_175699_k(check);
            exitQueue.add(new ExitPotential(seesSky, light, x, 'e'));
            break;
        }
        for (z = -1; z >= -9; --z) {
            check = pos.func_177982_a(0, 0, z);
            if (!world.func_175623_d(check)) continue;
            seesSky = world.func_175678_i(check);
            light = world.func_175699_k(check);
            exitQueue.add(new ExitPotential(seesSky, light, -z, 'n'));
            break;
        }
        for (z = 1; z <= 9; ++z) {
            check = pos.func_177982_a(0, 0, z);
            if (!world.func_175623_d(check)) continue;
            seesSky = world.func_175678_i(check);
            light = world.func_175699_k(check);
            exitQueue.add(new ExitPotential(seesSky, light, z, 's'));
            break;
        }
        int y = 0;
        while ((double)y < height) {
            blocksToDelete.add(pos.func_177981_b(y));
            ++y;
        }
        ExitPotential exit = exitQueue.peek();
        switch (exit.direction) {
            case 'n': {
                int y2;
                for (int z2 = 0; z2 <= exit.length; ++z2) {
                    y2 = 0;
                    while ((double)y2 < height) {
                        blocksToDelete.add(pos.func_177982_a(0, y2, -z2));
                        ++y2;
                    }
                }
                break;
            }
            case 's': {
                int y2;
                for (int z3 = 0; z3 <= exit.length; ++z3) {
                    y2 = 0;
                    while ((double)y2 < height) {
                        blocksToDelete.add(pos.func_177982_a(0, y2, z3));
                        ++y2;
                    }
                }
                break;
            }
            case 'e': {
                int y2;
                for (int x2 = 0; x2 <= exit.length; ++x2) {
                    y2 = 0;
                    while ((double)y2 < height) {
                        blocksToDelete.add(pos.func_177982_a(x2, y2, 0));
                        ++y2;
                    }
                }
                break;
            }
            case 'w': {
                int y2;
                for (int x3 = 0; x3 <= exit.length; ++x3) {
                    y2 = 0;
                    while ((double)y2 < height) {
                        blocksToDelete.add(pos.func_177982_a(-x3, y2, 0));
                        ++y2;
                    }
                }
                break;
            }
        }
        boolean xDirection = exit.direction == 'e' || exit.direction == 'w';
        return new ExitHole(blocksToDelete.toArray(new BlockPos[0]), (double)blocksToDelete.size() <= height, meltRocks, xDirection, pos.func_177956_o());
    }
}

