/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import mod.akrivus.kagic.tileentity.TileEntityGalaxyPadCore;
import mod.akrivus.kagic.tileentity.TileEntityWarpPadCore;
import mod.heimrarnadalr.kagic.worlddata.GalaxyPadLocation;
import mod.heimrarnadalr.kagic.worlddata.WarpPadDataEntry;
import mod.heimrarnadalr.kagic.worlddata.WorldDataGalaxyPad;
import mod.heimrarnadalr.kagic.worlddata.WorldDataWarpPad;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;

public class Warp
extends Speak<EntityGem> {
    public Warp() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("warp", "go"));
        this.TRIGGER_NOUNS = new ArrayList();
        this.can(SkillBase.RunWith.LOOKING);
        this.priority(SkillBase.Priority.LOW);
        this.task(false);
    }

    @Override
    public boolean proceed(EntityGem gem) {
        TileEntityWarpPadCore pad = TileEntityWarpPadCore.getEntityPad((Entity)gem);
        return pad != null && pad.isValidPad() && !pad.isWarping();
    }

    @Override
    public void init(EntityGem gem) {
        TileEntityWarpPadCore pad = TileEntityWarpPadCore.getEntityPad((Entity)gem);
        if (pad != null && pad.isValidPad() && !pad.isWarping()) {
            if (!pad.isValid()) {
                gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.padnotvalid", new Object[0]).func_150261_e());
                return;
            }
            if (!pad.isClear()) {
                gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.padnotclear", new Object[0]).func_150261_e());
                return;
            }
            if (this.entireMessage.toLowerCase().contains(pad.name.toLowerCase())) {
                gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.alreadyhere", new Object[0]).func_150261_e());
                return;
            }
            if (pad instanceof TileEntityGalaxyPadCore) {
                Map<GalaxyPadLocation, WarpPadDataEntry> padData = WorldDataGalaxyPad.get(gem.field_70170_p).getGalaxyPadData();
                SortedMap<Double, GalaxyPadLocation> sortedPoses = WorldDataGalaxyPad.getSortedPositions(padData, pad.func_174877_v());
                for (GalaxyPadLocation dest : sortedPoses.values()) {
                    WarpPadDataEntry data = padData.get(dest);
                    if (!this.entireMessage.toLowerCase().contains(data.name.toLowerCase())) continue;
                    if (!data.valid) {
                        gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.destnotvalid", new Object[0]).func_150261_e());
                        return;
                    }
                    if (!data.clear) {
                        gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.destnotclear", new Object[0]).func_150261_e());
                        return;
                    }
                    gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.warping", new Object[]{data.name}).func_150261_e());
                    gem.playObeySound();
                    ((TileEntityGalaxyPadCore)pad).beginWarp(dest);
                    return;
                }
            } else {
                Map<BlockPos, WarpPadDataEntry> padData = WorldDataWarpPad.get(gem.field_70170_p).getWarpPadData();
                SortedMap<Double, BlockPos> sortedPoses = WorldDataWarpPad.getSortedPositions(padData, pad.func_174877_v());
                for (BlockPos pos : sortedPoses.values()) {
                    WarpPadDataEntry data = padData.get(pos);
                    if (!this.entireMessage.toLowerCase().contains(data.name.toLowerCase())) continue;
                    TileEntityWarpPadCore dest = (TileEntityWarpPadCore)gem.func_130014_f_().func_175625_s(pos);
                    if (!dest.isValid()) {
                        gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.destnotvalid", new Object[0]).func_150261_e());
                        return;
                    }
                    if (!dest.isClear()) {
                        gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.destnotclear", new Object[0]).func_150261_e());
                        return;
                    }
                    gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.warping", new Object[]{data.name}).func_150261_e());
                    gem.playObeySound();
                    pad.beginWarp(pos);
                    return;
                }
            }
            gem.feedback(this.commandingPlayer, new TextComponentTranslation("notify.kagic.nopad", new Object[]{"this"}).func_150261_e());
        }
    }

    public String toString() {
        return "warping";
    }
}

