/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.gem.EntitySapphire;
import mod.akrivus.kagic.event.FutureVisionEvent;
import mod.akrivus.kagic.event.RetroVisionEvent;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemSword;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TellFuture
extends Speak<EntitySapphire> {
    public TellFuture() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("tell", "give"));
        this.TRIGGER_NOUNS = new ArrayList<String>(Arrays.asList("future", "sign", "vision"));
        this.can(SkillBase.RunWith.EVERYTHING);
        this.priority(SkillBase.Priority.LOW);
        this.task(false);
    }

    @Override
    public boolean proceed(EntitySapphire gem) {
        return true;
    }

    @Override
    public void init(EntitySapphire gem) {
        if (gem.isDefective()) {
            World world = gem.field_70170_p;
            RetroVisionEvent event = new RetroVisionEvent(gem, this.commandingPlayer);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            if (world.field_73012_v.nextInt(100) == 0 && world.field_73012_v.nextBoolean()) {
                this.sendMessage(gem, "wallbreaker");
            } else if (gem.getOwner().field_70173_aa < 100) {
                this.sendMessage(gem, "died");
            } else if (gem.getOwner().func_70027_ad()) {
                this.sendMessage(gem, "fire");
            } else if (gem.getOwner().func_70090_H()) {
                this.sendMessage(gem, "water");
            } else if (world.func_72896_J()) {
                if (!world.func_175708_f(gem.func_180425_c(), false)) {
                    this.sendMessage(gem, "rain");
                } else {
                    this.sendMessage(gem, "snow");
                }
            } else if (gem.getOwner().func_94060_bK() != null) {
                this.sendMessage(gem, "hurt_by", gem.getOwner().func_94060_bK().func_70005_c_());
            } else if (world.func_72820_D() < 600L) {
                this.sendMessage(gem, "sunrise");
            } else if (world.func_72820_D() > 600L && world.func_72820_D() < 6000L) {
                this.sendMessage(gem, "noon");
            } else if (world.func_72820_D() > 6000L && world.func_72820_D() < 14000L) {
                this.sendMessage(gem, "sunset");
            } else if (world.func_72820_D() > 14000L && world.func_72820_D() < 22000L) {
                this.sendMessage(gem, "night");
            } else if (world.func_72820_D() > 22000L) {
                this.sendMessage(gem, "moonset");
            } else {
                this.sendMessage(gem, "none");
            }
        } else {
            World world = gem.field_70170_p;
            FutureVisionEvent event = new FutureVisionEvent(gem, this.commandingPlayer);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            boolean sent = false;
            if (world.field_73012_v.nextInt(100) == 0 && world.field_73012_v.nextBoolean() && KAGIC.isBirthdayTomorrow()) {
                this.sendMessage(gem, "birthday");
                sent = true;
            }
            List list = gem.field_70170_p.func_72872_a(EntityLivingBase.class, gem.func_174813_aQ().func_72314_b(24.0, 8.0, 24.0));
            double maxDistance = Double.MAX_VALUE;
            for (EntityLivingBase weirdo : list) {
                EntityMob possibleAttacker;
                double newDistance = weirdo.func_70068_e((Entity)gem);
                if (!(newDistance <= maxDistance)) continue;
                maxDistance = newDistance;
                if (gem.isOwner(weirdo)) continue;
                if (weirdo instanceof EntityGem) {
                    EntityGem possibleRebel = (EntityGem)weirdo;
                    if (!gem.isOwner((EntityLivingBase)possibleRebel.getOwner()) || !possibleRebel.isTraitor()) continue;
                    this.sendMessage(gem, "rebel", possibleRebel.func_70005_c_());
                    sent = true;
                    continue;
                }
                if (weirdo instanceof EntityMob) {
                    possibleAttacker = (EntityMob)weirdo;
                    if (possibleAttacker.func_70638_az() == null || !possibleAttacker.func_70638_az().equals((Object)gem.getOwner())) continue;
                    this.sendMessage(gem, "attacker", possibleAttacker.func_70005_c_());
                    sent = true;
                    continue;
                }
                if (!(weirdo instanceof EntityPlayer) || !((possibleAttacker = (EntityPlayer)weirdo).func_184614_ca().func_77973_b() instanceof ItemSword) && !(possibleAttacker.func_184614_ca().func_77973_b() instanceof ItemBow)) continue;
                this.sendMessage(gem, "attacker", possibleAttacker.func_70005_c_());
                sent = true;
            }
            if (!sent) {
                this.sendMessage(gem, "none");
            }
        }
    }

    private void sendMessage(EntitySapphire sapphire, String line, String formatting) {
        sapphire.feedback(this.commandingPlayer, new TextComponentTranslation("command.kagic." + (sapphire.isDefective() ? "padparadscha" : "sapphire") + "_" + line, new Object[]{formatting}).func_150260_c());
    }

    private void sendMessage(EntitySapphire sapphire, String line) {
        sapphire.feedback(this.commandingPlayer, new TextComponentTranslation("command.kagic." + (sapphire.isDefective() ? "padparadscha" : "sapphire") + "_" + line, new Object[0]).func_150260_c());
    }

    public String toString() {
        return "telling the future";
    }
}

