/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import mod.akrivus.kagic.entity.gem.EntityPearl;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;

public class SingSong
extends Speak<EntityPearl> {
    private String song = "543578743857348";
    private int lastIndex = 0;
    private long lastNote = 0L;
    private int noteSleep = 0;
    private int iteration = 0;

    public SingSong() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("sing", "play"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.EVERYTHING);
        this.task(true);
    }

    @Override
    public boolean proceed(EntityPearl gem) {
        return this.iteration < 4;
    }

    @Override
    public void init(EntityPearl gem) {
        boolean previous = this.isAllowedToRun;
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.song = (String)this.collectedNumbers.get(0);
            }
            catch (Exception ex) {
                this.song = gem.soulSong;
            }
        }
    }

    @Override
    public void run(EntityPearl gem) {
        try {
            if (gem.field_70170_p.func_72820_D() - this.lastNote > (long)this.noteSleep) {
                if (this.lastIndex < this.song.length()) {
                    int tone = Integer.parseInt(Character.toString(this.song.charAt(this.lastIndex)));
                    this.noteSleep = gem.playNote(tone);
                } else {
                    this.lastIndex = -1;
                    ++this.iteration;
                }
                this.lastNote = gem.field_70170_p.func_72820_D();
                ++this.lastIndex;
            }
        }
        catch (Exception e) {
            this.isAllowedToRun = false;
        }
    }

    @Override
    public void reset(EntityPearl gem) {
        this.lastIndex = 0;
        this.lastNote = 0L;
        this.noteSleep = 0;
        this.iteration = 0;
    }

    public String toString() {
        return "singing";
    }
}

