/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import mod.akrivus.kagic.entity.gem.EntityPearl;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class PlantSaplingsPearl
extends Speak<EntityPearl> {
    private BlockPos plantLocation = null;
    private int goal = 4;
    private int amountBeforeGoal = 0;
    private int lastBlockBreak = 0;

    public PlantSaplingsPearl() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("plant", "place", "locate", "grow", "farm"));
        this.TRIGGER_NOUNS = new ArrayList<String>(Arrays.asList("sapling", "saplings", "tree", "trees"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean triggered(EntityPearl gem) {
        boolean previous = this.isAllowedToRun;
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.goal = Integer.parseInt((String)this.collectedNumbers.get(0));
            }
            catch (Exception ex) {
                this.goal = 4;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityPearl gem) {
        return this.plantLocation != null && this.amountBeforeGoal < this.goal;
    }

    @Override
    public void init(EntityPearl gem) {
        ArrayList<BlockPos> places = new ArrayList<BlockPos>();
        for (int x = -16; x < 16; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -16; z < 16; ++z) {
                    BlockPos above;
                    IBlockState state = gem.field_70170_p.func_180495_p(gem.func_180425_c().func_177982_a(x, y, z));
                    if (!this.isCorrectBlock(state)) continue;
                    BlockPos place = gem.func_180425_c().func_177982_a(x, y, z);
                    if (this.plantLocation != null && (!(this.plantLocation.func_185332_f(place.func_177958_n(), place.func_177956_o(), place.func_177952_p()) > 6.0) || !this.hasSapling(gem)) || !gem.field_70170_p.func_175623_d(above = place.func_177984_a())) continue;
                    places.add(above);
                }
            }
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < places.size(); ++i) {
            double distance = gem.func_174831_c((BlockPos)places.get(i));
            if (!(distance < minDistance)) continue;
            this.plantLocation = (BlockPos)places.get(i);
            minDistance = distance;
        }
    }

    @Override
    public void run(EntityPearl gem) {
        if (this.plantLocation != null) {
            BlockPos lookPos = this.plantLocation.func_177977_b();
            gem.lookAt(lookPos);
            if (gem.func_174831_c(this.plantLocation) < 5.0) {
                if (this.lastBlockBreak > 20) {
                    boolean placed = gem.field_70170_p.func_180501_a(this.plantLocation, Block.func_149634_a((Item)this.getSapling(gem).func_77973_b()).func_176223_P(), 3);
                    if (placed) {
                        if (this.goal > 0) {
                            ++this.amountBeforeGoal;
                            this.getSapling(gem).func_190918_g(1);
                        }
                        if (this.amountBeforeGoal < this.goal) {
                            this.init(gem);
                        }
                    }
                    this.lastBlockBreak = 0;
                }
                ++this.lastBlockBreak;
            } else {
                gem.tryToMoveTo(this.plantLocation);
            }
        }
    }

    @Override
    public void reset(EntityPearl gem) {
        this.amountBeforeGoal = 0;
        this.goal = 0;
    }

    public boolean isCorrectBlock(IBlockState state) {
        return state.func_177230_c() instanceof BlockGrass;
    }

    public String toString() {
        return "planting trees";
    }

    public ItemStack getSapling(EntityPearl gem) {
        InventoryBasic inventory = gem.gemStorage;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            Item item = inventory.func_70301_a(i).func_77973_b();
            if (item != Item.func_150898_a((Block)Blocks.field_150345_g)) continue;
            return inventory.func_70301_a(i);
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasSapling(EntityPearl gem) {
        InventoryBasic inventory = gem.gemStorage;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            Item item = inventory.func_70301_a(i).func_77973_b();
            if (item != Item.func_150898_a((Block)Blocks.field_150345_g)) continue;
            return true;
        }
        return false;
    }
}

