/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class MowGrass
extends Speak<EntityGem> {
    private BlockPos grassLocation = null;
    private int lastBlockBreak = 0;

    public MowGrass() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("mow", "cut"));
        this.TRIGGER_NOUNS = new ArrayList<String>(Arrays.asList("grass", "lawn", "yard"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean proceed(EntityGem gem) {
        return this.grassLocation != null && gem.func_70685_l((Entity)this.commandingPlayer);
    }

    @Override
    public void init(EntityGem gem) {
        ArrayList<BlockPos> flowers = new ArrayList<BlockPos>();
        for (int x = -16; x < 16; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -16; z < 16; ++z) {
                    IBlockState state = gem.field_70170_p.func_180495_p(gem.func_180425_c().func_177982_a(x, y, z));
                    if (!this.isCorrectBlock(state)) continue;
                    BlockPos flower = gem.func_180425_c().func_177982_a(x, y, z);
                    flowers.add(flower);
                }
            }
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < flowers.size(); ++i) {
            double distance = gem.func_174831_c((BlockPos)flowers.get(i));
            if (!(distance < minDistance)) continue;
            this.grassLocation = (BlockPos)flowers.get(i);
            minDistance = distance;
        }
    }

    @Override
    public void run(EntityGem gem) {
        if (this.grassLocation != null) {
            BlockPos lookPos = this.grassLocation.func_177977_b();
            gem.lookAt(lookPos);
            if (gem.func_174831_c(this.grassLocation) < 5.0) {
                if (this.lastBlockBreak > 10) {
                    boolean picked = gem.breakBlock(this.grassLocation);
                    if (picked) {
                        this.init(gem);
                    }
                    this.lastBlockBreak = 0;
                }
                ++this.lastBlockBreak;
            } else {
                gem.tryToMoveTo(this.grassLocation);
            }
        }
    }

    @Override
    public void reset(EntityGem gem) {
        this.grassLocation = null;
    }

    public boolean isCorrectBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150329_H || block == Blocks.field_150398_cm && state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.GRASS;
    }

    public String toString() {
        return "moving grass";
    }
}

