/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.gem.EntityPearl;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.util.math.BlockPos;

public class Mine
extends Speak<EntityGem> {
    private BlockPos blockLocation = null;
    private int goal = 64;
    private int amountBeforeGoal = 0;
    private int lastBlockBreak = 0;
    private boolean cut = false;

    public Mine() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("mine", "gather", "find", "get"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean triggered(EntityGem gem) {
        boolean previous = this.isAllowedToRun;
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.goal = Integer.parseInt((String)this.collectedNumbers.get(0));
            }
            catch (Exception ex) {
                this.goal = 64;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityGem gem) {
        boolean hasPearl = gem instanceof EntityPearl;
        if (this.blockLocation != null && this.amountBeforeGoal < this.goal && gem.func_184614_ca().func_77973_b() instanceof ItemPickaxe) {
            if (!hasPearl) {
                List list = gem.field_70170_p.func_72872_a(EntityPearl.class, gem.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                for (EntityPearl entity : list) {
                    if (!entity.isOwnedBySamePeople(gem)) continue;
                    hasPearl = true;
                }
            }
            return hasPearl && !this.cut;
        }
        return false;
    }

    @Override
    public void init(EntityGem gem) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (int x = -16; x < 16; ++x) {
            for (int y = -16; y < 16; ++y) {
                for (int z = -16; z < 16; ++z) {
                    IBlockState state = gem.field_70170_p.func_180495_p(gem.func_180425_c().func_177982_a(x, y, z));
                    if (!this.isCorrectBlock(state)) continue;
                    blocks.add(gem.func_180425_c().func_177982_a(x, y, z));
                }
            }
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < blocks.size(); ++i) {
            double distance = gem.func_174831_c((BlockPos)blocks.get(i));
            if (!(distance < minDistance)) continue;
            this.blockLocation = (BlockPos)blocks.get(i);
            minDistance = distance;
        }
    }

    @Override
    public void run(EntityGem gem) {
        if (this.blockLocation != null) {
            gem.func_70671_ap().func_75650_a((double)this.blockLocation.func_177958_n(), (double)this.blockLocation.func_177956_o(), (double)this.blockLocation.func_177952_p(), 30.0f, 30.0f);
            if (gem.func_174818_b(this.blockLocation) < 5.0) {
                if (this.lastBlockBreak > 20) {
                    boolean cut = gem.breakBlock(this.blockLocation);
                    if (cut) {
                        ++this.amountBeforeGoal;
                    }
                    this.cut = cut;
                    this.lastBlockBreak = 0;
                }
                ++this.lastBlockBreak;
            } else {
                gem.tryToMoveTo(this.blockLocation);
            }
            if (this.amountBeforeGoal < this.goal) {
                this.blockLocation = null;
                this.cut = false;
                this.init(gem);
            }
        }
    }

    @Override
    public void reset(EntityGem gem) {
        this.blockLocation = null;
        this.amountBeforeGoal = 0;
        this.goal = 0;
        this.cut = false;
    }

    public boolean isCorrectBlock(IBlockState state) {
        return state.func_177230_c().func_149732_F().toLowerCase().contains(this.selectedNoun);
    }

    public String toString() {
        return "mining " + this.selectedNoun;
    }
}

