/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class MilkCows
extends Speak<EntityGem> {
    private EntityCow otherCow = null;
    private int lastHitTime = 0;

    public MilkCows() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("collect", "grab", "get"));
        this.TRIGGER_NOUNS = new ArrayList<String>(Arrays.asList("milk", "cows", "cow"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.TARGETTING);
        this.task(true);
    }

    @Override
    public boolean proceed(EntityGem gem) {
        return this.otherCow != null && this.otherCow.func_70874_b() == 0 && gem.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151133_ar && gem.isSoldier;
    }

    @Override
    public void init(EntityGem gem) {
        List cows = gem.field_70170_p.func_175647_a(EntityCow.class, gem.func_174813_aQ().func_72314_b(16.0, 8.0, 16.0), null);
        if (!cows.isEmpty()) {
            double minDistance = Double.MAX_VALUE;
            for (EntityCow cow : cows) {
                double distance = gem.func_70068_e((Entity)cow);
                if (!(gem.func_70068_e((Entity)cow) < minDistance) || cow.func_70874_b() != 0 || cow.func_70880_s()) continue;
                this.otherCow = cow;
                minDistance = distance;
            }
        }
    }

    @Override
    public void run(EntityGem gem) {
        if (this.otherCow != null) {
            gem.lookAt((Entity)this.otherCow);
            if (gem.func_70068_e((Entity)this.otherCow) < 5.0) {
                if (this.lastHitTime > 5) {
                    gem.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151117_aB));
                    this.lastHitTime = 0;
                }
                ++this.lastHitTime;
            } else {
                gem.tryToMoveTo(this.otherCow.func_180425_c());
            }
        }
    }

    @Override
    public void reset(EntityGem gem) {
        this.otherCow = null;
    }

    public String toString() {
        return "milking " + this.otherCow.func_70005_c_();
    }
}

