/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.linguistics.LinguisticsHelper;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class KillOtherEntities
extends Speak<EntityGem> {
    private EntityLivingBase otherEntity = null;
    private int goal = 1;
    private int amountBeforeGoal = 0;

    public KillOtherEntities() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("kill", "destroy", "slay", "hunt", "find", "catch"));
        this.TRIGGER_NOUNS = new ArrayList();
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.TARGETTING);
        this.task(true);
    }

    @Override
    public boolean triggered(EntityGem gem) {
        boolean previous = this.isAllowedToRun;
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.goal = Integer.parseInt((String)this.collectedNumbers.get(0));
            }
            catch (Exception ex) {
                this.goal = 1;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityGem gem) {
        return this.otherEntity != null && this.amountBeforeGoal < this.goal;
    }

    @Override
    public void init(EntityGem gem) {
        List entities = gem.field_70170_p.func_175647_a(EntityLivingBase.class, gem.func_174813_aQ().func_72314_b(16.0, 8.0, 16.0), null);
        if (!entities.isEmpty()) {
            double minDistance = Double.MAX_VALUE;
            for (EntityLivingBase entity : entities) {
                double distance = gem.func_70068_e((Entity)entity);
                if (!(gem.func_70068_e((Entity)entity) < minDistance) || gem.equals(entity) || LinguisticsHelper.getDistance(entity.func_70005_c_(), this.selectedNoun) >= 3) continue;
                this.otherEntity = entity;
                minDistance = distance;
            }
        }
        if (this.otherEntity != null) {
            gem.func_70624_b(this.otherEntity);
        }
    }

    @Override
    public void run(EntityGem gem) {
        if (this.otherEntity != null && this.otherEntity.field_70128_L) {
            ++this.amountBeforeGoal;
        }
        if (this.amountBeforeGoal < this.goal) {
            this.init(gem);
        }
    }

    @Override
    public void reset(EntityGem gem) {
        this.otherEntity = null;
        this.amountBeforeGoal = 0;
        this.goal = 0;
    }

    public String toString() {
        return "killing " + this.otherEntity.func_70005_c_();
    }
}

