/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import mod.akrivus.kagic.entity.gem.EntityPeridot;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public class HarvestAndReplant
extends Speak<EntityPeridot> {
    private BlockPos harvestLocation = null;
    private int goal = 0;
    private int amountBeforeGoal = 0;
    private int lastBlockBreak = 0;

    public HarvestAndReplant() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("collect", "plant", "pull", "get", "cut"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean triggered(EntityPeridot gem) {
        boolean previous = this.isAllowedToRun;
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.goal = Integer.parseInt((String)this.collectedNumbers.get(0));
            }
            catch (Exception ex) {
                this.goal = 0;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityPeridot gem) {
        return this.harvestLocation != null && this.amountBeforeGoal <= this.goal && gem.isFarmer();
    }

    @Override
    public void init(EntityPeridot gem) {
        ArrayList<BlockPos> plants = new ArrayList<BlockPos>();
        this.harvestLocation = null;
        for (int x = -16; x < 16; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -16; z < 16; ++z) {
                    BlockPos above;
                    IBlockState state = gem.field_70170_p.func_180495_p(gem.func_180425_c().func_177982_a(x, y, z));
                    if (!this.isCorrectFarmBlock(state) || !this.isCorrectPlant(gem.field_70170_p.func_180495_p(above = gem.func_180425_c().func_177982_a(x, y + 1, z))) && !gem.field_70170_p.func_175623_d(above)) continue;
                    plants.add(above);
                }
            }
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < plants.size(); ++i) {
            double distance = gem.func_174831_c((BlockPos)plants.get(i));
            if (!(distance < minDistance)) continue;
            this.harvestLocation = (BlockPos)plants.get(i);
            minDistance = distance;
        }
    }

    @Override
    public void run(EntityPeridot gem) {
        if (this.harvestLocation != null) {
            BlockPos lookPos = this.harvestLocation.func_177977_b();
            gem.lookAt(lookPos);
            if (gem.func_174831_c(this.harvestLocation) < 5.0) {
                IBlockState harvest = gem.field_70170_p.func_180495_p(this.harvestLocation);
                if (this.lastBlockBreak > 20) {
                    boolean success = false;
                    if (gem.field_70170_p.func_175623_d(this.harvestLocation) && this.hasSeeds(gem)) {
                        gem.func_184611_a(EnumHand.OFF_HAND, this.getSeed(gem).func_77946_l());
                        gem.placeBlock(this.getPlant(gem), this.harvestLocation);
                        this.getSeed(gem).func_190918_g(1);
                    } else if (this.isCorrectPlant(harvest)) {
                        success = gem.field_70170_p.func_175655_b(this.harvestLocation, true);
                    } else {
                        this.init(gem);
                    }
                    if (success) {
                        if (this.goal > 0) {
                            ++this.amountBeforeGoal;
                        }
                        if (this.amountBeforeGoal <= this.goal) {
                            this.init(gem);
                        }
                    }
                    this.lastBlockBreak = 0;
                }
                ++this.lastBlockBreak;
            } else {
                gem.tryToMoveTo(this.harvestLocation);
            }
        }
    }

    @Override
    public void reset(EntityPeridot gem) {
        this.harvestLocation = null;
        this.amountBeforeGoal = 0;
        this.goal = 0;
    }

    public boolean isCorrectFarmBlock(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public boolean isCorrectPlant(IBlockState state) {
        return state.func_177230_c().func_149739_a().contains(this.selectedNoun) && ((BlockCrops)state.func_177230_c()).func_185525_y(state);
    }

    public IBlockState getPlant(EntityPeridot gem) {
        return ((IPlantable)this.getSeed(gem).func_77973_b()).getPlant((IBlockAccess)gem.field_70170_p, this.harvestLocation);
    }

    public ItemStack getSeed(EntityPeridot gem) {
        InventoryBasic inventory = gem.gemStorage;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            Item item = inventory.func_70301_a(i).func_77973_b();
            if (!item.func_77658_a().contains(this.selectedNoun) || !(item instanceof ItemSeeds) && !(item instanceof ItemSeedFood)) continue;
            return inventory.func_70301_a(i);
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasSeeds(EntityPeridot gem) {
        InventoryBasic inventory = gem.gemStorage;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            Item item = inventory.func_70301_a(i).func_77973_b();
            if (!item.func_77658_a().contains(this.selectedNoun) || !(item instanceof ItemSeeds) && !(item instanceof ItemSeedFood)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "harvesting " + this.selectedNoun;
    }
}

