/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.gem.EntityPearl;
import mod.akrivus.kagic.entity.gem.EntityPeridot;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class Harvest
extends Speak<EntityGem> {
    private BlockPos harvestLocation = null;
    private int goal = 0;
    private int amountBeforeGoal = 0;
    private int lastBlockBreak = 0;
    private boolean cut = false;

    public Harvest() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("collect", "plant", "pull", "get", "cut"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean triggered(EntityGem gem) {
        boolean previous = this.isAllowedToRun;
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.goal = Integer.parseInt((String)this.collectedNumbers.get(0));
            }
            catch (Exception ex) {
                this.goal = 0;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityGem gem) {
        boolean hasPearl;
        boolean bl = hasPearl = gem instanceof EntityPearl || gem instanceof EntityPeridot;
        if (this.harvestLocation != null && this.amountBeforeGoal <= this.goal) {
            if (!hasPearl) {
                List list = gem.field_70170_p.func_72872_a(EntityPearl.class, gem.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                for (EntityPearl entity : list) {
                    if (!entity.isOwnedBySamePeople(gem)) continue;
                    hasPearl = true;
                }
            }
            return hasPearl && !this.cut;
        }
        return false;
    }

    @Override
    public void init(EntityGem gem) {
        ArrayList<BlockPos> plants = new ArrayList<BlockPos>();
        this.harvestLocation = null;
        for (int x = -16; x < 16; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -16; z < 16; ++z) {
                    BlockPos above;
                    IBlockState state = gem.field_70170_p.func_180495_p(gem.func_180425_c().func_177982_a(x, y, z));
                    if (!this.isCorrectFarmBlock(state) || !this.isCorrectPlant(gem.field_70170_p.func_180495_p(above = gem.func_180425_c().func_177982_a(x, y + 1, z)))) continue;
                    plants.add(above);
                }
            }
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < plants.size(); ++i) {
            double distance = gem.func_174831_c((BlockPos)plants.get(i));
            if (!(distance < minDistance)) continue;
            this.harvestLocation = (BlockPos)plants.get(i);
            minDistance = distance;
        }
    }

    @Override
    public void run(EntityGem gem) {
        if (this.harvestLocation != null) {
            BlockPos lookPos = this.harvestLocation.func_177977_b();
            gem.lookAt(lookPos);
            if (gem.func_174831_c(this.harvestLocation) < 5.0) {
                IBlockState harvest = gem.field_70170_p.func_180495_p(this.harvestLocation);
                if (this.lastBlockBreak > 20) {
                    boolean success = false;
                    if (this.isCorrectPlant(harvest)) {
                        this.cut = success = gem.field_70170_p.func_175655_b(this.harvestLocation, true);
                    } else {
                        this.init(gem);
                    }
                    if (success) {
                        if (this.goal > 0) {
                            ++this.amountBeforeGoal;
                        }
                        if (this.amountBeforeGoal <= this.goal) {
                            this.harvestLocation = null;
                            this.cut = false;
                            this.init(gem);
                        }
                    }
                    this.lastBlockBreak = 0;
                }
                ++this.lastBlockBreak;
            } else {
                gem.tryToMoveTo(this.harvestLocation);
            }
        }
    }

    @Override
    public void reset(EntityGem gem) {
        this.harvestLocation = null;
        this.amountBeforeGoal = 0;
        this.goal = 0;
        this.cut = false;
    }

    public boolean isCorrectFarmBlock(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public boolean isCorrectPlant(IBlockState state) {
        return state.func_177230_c().func_149739_a().contains(this.selectedNoun) && ((BlockCrops)state.func_177230_c()).func_185525_y(state);
    }

    public String toString() {
        return "harvesting " + this.selectedNoun;
    }
}

