/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import mod.akrivus.kagic.entity.gem.EntityBismuth;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FetchChestsBismuth
extends Speak<EntityBismuth> {
    private BlockPos chestLocation = null;
    private boolean fetched = false;

    public FetchChestsBismuth() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("fetch", "grab", "get"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean proceed(EntityBismuth gem) {
        return this.chestLocation != null && !this.fetched;
    }

    @Override
    public void init(EntityBismuth gem) {
        ArrayList<BlockPos> chests = new ArrayList<BlockPos>();
        this.chestLocation = null;
        for (int x = -16; x < 16; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -16; z < 16; ++z) {
                    IBlockState state = gem.field_70170_p.func_180495_p(gem.func_180425_c().func_177982_a(x, y, z));
                    if (!this.isCorrectBlock(gem.field_70170_p, gem.func_180425_c().func_177982_a(x, y, z), state)) continue;
                    chests.add(gem.func_180425_c().func_177982_a(x, y, z));
                }
            }
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < chests.size(); ++i) {
            double distance = gem.func_174831_c((BlockPos)chests.get(i));
            if (!(distance < minDistance)) continue;
            this.chestLocation = (BlockPos)chests.get(i);
            minDistance = distance;
        }
    }

    @Override
    public void run(EntityBismuth gem) {
        if (this.chestLocation != null) {
            BlockPos lookPos = this.chestLocation.func_177977_b();
            gem.lookAt(lookPos);
            if (gem.func_174831_c(this.chestLocation) < 5.0) {
                TileEntityLockableLoot te = (TileEntityLockableLoot)gem.field_70170_p.func_175625_s(this.chestLocation);
                int y = 0;
                for (int x = 0; x < gem.gemStorage.func_70302_i_(); ++x) {
                    if (!gem.gemStorage.func_70301_a(x).func_190926_b() || te.func_70301_a(y).func_190926_b()) continue;
                    gem.gemStorage.func_70299_a(x, te.func_70304_b(y));
                    gem.func_76316_a((IInventory)gem.gemStorage);
                    ++y;
                }
                this.fetched = true;
            } else {
                gem.tryToMoveTo(this.chestLocation);
            }
        }
    }

    @Override
    public void reset(EntityBismuth gem) {
        this.chestLocation = null;
        this.fetched = false;
    }

    public boolean isCorrectBlock(World world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() instanceof BlockContainer && world.func_175625_s(pos) instanceof TileEntityLockableLoot;
    }

    public String toString() {
        return "getting things";
    }
}

