/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.gem.EntityPearl;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemAxe;
import net.minecraft.util.math.BlockPos;

public class CutDownTrees
extends Speak<EntityGem> {
    private BlockPos treeLocation = null;
    private boolean cuttingDownTrees = true;
    private boolean countTreesNotWood = true;
    private int goal = 1;
    private int amountBeforeGoal = 0;
    private int lastBlockBreak = 0;
    private boolean cut = false;

    public CutDownTrees() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("cut", "chop", "find", "get"));
        this.TRIGGER_NOUNS = new ArrayList<String>(Arrays.asList("trees", "tree", "wood", "log", "logs"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean triggered(EntityGem gem) {
        boolean previous = this.isAllowedToRun;
        if (previous) {
            if (!this.collectedNumbers.isEmpty()) {
                try {
                    this.goal = Integer.parseInt((String)this.collectedNumbers.get(0));
                }
                catch (Exception ex) {
                    this.goal = 2;
                }
            }
            if (this.selectedNoun.startsWith("tree")) {
                this.countTreesNotWood = true;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityGem gem) {
        boolean hasPearl = gem instanceof EntityPearl;
        if (this.treeLocation != null && (this.cuttingDownTrees || this.amountBeforeGoal < this.goal) && gem.func_184614_ca().func_77973_b() instanceof ItemAxe) {
            if (!hasPearl) {
                List list = gem.field_70170_p.func_72872_a(EntityPearl.class, gem.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                for (EntityPearl entity : list) {
                    if (!entity.isOwnedBySamePeople(gem) || entity.isSitting()) continue;
                    hasPearl = true;
                }
            }
            return hasPearl && !this.cut;
        }
        return false;
    }

    @Override
    public void init(EntityGem gem) {
        ArrayList<BlockPos> trees = new ArrayList<BlockPos>();
        ArrayList<float[]> points = new ArrayList<float[]>();
        for (int x = -16; x < 16; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -16; z < 16; ++z) {
                    IBlockState state = gem.field_70170_p.func_180495_p(gem.func_180425_c().func_177982_a(x, y, z));
                    if (!this.isCorrectBlock(state)) continue;
                    for (int i = 0; i < 64; ++i) {
                        Block top = gem.field_70170_p.func_180495_p(gem.func_180425_c().func_177982_a(x, y + i, z)).func_177230_c();
                        if (!(top instanceof BlockLeaves)) continue;
                        BlockPos tree = gem.func_180425_c().func_177982_a(x, y - 1, z);
                        if (trees.contains(new float[]{tree.func_177958_n(), tree.func_177952_p()})) continue;
                        points.add(new float[]{tree.func_177958_n(), tree.func_177952_p()});
                        trees.add(tree);
                    }
                }
            }
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < trees.size(); ++i) {
            double distance = gem.func_174831_c((BlockPos)trees.get(i));
            if (!(distance < minDistance)) continue;
            this.treeLocation = (BlockPos)trees.get(i);
            minDistance = distance;
        }
    }

    @Override
    public void run(EntityGem gem) {
        if (this.treeLocation != null) {
            BlockPos nextPos = this.treeLocation.func_177982_a(0, 1, 0);
            gem.func_70671_ap().func_75650_a((double)nextPos.func_177958_n(), (double)nextPos.func_177956_o(), (double)nextPos.func_177952_p(), 30.0f, 30.0f);
            if (gem.func_174831_c(this.treeLocation.func_177979_c((int)((double)this.treeLocation.func_177956_o() - gem.field_70163_u))) < 5.0) {
                if (this.lastBlockBreak > 20) {
                    while (gem.field_70170_p.func_180495_p(nextPos).func_177230_c() instanceof BlockLog) {
                        boolean cut;
                        this.cut = cut = gem.breakBlock(nextPos);
                        nextPos = nextPos.func_177981_b(1);
                    }
                    ++this.amountBeforeGoal;
                    this.lastBlockBreak = 0;
                }
                ++this.lastBlockBreak;
            } else {
                gem.tryToMoveTo(this.treeLocation);
            }
            if (this.amountBeforeGoal < this.goal && this.cut) {
                this.cuttingDownTrees = true;
                this.treeLocation = null;
                this.cut = false;
                this.init(gem);
            }
        } else {
            this.cuttingDownTrees = false;
        }
    }

    @Override
    public void reset(EntityGem gem) {
        this.cuttingDownTrees = false;
        this.treeLocation = null;
        this.amountBeforeGoal = 0;
        this.goal = 0;
        this.cut = false;
    }

    public boolean isCorrectBlock(IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockLog) {
            String modifier = (String)this.selectedPhrase.get(Math.max(0, this.selectedNounIndex - 2));
            switch (block.func_176201_c(state)) {
                case 0: {
                    if (modifier.equals("oak")) {
                        return true;
                    }
                }
                case 1: {
                    if (modifier.equals("spruce")) {
                        return true;
                    }
                }
                case 2: {
                    if (modifier.equals("birch")) {
                        return true;
                    }
                }
                case 3: {
                    if (modifier.equals("jungle")) {
                        return true;
                    }
                }
                case 4: {
                    if (!modifier.equals("acacia")) break;
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "cutting down a tree";
    }
}

