/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class CollectLiquids
extends Speak<EntityGem> {
    private BlockPos liquidLocation = null;
    private int goal = 1;
    private int amountBeforeGoal = 0;
    private int lastBlockBreak = 0;

    public CollectLiquids() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("collect", "gather", "get", "grab"));
        this.TRIGGER_NOUNS = new ArrayList<String>(Arrays.asList("water", "lava"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean triggered(EntityGem gem) {
        boolean previous = this.isAllowedToRun;
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.goal = Integer.parseInt((String)this.collectedNumbers.get(0));
            }
            catch (Exception ex) {
                this.goal = 1;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityGem gem) {
        return this.liquidLocation != null && gem.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151133_ar && gem.isSoldier;
    }

    @Override
    public void init(EntityGem gem) {
        ArrayList<BlockPos> liquids = new ArrayList<BlockPos>();
        for (int x = -16; x < 16; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -16; z < 16; ++z) {
                    IBlockState state = gem.field_70170_p.func_180495_p(gem.func_180425_c().func_177982_a(x, y, z));
                    if (!this.isCorrectBlock(state)) continue;
                    BlockPos liquid = gem.func_180425_c().func_177982_a(x, y, z);
                    liquids.add(liquid);
                }
            }
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < liquids.size(); ++i) {
            double distance = gem.func_174831_c((BlockPos)liquids.get(i));
            if (!(distance < minDistance)) continue;
            this.liquidLocation = (BlockPos)liquids.get(i);
            minDistance = distance;
        }
    }

    @Override
    public void run(EntityGem gem) {
        if (this.liquidLocation != null) {
            BlockPos lookPos = this.liquidLocation.func_177977_b();
            gem.func_70671_ap().func_75650_a((double)lookPos.func_177958_n(), (double)lookPos.func_177956_o(), (double)lookPos.func_177952_p(), 30.0f, 30.0f);
            if (gem.func_174831_c(this.liquidLocation) < 5.0) {
                if (this.lastBlockBreak > 20) {
                    if (this.selectedNoun.equals("water")) {
                        gem.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151131_as));
                    } else {
                        gem.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151129_at));
                    }
                    gem.field_70170_p.func_175698_g(this.liquidLocation);
                    ++this.amountBeforeGoal;
                    this.lastBlockBreak = 0;
                }
                ++this.lastBlockBreak;
            } else {
                gem.tryToMoveTo(this.liquidLocation);
            }
            if (this.amountBeforeGoal < this.goal) {
                this.liquidLocation = null;
                this.init(gem);
            }
        }
    }

    @Override
    public void reset(EntityGem gem) {
        this.liquidLocation = null;
    }

    public boolean isCorrectBlock(IBlockState state) {
        Block block = state.func_177230_c();
        if (this.selectedNoun.equals("water")) {
            return block.equals(Blocks.field_150355_j);
        }
        return block.equals(Blocks.field_150353_l);
    }

    public String toString() {
        return "collecting " + this.selectedNoun;
    }
}

