/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import mod.akrivus.kagic.entity.gem.EntityBismuth;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class BuildTower
extends Speak<EntityBismuth> {
    private float[] direction = new float[]{0.0f, 0.0f};
    private boolean startedBuilding = true;
    private IBlockState bridgeBlock = null;
    private ItemStack placeStack = null;
    private boolean stillBuilding = true;
    private int lastBlockPlace = 0;
    private int height = 24;
    private int offset = 0;

    public BuildTower() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("make", "build", "create", "construct", "assemble", "generate"));
        this.TRIGGER_NOUNS = new ArrayList<String>(Arrays.asList("tower", "pillar", "dick", "penis"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean triggered(EntityBismuth gem) {
        boolean previous = this.isAllowedToRun;
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.height = Integer.parseInt((String)this.collectedNumbers.get(0));
            }
            catch (Exception ex) {
                this.height = 24;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityBismuth gem) {
        return this.stillBuilding && this.getBlock(gem);
    }

    @Override
    public void run(EntityBismuth gem) {
        if (this.lastBlockPlace > 20 && this.offset < this.height) {
            boolean placed = false;
            BlockPos nextPos = gem.func_180425_c().func_177963_a((double)this.direction[0], 0.0, (double)this.direction[1]);
            gem.lookAt(nextPos.func_177963_a((double)this.direction[0], 4.0, (double)this.direction[1]));
            placed = gem.placeBlock(this.bridgeBlock, nextPos.func_177981_b(this.offset));
            if (placed) {
                gem.func_70107_b(nextPos.func_177958_n(), nextPos.func_177956_o() + 1, nextPos.func_177952_p());
                this.placeStack.func_190918_g(1);
                if (this.placeStack.func_190926_b()) {
                    placed = this.getBlock(gem) && placed;
                }
            }
            this.stillBuilding = placed;
            this.lastBlockPlace = 0;
        }
        ++this.lastBlockPlace;
    }

    public boolean getBlock(EntityBismuth gem) {
        InventoryBasic inventory = gem.gemStorage;
        for (String subject : this.collectedSubjects) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                Item item = stack.func_77973_b();
                if (!(item instanceof ItemBlock) || !stack.func_82833_r().toLowerCase().contains(subject)) continue;
                this.bridgeBlock = Block.func_149634_a((Item)item).getStateForPlacement(gem.field_70170_p, gem.func_180425_c(), EnumFacing.func_176733_a((double)gem.field_70177_z), (float)gem.field_70165_t, (float)gem.field_70163_u, (float)gem.field_70161_v, item.func_77647_b(stack.func_77960_j()), (EntityLivingBase)this.commandingPlayer, EnumHand.MAIN_HAND);
                this.placeStack = stack;
                return true;
            }
        }
        if (this.collectedSubjects.size() == 0) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                Item item = stack.func_77973_b();
                if (!(item instanceof ItemBlock)) continue;
                this.bridgeBlock = Block.func_149634_a((Item)item).getStateForPlacement(gem.field_70170_p, gem.func_180425_c(), EnumFacing.func_176733_a((double)gem.field_70177_z), (float)gem.field_70165_t, (float)gem.field_70163_u, (float)gem.field_70161_v, item.func_77647_b(stack.func_77960_j()), (EntityLivingBase)this.commandingPlayer, EnumHand.MAIN_HAND);
                this.placeStack = stack;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "building a tower";
    }
}

