/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import mod.akrivus.kagic.entity.gem.EntityBismuth;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class BuildRamp
extends Speak<EntityBismuth> {
    private float[] direction = new float[]{0.0f, 0.0f};
    private IBlockState bridgeBlock = null;
    private ItemStack placeStack = null;
    private boolean stillBuilding = true;
    private int lastBlockPlace = 0;
    private int width = 1;

    public BuildRamp() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("make", "build", "create", "construct", "assemble", "generate"));
        this.TRIGGER_NOUNS = new ArrayList<String>(Arrays.asList("ramp", "way", "drop"));
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.RESTING);
        this.task(true);
    }

    @Override
    public boolean speak(EntityBismuth gem, EntityPlayer player, String message) {
        boolean result = super.speak(gem, player, message);
        if (result) {
            int deg = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            gem.field_70177_z = player.field_70177_z;
            switch (deg) {
                case 0: {
                    this.direction = new float[]{0.0f, 1.0f};
                    break;
                }
                case 1: {
                    this.direction = new float[]{-1.0f, 0.0f};
                    break;
                }
                case 2: {
                    this.direction = new float[]{0.0f, -1.0f};
                    break;
                }
                case 3: {
                    this.direction = new float[]{1.0f, 0.0f};
                }
            }
        }
        return result;
    }

    @Override
    public boolean triggered(EntityBismuth gem) {
        boolean previous = this.isAllowedToRun;
        if (previous) {
            int blocksPlaced;
            boolean finished = false;
            BlockPos start = gem.func_180425_c();
            for (blocksPlaced = 0; blocksPlaced < 64; ++blocksPlaced) {
                BlockPos nextPos = start.func_177963_a((double)this.direction[0], 0.0, (double)this.direction[1]);
                if (gem.field_70170_p.func_180495_p(nextPos).func_177230_c().func_185481_k(gem.field_70170_p.func_180495_p(nextPos))) {
                    finished = true;
                    break;
                }
                start = start.func_177963_a((double)this.direction[0], -1.0, (double)this.direction[1]);
            }
            boolean bl = previous = finished && blocksPlaced < 64 && this.getBlock(gem);
        }
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.width = Integer.parseInt((String)this.collectedNumbers.get(0));
            }
            catch (Exception ex) {
                this.width = 1;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityBismuth gem) {
        return this.stillBuilding && this.getBlock(gem);
    }

    @Override
    public void run(EntityBismuth gem) {
        if (this.lastBlockPlace > 20) {
            BlockPos nextPos = gem.func_180425_c().func_177963_a((double)this.direction[0], 0.0, (double)this.direction[1]);
            gem.lookAt(nextPos.func_177963_a((double)this.direction[0], -1.0, (double)this.direction[1]));
            boolean placed = false;
            for (int i = this.width / 2 * -1; i < Math.max(1, this.width / 2); ++i) {
                BlockPos placePos = nextPos.func_177963_a((double)(this.direction[1] * (float)i), -2.0, (double)(this.direction[0] * (float)i));
                if (gem.field_70170_p.func_180495_p(placePos).func_177230_c().func_185481_k(gem.field_70170_p.func_180495_p(placePos)) || !(placed = gem.placeBlock(this.bridgeBlock, placePos))) continue;
                this.placeStack.func_190918_g(1);
                if (!this.placeStack.func_190926_b()) continue;
                boolean bl = placed = this.getBlock(gem) && placed;
                if (!placed) break;
            }
            gem.tryToMoveTo(nextPos.func_177977_b());
            this.stillBuilding = placed;
            this.lastBlockPlace = 0;
        }
        ++this.lastBlockPlace;
    }

    public boolean getBlock(EntityBismuth gem) {
        InventoryBasic inventory = gem.gemStorage;
        for (String subject : this.collectedSubjects) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                Item item = stack.func_77973_b();
                if (!(item instanceof ItemBlock) || !stack.func_82833_r().toLowerCase().contains(subject)) continue;
                this.bridgeBlock = Block.func_149634_a((Item)item).getStateForPlacement(gem.field_70170_p, gem.func_180425_c(), EnumFacing.func_176733_a((double)gem.field_70177_z), (float)gem.field_70165_t, (float)gem.field_70163_u, (float)gem.field_70161_v, item.func_77647_b(stack.func_77960_j()), (EntityLivingBase)this.commandingPlayer, EnumHand.MAIN_HAND);
                this.placeStack = stack;
                return true;
            }
        }
        if (this.collectedSubjects.size() == 0) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                Item item = stack.func_77973_b();
                if (!(item instanceof ItemBlock)) continue;
                this.bridgeBlock = Block.func_149634_a((Item)item).getStateForPlacement(gem.field_70170_p, gem.func_180425_c(), EnumFacing.func_176733_a((double)gem.field_70177_z), (float)gem.field_70165_t, (float)gem.field_70163_u, (float)gem.field_70161_v, item.func_77647_b(stack.func_77960_j()), (EntityLivingBase)this.commandingPlayer, EnumHand.MAIN_HAND);
                this.placeStack = stack;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "building a ramp";
    }
}

