/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.skills.pack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.akrivus.kagic.entity.gem.EntityPeridot;
import mod.akrivus.kagic.linguistics.LinguisticsHelper;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.Speak;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class BreedLivestock
extends Speak<EntityPeridot> {
    private EntityAnimal otherAnimal = null;
    private int goal = 4;
    private int amountBeforeGoal = 0;
    private int lastHitTime = 0;

    public BreedLivestock() {
        this.TRIGGER_VERBS = new ArrayList<String>(Arrays.asList("collect", "birth", "raise", "help"));
        this.TRIGGER_NOUNS = new ArrayList();
        this.canBeStopped = true;
        this.killsOnEnd = true;
        this.can(SkillBase.RunWith.TARGETTING);
        this.task(true);
    }

    @Override
    public boolean triggered(EntityPeridot gem) {
        boolean previous = this.isAllowedToRun;
        if (previous && !this.collectedNumbers.isEmpty()) {
            try {
                this.goal = Integer.parseInt((String)this.collectedNumbers.get(0));
            }
            catch (Exception ex) {
                this.goal = 4;
            }
        }
        return previous;
    }

    @Override
    public boolean proceed(EntityPeridot gem) {
        return this.otherAnimal != null && this.otherAnimal.func_70874_b() == 0 && !this.otherAnimal.func_70880_s() && !this.getBreedingItem(gem, this.otherAnimal).func_190926_b() && this.amountBeforeGoal < this.goal;
    }

    @Override
    public void init(EntityPeridot gem) {
        List animals = gem.field_70170_p.func_175647_a(EntityAnimal.class, gem.func_174813_aQ().func_72314_b(16.0, 8.0, 16.0), null);
        if (!animals.isEmpty()) {
            double minDistance = Double.MAX_VALUE;
            for (EntityAnimal animal : animals) {
                double distance = gem.func_70068_e((Entity)animal);
                if (!(gem.func_70068_e((Entity)animal) < minDistance) || animal.func_70874_b() != 0 || animal.func_70880_s() || LinguisticsHelper.getDistance(animal.func_70005_c_(), this.selectedNoun) >= 3) continue;
                this.otherAnimal = animal;
                minDistance = distance;
            }
        }
        if (this.otherAnimal != null) {
            gem.func_70624_b((EntityLivingBase)this.otherAnimal);
        }
    }

    @Override
    public void run(EntityPeridot gem) {
        if (this.otherAnimal != null) {
            gem.lookAt((Entity)this.otherAnimal);
            gem.func_184611_a(EnumHand.OFF_HAND, this.getBreedingItem(gem, this.otherAnimal).func_77946_l());
            if (gem.func_70068_e((Entity)this.otherAnimal) < 5.0) {
                if (this.lastHitTime > 10) {
                    this.getBreedingItem(gem, this.otherAnimal).func_190918_g(1);
                    this.otherAnimal.func_146082_f(this.commandingPlayer);
                    ++this.amountBeforeGoal;
                    this.lastHitTime = 0;
                }
                ++this.lastHitTime;
            } else {
                gem.tryToMoveTo(this.otherAnimal.func_180425_c());
            }
            if (this.amountBeforeGoal < this.goal) {
                this.otherAnimal = null;
                this.init(gem);
            }
        }
    }

    @Override
    public void reset(EntityPeridot gem) {
        this.otherAnimal = null;
        this.amountBeforeGoal = 0;
        this.goal = 0;
    }

    public String toString() {
        return "breeding " + this.otherAnimal.func_70005_c_();
    }

    public ItemStack getBreedingItem(EntityPeridot gem, EntityAnimal animal) {
        for (int i = 0; i < gem.harvest.func_70302_i_(); ++i) {
            ItemStack stack = gem.harvest.func_70301_a(i);
            if (!animal.func_70877_b(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

