/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.items;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import mod.akrivus.kagic.entity.EntityCorruptedGem;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.gem.EntityRuby;
import mod.akrivus.kagic.entity.shardfusion.EntityShardFusion;
import mod.akrivus.kagic.init.ModBlocks;
import mod.akrivus.kagic.init.ModCreativeTabs;
import mod.akrivus.kagic.init.ModEntities;
import mod.akrivus.kagic.init.ModItems;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGem
extends Item {
    private final String gemName;
    public boolean isCracked;

    public ItemGem(String name) {
        this(name, false);
    }

    public ItemGem(String name, boolean cracked) {
        this.func_77655_b((cracked ? "cracked_" : "") + name + "_gem");
        this.func_77625_d(1);
        this.func_77656_e(60);
        if (name.contains("corrupted") || name.contains("tongue_monster") || name.contains("water_bear") || name.contains("handbody") || name.contains("footarm") || name.contains("mouthtorso")) {
            this.func_77637_a(ModCreativeTabs.CREATIVE_TAB_BAD_GEMS);
        } else {
            this.func_77637_a(ModCreativeTabs.CREATIVE_TAB_GOOD_GEMS);
        }
        this.isCracked = cracked;
        this.gemName = new TextComponentTranslation("entity.kagic." + name + ".name", new Object[0]).func_150261_e();
    }

    public void setData(EntityGem host, ItemStack stack) {
        stack.func_77982_d(host.func_189511_e(new NBTTagCompound()));
        stack.func_77978_p().func_74778_a("name", host.func_70005_c_());
    }

    public void clearData(ItemStack itemStackIn) {
        itemStackIn.func_77982_d(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        try {
            String name;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b("name") && !(name = tag.func_74779_i("name")).isEmpty()) {
                tooltip.add(name);
            }
            if (tag.func_74764_b("specificName") && !(name = tag.func_74779_i("specificName")).isEmpty()) {
                tooltip.add(name);
            }
        }
        catch (NullPointerException e) {
            tooltip.add(this.gemName);
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            BlockPos blockpos;
            RayTraceResult raytraceresult;
            ItemStack stack = playerIn.func_184586_b(hand);
            if (stack.func_77952_i() == 0 && !this.isCracked && (raytraceresult = this.func_77621_a(worldIn, playerIn, true)) != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && worldIn.func_175660_a(playerIn, blockpos = raytraceresult.func_178782_a()) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, stack)) {
                boolean spawned = this.spawnGem(worldIn, playerIn, blockpos, stack);
                if (!playerIn.field_71075_bZ.field_75098_d && spawned) {
                    stack.func_190918_g(1);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean spawnGem(World worldIn, EntityPlayer playerIn, BlockPos blockpos, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            EntityGem newGem;
            block8: {
                if (this.isCracked) {
                    return false;
                }
                newGem = new EntityRuby(worldIn);
                for (String key : ModEntities.GEMS.keySet()) {
                    try {
                        String name = this.func_77658_a().replaceAll("^item\\.(cracked_)*", "").replaceAll("_(\\d*_)*gem$", "");
                        if (!name.equals(key)) continue;
                        newGem = (EntityGem)((Object)ModEntities.GEMS.get(key).getConstructors()[0].newInstance(worldIn));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Error creating gem: " + e.getMessage());
                    }
                }
                try {
                    newGem.func_70020_e(stack.func_77978_p());
                    newGem.func_184221_a(MathHelper.func_180182_a((Random)worldIn.field_73012_v));
                }
                catch (Exception e) {
                    Matcher matcher = Pattern.compile("_(\\d+)_").matcher(this.func_77658_a());
                    newGem.func_180482_a(worldIn.func_175649_E(blockpos), null);
                    if (matcher.find()) {
                        newGem.itemDataToGemData(Integer.parseInt(matcher.group(1)));
                    }
                    if (playerIn == null || newGem.isDiamond || newGem instanceof EntityShardFusion || newGem instanceof EntityCorruptedGem) break block8;
                    newGem.setOwnerId(EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()));
                    newGem.setLeader((EntityLivingBase)playerIn);
                    newGem.setServitude(1);
                    newGem.func_70661_as().func_75499_g();
                    newGem.func_70624_b(null);
                    newGem.func_70606_j(newGem.func_110138_aP());
                    newGem.playTameEffect();
                    newGem.field_70170_p.func_72960_a((Entity)newGem, (byte)7);
                    newGem.playObeySound();
                }
            }
            newGem.func_70107_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 1.0, (double)blockpos.func_177952_p() + 0.5);
            newGem.setRestPosition(newGem.func_180425_c());
            newGem.func_70606_j(newGem.func_110138_aP());
            newGem.func_70624_b(null);
            newGem.func_70066_B();
            newGem.func_70674_bp();
            worldIn.func_72838_d((Entity)newGem);
            return true;
        }
        return false;
    }

    public boolean onEntityItemUpdate(EntityItem entity) {
        entity.field_70128_L = false;
        entity.func_184224_h(true);
        entity.func_70066_B();
        if (entity.field_70173_aa > 600) {
            entity.func_174873_u();
        }
        if (!this.isCracked && !entity.field_70170_p.field_72995_K && entity.field_70173_aa > 600) {
            ItemGem gem;
            boolean spawned;
            ItemStack stack = entity.func_92059_d();
            if (entity.func_130014_f_().func_72820_D() % 20L == 0L && stack.func_77952_i() > 0) {
                stack.func_77964_b(Math.max(stack.func_77952_i() - 2, 0));
            }
            if (stack.func_77952_i() == 0 && (spawned = (gem = (ItemGem)stack.func_77973_b()).spawnGem(entity.field_70170_p, null, entity.func_180425_c(), entity.func_92059_d()))) {
                entity.func_70106_y();
            }
        } else if (this.isCracked && !entity.field_70170_p.field_72995_K && entity.field_70170_p.func_180495_p(entity.func_180425_c()).func_177230_c() == ModBlocks.ROSE_TEARS) {
            ItemStack crackedGemStack = entity.func_92059_d();
            ItemStack healedGemStack = new ItemStack((Item)ModItems.GEM_TABLE.get(crackedGemStack.func_77973_b()));
            healedGemStack.func_77982_d(crackedGemStack.func_77978_p());
            healedGemStack.func_77964_b(0);
            EntityItem healedGem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, healedGemStack);
            entity.field_70170_p.func_72838_d((Entity)healedGem);
            entity.func_70106_y();
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.func_72820_D() % 20L == 0L && stack.func_77952_i() > 0) {
            stack.func_77964_b(Math.max(stack.func_77952_i() - 1 * (isSelected ? 2 : 1), 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74767_n("primary");
        }
        return false;
    }
}

