/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.init;

import java.util.Comparator;
import mod.akrivus.kagic.init.ModBlocks;
import mod.akrivus.kagic.init.ModItems;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModCreativeTabs
extends CreativeTabs {
    public static final CreativeTabs CREATIVE_TAB_GOOD_GEMS = new ModCreativeTabs("good_gems", 0);
    public static final CreativeTabs CREATIVE_TAB_BAD_GEMS = new ModCreativeTabs("bad_gems", 1);
    public static final CreativeTabs CREATIVE_TAB_OTHER = new ModCreativeTabs("other", 2);
    public static final CreativeTabs CREATIVE_TAB_MUSIC = new ModCreativeTabs("music", 3);
    private final int id;

    public ModCreativeTabs(String label, int id) {
        super(CreativeTabs.getNextID(), label);
        this.id = id;
    }

    public ItemStack func_78016_d() {
        switch (this.id) {
            case 0: {
                return new ItemStack((Item)ModItems.YELLOW_DIAMOND_GEM);
            }
            case 1: {
                return new ItemStack((Item)ModItems.CRACKED_YELLOW_DIAMOND_GEM);
            }
            case 2: {
                return new ItemStack((Item)ModItems.GEM_STAFF);
            }
            case 3: {
                return new ItemStack((Item)ModItems.RECORD_LAPIS_FLIGHT);
            }
        }
        return new ItemStack((Item)ModItems.CRACKED_YELLOW_DIAMOND_GEM);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78018_a(NonNullList<ItemStack> items) {
        super.func_78018_a(items);
        if (this == CREATIVE_TAB_OTHER) {
            items.add((Object)FluidUtil.getFilledBucket((FluidStack)new FluidStack(ModBlocks.FLUID_ROSE_TEARS, 1000)));
        } else if (this == CREATIVE_TAB_GOOD_GEMS) {
            ItemStack candyCaneGem = null;
            ItemStack crackedCandyCaneGem = null;
            for (ItemStack stack : items) {
                if (stack.func_77973_b() == ModItems.CANDY_CANE_JASPER_GEM) {
                    candyCaneGem = stack;
                    continue;
                }
                if (stack.func_77973_b() != ModItems.CRACKED_CANDY_CANE_JASPER_GEM) continue;
                crackedCandyCaneGem = stack;
            }
            items.remove(candyCaneGem);
            items.remove(crackedCandyCaneGem);
        }
        items.sort((Comparator)new GemItemStackComparator());
    }

    class GemItemStackComparator
    implements Comparator<ItemStack> {
        GemItemStackComparator() {
        }

        @Override
        public int compare(ItemStack arg0, ItemStack arg1) {
            Item item1;
            if (arg0.equals(arg1)) {
                return 0;
            }
            Item item0 = arg0.func_77973_b();
            if (item0.equals(item1 = arg1.func_77973_b())) {
                return 0;
            }
            String name0 = item0.func_77658_a().substring(5);
            String name1 = item1.func_77658_a().substring(5);
            if (name0.startsWith("cracked_")) {
                if (name1.startsWith("cracked_")) {
                    return name0.compareToIgnoreCase(name1);
                }
                if (name0.substring(8).equalsIgnoreCase(name1)) {
                    return 1;
                }
                return name0.substring(8).compareToIgnoreCase(name1);
            }
            if (name1.startsWith("cracked_")) {
                if (name0.startsWith("cracked_")) {
                    return name0.compareToIgnoreCase(name1);
                }
                if (name1.substring(8).equalsIgnoreCase(name0)) {
                    return -1;
                }
                return name0.compareToIgnoreCase(name1.substring(8));
            }
            return name0.compareToIgnoreCase(name1);
        }
    }
}

