/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.init;

import java.io.InputStream;
import java.util.Calendar;
import mod.akrivus.kagic.client.gui.KTGUIProxy;
import mod.akrivus.kagic.command.CommandDestroyGem;
import mod.akrivus.kagic.command.CommandMeteorRuby;
import mod.akrivus.kagic.command.CommandScanGems;
import mod.akrivus.kagic.command.CommandSpawnGems;
import mod.akrivus.kagic.entity.EntityCrystalSkills;
import mod.akrivus.kagic.entity.gem.fusion.FusionSpawnHandler;
import mod.akrivus.kagic.init.ModEntities;
import mod.akrivus.kagic.init.ModEvents;
import mod.akrivus.kagic.init.ModTESRs;
import mod.akrivus.kagic.init.ModTileEntities;
import mod.akrivus.kagic.init.OreDictListener;
import mod.akrivus.kagic.server.SpaceStuff;
import mod.akrivus.kagic.skills.SkillBase;
import mod.akrivus.kagic.skills.pack.AlignGems;
import mod.akrivus.kagic.skills.pack.BreedLivestock;
import mod.akrivus.kagic.skills.pack.BuildBox;
import mod.akrivus.kagic.skills.pack.BuildBridge;
import mod.akrivus.kagic.skills.pack.BuildRamp;
import mod.akrivus.kagic.skills.pack.BuildStairs;
import mod.akrivus.kagic.skills.pack.BuildTower;
import mod.akrivus.kagic.skills.pack.BuildWall;
import mod.akrivus.kagic.skills.pack.CollectLiquids;
import mod.akrivus.kagic.skills.pack.Come;
import mod.akrivus.kagic.skills.pack.CutDownTrees;
import mod.akrivus.kagic.skills.pack.Defend;
import mod.akrivus.kagic.skills.pack.DumpChestsBismuth;
import mod.akrivus.kagic.skills.pack.DumpChestsLapis;
import mod.akrivus.kagic.skills.pack.DumpChestsPearl;
import mod.akrivus.kagic.skills.pack.DumpChestsPeridot;
import mod.akrivus.kagic.skills.pack.FetchChestsBismuth;
import mod.akrivus.kagic.skills.pack.FetchChestsPearl;
import mod.akrivus.kagic.skills.pack.Follow;
import mod.akrivus.kagic.skills.pack.FuseTopaz;
import mod.akrivus.kagic.skills.pack.GetFacet;
import mod.akrivus.kagic.skills.pack.GetHealth;
import mod.akrivus.kagic.skills.pack.GetSkills;
import mod.akrivus.kagic.skills.pack.Harvest;
import mod.akrivus.kagic.skills.pack.HarvestAndReplant;
import mod.akrivus.kagic.skills.pack.HarvestAndReplantNetherWart;
import mod.akrivus.kagic.skills.pack.HarvestCacti;
import mod.akrivus.kagic.skills.pack.HarvestMelons;
import mod.akrivus.kagic.skills.pack.HarvestNetherWart;
import mod.akrivus.kagic.skills.pack.HarvestPumpkins;
import mod.akrivus.kagic.skills.pack.HarvestReeds;
import mod.akrivus.kagic.skills.pack.KillOtherEntities;
import mod.akrivus.kagic.skills.pack.Look;
import mod.akrivus.kagic.skills.pack.MilkCows;
import mod.akrivus.kagic.skills.pack.Mine;
import mod.akrivus.kagic.skills.pack.MowGrass;
import mod.akrivus.kagic.skills.pack.PickFlowers;
import mod.akrivus.kagic.skills.pack.PlantSaplingsBismuth;
import mod.akrivus.kagic.skills.pack.PlantSaplingsPearl;
import mod.akrivus.kagic.skills.pack.PlantSaplingsPeridot;
import mod.akrivus.kagic.skills.pack.SingSong;
import mod.akrivus.kagic.skills.pack.Stop;
import mod.akrivus.kagic.skills.pack.TameCats;
import mod.akrivus.kagic.skills.pack.TameDogs;
import mod.akrivus.kagic.skills.pack.TameHorses;
import mod.akrivus.kagic.skills.pack.TameParrots;
import mod.akrivus.kagic.skills.pack.TellFuture;
import mod.akrivus.kagic.skills.pack.TellFutureGarnet;
import mod.akrivus.kagic.skills.pack.TellReport;
import mod.akrivus.kagic.skills.pack.UnfuseTopaz;
import mod.akrivus.kagic.skills.pack.Warp;
import mod.heimrarnadalr.kagic.chunk.KAGICChunkCallback;
import mod.heimrarnadalr.kagic.crafting.KAGICSmeltingRecipes;
import mod.heimrarnadalr.kagic.dispenser.DispenserBehaviors;
import mod.heimrarnadalr.kagic.networking.KTPacketHandler;
import mod.heimrarnadalr.kagic.proxies.CommonProxy;
import mod.heimrarnadalr.kagic.util.GemPlayerLoot;
import mod.heimrarnadalr.kagic.world.CorruptedGemSpawner;
import mod.heimrarnadalr.kagic.world.Fogger;
import mod.heimrarnadalr.kagic.world.GenEventCanceller;
import mod.heimrarnadalr.kagic.world.KAGICWorldGenerator;
import mod.heimrarnadalr.kagic.world.structure.LootTables;
import net.minecraft.command.ICommand;
import net.minecraft.crash.CrashReport;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import org.apache.logging.log4j.Logger;

@Mod(modid="kagic", version="X11p13", acceptedMinecraftVersions="[1.12.1,1.12.2]")
public class KAGIC {
    public static final String MODID = "kagic";
    public static final String VERSION = "X11p13";
    public static final String MCVERSION = "[1.12.1,1.12.2]";
    public static final boolean DEVELOPER = false;
    public static Logger logger;
    @Mod.Instance
    public static KAGIC instance;
    public static SpaceStuff spaceStuff;
    public static KAGICWorldGenerator worldGen;
    public static SentenceModel sentModel;
    public static SentenceDetectorME sentDetector;
    public static POSModel posModel;
    public static POSTaggerME posTagger;
    @SidedProxy(clientSide="mod.heimrarnadalr.kagic.proxies.ClientProxy", serverSide="mod.heimrarnadalr.kagic.proxies.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        KAGICSmeltingRecipes.register();
        KTPacketHandler.registerMessages(MODID);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new KAGICChunkCallback());
        LootTables.register();
        worldGen = new KAGICWorldGenerator();
        try {
            InputStream input = null;
            input = this.getClass().getClassLoader().getResourceAsStream("assets/kagic/lang/processing/en-sent.bin");
            sentModel = new SentenceModel(input);
            sentDetector = new SentenceDetectorME(sentModel);
            input = this.getClass().getClassLoader().getResourceAsStream("assets/kagic/lang/processing/en-pos-perceptron.bin");
            posModel = new POSModel(input);
            posTagger = new POSTaggerME(posModel);
        }
        catch (Exception ex) {
            CrashReport.func_85055_a((Throwable)ex, (String)"Something went wrong loading OpenNLP.");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        ModEntities.register();
        ModEvents.register();
        ModTileEntities.register();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new KTGUIProxy());
        if (e.getSide() == Side.CLIENT) {
            ModTESRs.register();
            MinecraftForge.EVENT_BUS.register((Object)new Fogger());
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)50);
        GenEventCanceller genCanceller = new GenEventCanceller();
        MinecraftForge.EVENT_BUS.register((Object)genCanceller);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)genCanceller);
        MinecraftForge.EVENT_BUS.register((Object)new FusionSpawnHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CorruptedGemSpawner());
        MinecraftForge.EVENT_BUS.register((Object)new OreDictListener());
        MinecraftForge.EVENT_BUS.register((Object)new GemPlayerLoot());
        DispenserBehaviors.register();
        proxy.registerBlockColors();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        ModEntities.registerGemYields();
        KAGIC.addSkill(AlignGems.class);
        KAGIC.addSkill(BreedLivestock.class);
        KAGIC.addSkill(BuildBox.class);
        KAGIC.addSkill(BuildBridge.class);
        KAGIC.addSkill(BuildStairs.class);
        KAGIC.addSkill(BuildTower.class);
        KAGIC.addSkill(BuildWall.class);
        KAGIC.addSkill(BuildRamp.class);
        KAGIC.addSkill(CollectLiquids.class);
        KAGIC.addSkill(Come.class);
        KAGIC.addSkill(CutDownTrees.class);
        KAGIC.addSkill(Defend.class);
        KAGIC.addSkill(DumpChestsBismuth.class);
        KAGIC.addSkill(DumpChestsLapis.class);
        KAGIC.addSkill(DumpChestsPearl.class);
        KAGIC.addSkill(DumpChestsPeridot.class);
        KAGIC.addSkill(FetchChestsBismuth.class);
        KAGIC.addSkill(FetchChestsPearl.class);
        KAGIC.addSkill(Follow.class);
        KAGIC.addSkill(FuseTopaz.class);
        KAGIC.addSkill(GetFacet.class);
        KAGIC.addSkill(GetHealth.class);
        KAGIC.addSkill(GetSkills.class);
        KAGIC.addSkill(Harvest.class);
        KAGIC.addSkill(HarvestAndReplant.class);
        KAGIC.addSkill(HarvestAndReplantNetherWart.class);
        KAGIC.addSkill(HarvestCacti.class);
        KAGIC.addSkill(HarvestMelons.class);
        KAGIC.addSkill(HarvestNetherWart.class);
        KAGIC.addSkill(HarvestPumpkins.class);
        KAGIC.addSkill(HarvestReeds.class);
        KAGIC.addSkill(KillOtherEntities.class);
        KAGIC.addSkill(Look.class);
        KAGIC.addSkill(MilkCows.class);
        KAGIC.addSkill(Mine.class);
        KAGIC.addSkill(MowGrass.class);
        KAGIC.addSkill(PickFlowers.class);
        KAGIC.addSkill(PlantSaplingsBismuth.class);
        KAGIC.addSkill(PlantSaplingsPearl.class);
        KAGIC.addSkill(PlantSaplingsPeridot.class);
        KAGIC.addSkill(SingSong.class);
        KAGIC.addSkill(Stop.class);
        KAGIC.addSkill(TameCats.class);
        KAGIC.addSkill(TameDogs.class);
        KAGIC.addSkill(TameHorses.class);
        KAGIC.addSkill(TameParrots.class);
        KAGIC.addSkill(TellFuture.class);
        KAGIC.addSkill(TellFutureGarnet.class);
        KAGIC.addSkill(TellReport.class);
        KAGIC.addSkill(UnfuseTopaz.class);
        KAGIC.addSkill(Warp.class);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandDestroyGem());
        e.registerServerCommand((ICommand)new CommandMeteorRuby());
        e.registerServerCommand((ICommand)new CommandSpawnGems());
        e.registerServerCommand((ICommand)new CommandScanGems());
    }

    public void chatInfoMessage(String message) {
    }

    public static boolean isDayToday(int month, int day) {
        boolean sameMonth = Calendar.getInstance().get(2) == month - 1;
        boolean sameDay = Calendar.getInstance().get(5) == day;
        return sameMonth && sameDay;
    }

    public static boolean isFireworksDay() {
        return KAGIC.isDayToday(1, 1) || KAGIC.isDayToday(3, 21) || KAGIC.isDayToday(7, 4);
    }

    public static boolean isHalloween() {
        for (int day = 25; day <= 31; ++day) {
            if (!KAGIC.isDayToday(10, day)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAprilFools() {
        return KAGIC.isDayToday(4, 1);
    }

    public static boolean isChristmas() {
        int day;
        for (day = 24; day <= 31; ++day) {
            if (!KAGIC.isDayToday(12, day)) continue;
            return true;
        }
        for (day = 1; day <= 5; ++day) {
            if (!KAGIC.isDayToday(1, day)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBirthday() {
        return KAGIC.isDayToday(1, 17) || KAGIC.isDayToday(10, 24) || KAGIC.isDayToday(10, 22);
    }

    public static boolean isBirthdayTomorrow() {
        return KAGIC.isDayToday(1, 16) || KAGIC.isDayToday(10, 23) || KAGIC.isDayToday(10, 21);
    }

    public static void addSkill(Class<? extends SkillBase> skillToAdd) {
        EntityCrystalSkills.SKILLS.add(skillToAdd);
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

