/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem.corrupted;

import mod.akrivus.kagic.entity.EntityCorruptedGem;
import mod.akrivus.kagic.entity.ai.EntityAIGemFlyToTarget;
import mod.akrivus.kagic.entity.ai.EntityAIGemRandomFlight;
import mod.akrivus.kagic.entity.ai.EntityAITourmalineBlowAttack;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class EntityCorruptedWatermelonTourmaline
extends EntityCorruptedGem {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityCorruptedWatermelonTourmaline.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MOUTH_OPEN = EntityDataManager.func_187226_a(EntityCorruptedWatermelonTourmaline.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int MOUTH_OPEN_DURATION = 30;

    public EntityCorruptedWatermelonTourmaline(World world) {
        super(world);
        this.func_70105_a(2.9f, 2.9f);
        this.setCutPlacement(GemCuts.TRIANGULAR, GemPlacements.BACK_OF_HEAD);
        this.field_70765_h = new TourmalineMoveHelper(this);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITourmalineBlowAttack(this, 2.0, 10.0, 4.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIGemFlyToTarget(this, 8.0f, 3.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIGemRandomFlight(this));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(MOUTH_OPEN, (Object)0);
        this.droppedGemItem = ModItems.CORRUPTED_WATERMELON_TOURMALINE_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_CORRUPTED_WATERMELON_TOURMALINE_GEM;
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        if (attacking) {
            this.setMouthOpen(30);
        }
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public void setMouthOpen(int time) {
        this.field_70180_af.func_187227_b(MOUTH_OPEN, (Object)time);
    }

    public int getMouthOpen() {
        return (Integer)this.field_70180_af.func_187225_a(MOUTH_OPEN);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getMouthOpen() > 0) {
            this.setMouthOpen(this.getMouthOpen() - 1);
        }
        if (this.getMouthOpen() <= 0 && this.isAttacking()) {
            this.setAttacking(false);
        }
    }

    @Override
    public void setAttackAI() {
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)source.func_76364_f();
            if (!source.func_94541_c()) {
                entitylivingbase.func_70097_a(DamageSource.func_92087_a((Entity)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, up, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, up, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, up, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public float func_70047_e() {
        return 2.0f;
    }

    @Override
    public boolean func_70601_bi() {
        World world = this.field_70170_p;
        BlockPos pos = this.func_180425_c();
        Biome biome = world.func_180494_b(pos);
        boolean isWater = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
        return isWater && world.func_175678_i(pos) && super.func_70601_bi();
    }

    static class TourmalineMoveHelper
    extends EntityMoveHelper {
        private final EntityCorruptedWatermelonTourmaline parentEntity;
        private int courseChangeCooldown;

        public TourmalineMoveHelper(EntityCorruptedWatermelonTourmaline tourmaline) {
            super((EntityLiving)tourmaline);
            this.parentEntity = tourmaline;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
                double xDist = this.field_75646_b - this.parentEntity.field_70165_t;
                double yDist = this.field_75647_c - this.parentEntity.field_70163_u;
                double zDist = this.field_75644_d - this.parentEntity.field_70161_v;
                double euclideanDistance = xDist * xDist + yDist * yDist + zDist * zDist;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, euclideanDistance = (double)MathHelper.func_76133_a((double)euclideanDistance))) {
                        this.parentEntity.field_70159_w += xDist / euclideanDistance * 0.1;
                        this.parentEntity.field_70181_x += yDist / euclideanDistance * 0.1;
                        this.parentEntity.field_70179_y += zDist / euclideanDistance * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < 3.0) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

