/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAICommandGems;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.akrivus.kagic.items.ItemGem;
import mod.akrivus.kagic.items.ItemGemStaff;
import mod.akrivus.kagic.util.KAGICEnchantmentUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityZircon
extends EntityGem
implements INpc {
    public static final HashMap<IBlockState, Double> ZIRCON_YIELDS = new HashMap();
    public static final double ZIRCON_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double ZIRCON_DEPTH_THRESHOLD = 16.0;
    public static final ArrayList<ResourceLocation> ZIRCON_HAIR_STYLES = new ArrayList();

    public EntityZircon(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.9f);
        this.visorChanceReciprocal = 1;
        this.seePastDoors();
        this.setCutPlacement(GemCuts.PILLOW, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.PILLOW, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.PILLOW, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.PILLOW, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.PILLOW, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.PILLOW, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICommandGems(this, 0.6));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.droppedGemItem = ModItems.ZIRCON_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_ZIRCON_GEM;
    }

    @Override
    protected int generateGemColor() {
        switch (this.getInsigniaColor()) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                return 13333030;
            }
            case 2: {
                return 11421908;
            }
            case 3: {
                return 2184339;
            }
            case 4: {
                return 16711244;
            }
            case 5: {
                return 4625152;
            }
            case 6: {
                return 15234459;
            }
            case 7: {
                return 0x939393;
            }
            case 8: {
                return 0x8F8F8F;
            }
            case 9: {
                return 6724019;
            }
            case 10: {
                return 8076206;
            }
            case 11: {
                return 3888314;
            }
            case 12: {
                return 5125147;
            }
            case 13: {
                return 5006617;
            }
            case 14: {
                return 9842736;
            }
            case 15: {
                return 0x333333;
            }
        }
        return 476260;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        int color = this.field_70146_Z.nextInt(16);
        this.itemDataToGemData(color);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void itemDataToGemData(int data) {
        this.setInsigniaColor(data);
        this.nativeColor = this.getInsigniaColor();
        this.setUniformColor(data);
        this.setSkinColor(this.generateSkinColor());
        this.setGemColor(this.generateGemColor());
        if (data == 14) {
            this.func_96094_a(new TextComponentTranslation("entity.kagic.zircon_14.name", new Object[0]).func_150261_e());
        } else {
            this.func_96094_a(new TextComponentTranslation("entity.kagic.zircon.name", new Object[0]).func_150261_e());
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        switch (this.getInsigniaColor()) {
            case 0: {
                this.droppedGemItem = ModItems.WHITE_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_WHITE_ZIRCON_GEM;
                break;
            }
            case 1: {
                this.droppedGemItem = ModItems.ORANGE_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_ORANGE_ZIRCON_GEM;
                break;
            }
            case 2: {
                this.droppedGemItem = ModItems.MAGENTA_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_MAGENTA_ZIRCON_GEM;
                break;
            }
            case 3: {
                this.droppedGemItem = ModItems.LIGHT_BLUE_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_BLUE_ZIRCON_GEM;
                break;
            }
            case 4: {
                this.droppedGemItem = ModItems.YELLOW_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_YELLOW_ZIRCON_GEM;
                break;
            }
            case 5: {
                this.droppedGemItem = ModItems.LIME_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIME_ZIRCON_GEM;
                break;
            }
            case 6: {
                this.droppedGemItem = ModItems.PINK_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PINK_ZIRCON_GEM;
                break;
            }
            case 7: {
                this.droppedGemItem = ModItems.GRAY_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GRAY_ZIRCON_GEM;
                break;
            }
            case 8: {
                this.droppedGemItem = ModItems.LIGHT_GRAY_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_GRAY_ZIRCON_GEM;
                break;
            }
            case 9: {
                this.droppedGemItem = ModItems.CYAN_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_CYAN_ZIRCON_GEM;
                break;
            }
            case 10: {
                this.droppedGemItem = ModItems.PURPLE_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PURPLE_ZIRCON_GEM;
                break;
            }
            case 11: {
                this.droppedGemItem = ModItems.BLUE_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_ZIRCON_GEM;
                break;
            }
            case 12: {
                this.droppedGemItem = ModItems.BROWN_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BROWN_ZIRCON_GEM;
                break;
            }
            case 13: {
                this.droppedGemItem = ModItems.GREEN_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GREEN_ZIRCON_GEM;
                break;
            }
            case 14: {
                this.droppedGemItem = ModItems.RED_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_RED_ZIRCON_GEM;
                break;
            }
            case 15: {
                this.droppedGemItem = ModItems.BLACK_ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLACK_ZIRCON_GEM;
                break;
            }
            default: {
                this.droppedGemItem = ModItems.ZIRCON_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_ZIRCON_GEM;
            }
        }
        super.func_70645_a(cause);
    }

    @Override
    protected int generateHairStyle() {
        return this.field_70146_Z.nextInt(ZIRCON_HAIR_STYLES.size());
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.ZIRCON_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.ZIRCON_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.ZIRCON_DEATH;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && this.isTamed() && this.isOwnedBy((EntityLivingBase)player)) {
            ItemStack playerStack = player.func_184614_ca();
            if (playerStack.func_77973_b() instanceof ItemEnchantedBook) {
                this.func_70099_a(this.func_184614_ca(), 0.5f);
                this.func_184611_a(EnumHand.MAIN_HAND, playerStack.func_77946_l());
                if (!player.func_184812_l_()) {
                    playerStack.func_190918_g(1);
                }
            } else if (playerStack.func_190926_b()) {
                this.func_70099_a(this.func_184614_ca(), 0.5f);
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            } else if (!(playerStack.func_77973_b() instanceof ItemGemStaff) && !(playerStack.func_77973_b() instanceof ItemGem) && this.func_184614_ca().func_77973_b() instanceof ItemEnchantedBook) {
                ItemStack enchantmentResult = this.getEnchantedItem(playerStack.func_77946_l());
                if (playerStack.func_190916_E() == 1) {
                    player.func_184611_a(EnumHand.MAIN_HAND, enchantmentResult);
                } else {
                    if (!player.func_191521_c(enchantmentResult)) {
                        this.func_70099_a(enchantmentResult, 0.5f);
                    }
                    playerStack.func_190918_g(1);
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    public String getSpecialSkin() {
        return "0";
    }

    private ItemStack getEnchantedItem(ItemStack playerStack) {
        ItemStack holdingStack = this.func_184614_ca();
        if (!(holdingStack.func_77973_b() instanceof ItemEnchantedBook)) {
            return playerStack;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)holdingStack);
        if (enchantments.isEmpty()) {
            return playerStack;
        }
        Map existingEnchantments = EnchantmentHelper.func_82781_a((ItemStack)playerStack);
        Enchantment enchantment = KAGICEnchantmentUtils.getFirstNonconflicting(enchantments, existingEnchantments);
        if (enchantment == null) {
            return playerStack;
        }
        int level = (Integer)enchantments.get(enchantment);
        if (level <= 0) {
            return playerStack;
        }
        if (existingEnchantments.containsKey(enchantment)) {
            existingEnchantments.put(enchantment, (Integer)existingEnchantments.get(enchantment) + 1);
        } else {
            existingEnchantments.put(enchantment, 1);
        }
        if (playerStack.func_190916_E() > 1) {
            playerStack.func_190920_e(1);
        }
        EnchantmentHelper.func_82782_a((Map)existingEnchantments, (ItemStack)playerStack);
        this.func_184185_a(SoundEvents.field_190021_aL, 1.0f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
        if (--level == 0) {
            enchantments.remove(enchantment);
        } else {
            enchantments.put(enchantment, level);
        }
        if (!enchantments.isEmpty()) {
            ItemStack newBookStack = new ItemStack(Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)newBookStack);
            this.func_184611_a(EnumHand.MAIN_HAND, newBookStack);
        } else {
            this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151122_aG));
        }
        return playerStack;
    }

    @Override
    protected int generateSkinColor() {
        int colorIndex = this.getInsigniaColor();
        EnumDyeColor color = EnumDyeColor.values()[colorIndex];
        int colorValue = 0;
        try {
            colorValue = (Integer)ReflectionHelper.getPrivateValue(EnumDyeColor.class, (Object)color, (String[])new String[]{"colorValue", "field_193351_w", "w"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return colorValue;
    }

    @Override
    public boolean canChangeInsigniaColorByDefault() {
        return false;
    }
}

