/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIAttackTopaz;
import mod.akrivus.kagic.entity.ai.EntityAICommandGems;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAISitStill;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.ai.EntityAITopazFuse;
import mod.akrivus.kagic.entity.ai.EntityAITopazTarget;
import mod.akrivus.kagic.entity.gem.EntityAmethyst;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityTopaz
extends EntityGem
implements INpc {
    public static final HashMap<IBlockState, Double> TOPAZ_YIELDS = new HashMap();
    public static final double TOPAZ_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double TOPAZ_DEPTH_THRESHOLD = 48.0;
    private static final int SKIN_COLOR_YELLOW = 16181310;
    private static final int SKIN_COLOR_BLUE = 5335035;
    private static final int SKIN_COLOR_GREEN = 5438581;
    private static final int HAIR_COLOR_YELLOW = 16774500;
    private static final int HAIR_COLOR_BLUE = 10925566;
    private static final int HAIR_COLOR_GREEN = 10878644;
    private static final int NUM_HAIRSTYLES = 1;
    private static final DataParameter<Boolean> HOLDING = EntityDataManager.func_187226_a(EntityAmethyst.class, (DataSerializer)DataSerializers.field_187198_h);
    private ArrayList<EntityLivingBase> heldEntities = new ArrayList();

    public EntityTopaz(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 2.3f);
        this.isSoldier = true;
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackTopaz(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITopazFuse(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAICommandGems(this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAISitStill(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITopazTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
        this.droppedGemItem = ModItems.TOPAZ_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_TOPAZ_GEM;
        this.field_70180_af.func_187214_a(HOLDING, (Object)false);
    }

    @Override
    protected int generateGemColor() {
        if (this.getSpecial() == 1) {
            return 6124543;
        }
        if (this.getSpecial() == 2) {
            return 4774568;
        }
        return 16449373;
    }

    public String getColor() {
        switch (this.getSpecial()) {
            case 1: {
                return "blue_";
            }
            case 2: {
                return "green_";
            }
        }
        return "";
    }

    public void setColor(int color) {
        this.setSpecial(color);
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.DRUM.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.LEFT_CHEEK.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.RIGHT_CHEEK.id);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setSpecial(this.field_70146_Z.nextInt(7) == 0 ? 1 : 0);
        this.itemDataToGemData(this.getSpecial());
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void itemDataToGemData(int data) {
        this.setSpecial(data);
        this.setSkinColor(this.generateSkinColor());
        this.setHairStyle(this.generateHairStyle());
        this.setHairColor(this.generateHairColor());
        this.setGemColor(this.generateGemColor());
        this.nativeColor = this.getSpecial() == 1 ? 11 : 14;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        Item item;
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && this.isTamed() && this.isOwnedBy((EntityLivingBase)player) && ((item = (stack = player.func_184614_ca()).func_77973_b()) instanceof ItemArmor && ((ItemArmor)item).field_77881_a == EntityEquipmentSlot.HEAD || player.func_70093_af() && stack.func_190926_b())) {
            this.func_184606_a_(stack);
            this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.HEAD), 0.0f);
            this.func_184201_a(EntityEquipmentSlot.HEAD, stack.func_77946_l());
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.playObeySound();
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean alternateInteract(EntityPlayer player) {
        super.alternateInteract(player);
        if (!this.getHeldEntities().isEmpty()) {
            this.addHeldEntity(null);
        } else {
            this.wantsToFuse = true;
        }
        return true;
    }

    public void whenFused() {
        this.func_70105_a(0.9f * (float)this.getFusionCount(), 2.3f * (float)this.getFusionCount());
    }

    public ArrayList<EntityLivingBase> getHeldEntities() {
        return this.heldEntities;
    }

    public boolean addHeldEntity(EntityLivingBase entity) {
        if (entity != null) {
            if (this.isFusion()) {
                this.heldEntities.add(entity);
                return true;
            }
            if (this.heldEntities.isEmpty()) {
                this.field_70180_af.func_187227_b(HOLDING, (Object)true);
                this.heldEntities.add(entity);
                return true;
            }
            this.field_70180_af.func_187227_b(HOLDING, (Object)false);
            return false;
        }
        this.field_70180_af.func_187227_b(HOLDING, (Object)false);
        this.heldEntities.clear();
        return false;
    }

    public boolean isHolding() {
        return (Boolean)this.field_70180_af.func_187225_a(HOLDING);
    }

    @Override
    public void func_70636_d() {
        if (this.isFusion()) {
            this.whenFused();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.heldEntities.size(); ++i) {
                EntityLivingBase entity = this.heldEntities.get(i);
                if (entity != null && entity.func_70089_S() && entity.func_70068_e((Entity)this) < 16.0) {
                    double[] offset = new double[]{0.0, this.field_70131_O, 0.0};
                    if (this.isFusion()) {
                        switch (i) {
                            case 0: {
                                offset = new double[]{1.0, 1.0, -1.0};
                                break;
                            }
                            case 1: {
                                offset = new double[]{-1.0, 1.0, -1.0};
                                break;
                            }
                            case 2: {
                                offset = new double[]{1.0, 1.0, 1.0};
                                break;
                            }
                            case 3: {
                                offset = new double[]{-1.0, 1.0, 1.0};
                                break;
                            }
                            case 4: {
                                offset = new double[]{1.0, 2.0, -1.0};
                                break;
                            }
                            case 5: {
                                offset = new double[]{-1.0, 2.0, -1.0};
                                break;
                            }
                            case 6: {
                                offset = new double[]{1.0, 2.0, 1.0};
                                break;
                            }
                            case 7: {
                                offset = new double[]{-1.0, 2.0, 1.0};
                                break;
                            }
                            case 8: {
                                offset = new double[]{0.0, 1.0, -1.0};
                                break;
                            }
                            case 9: {
                                offset = new double[]{0.0, 1.0, 1.0};
                                break;
                            }
                            case 10: {
                                offset = new double[]{-1.0, 1.0, 0.0};
                                break;
                            }
                            case 11: {
                                offset = new double[]{1.0, 1.0, 0.0};
                                break;
                            }
                            case 12: {
                                offset = new double[]{0.0, 2.0, -1.0};
                                break;
                            }
                            case 13: {
                                offset = new double[]{0.0, 2.0, 1.0};
                                break;
                            }
                            case 14: {
                                offset = new double[]{-1.0, 2.0, 0.0};
                                break;
                            }
                            case 15: {
                                offset = new double[]{1.0, 2.0, 0.0};
                                break;
                            }
                            default: {
                                offset = new double[]{0.0, 1.5, 0.0};
                                if (entity.field_70173_aa % 10 != 0) break;
                                entity.func_70097_a(DamageSource.field_76368_d, 1.0f);
                            }
                        }
                    }
                    entity.func_70080_a(this.field_70165_t + offset[0], this.field_70163_u + offset[1], this.field_70161_v + offset[2], this.field_70177_z, this.field_70125_A);
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = 0.0;
                    entity.field_70179_y = 0.0;
                    continue;
                }
                this.heldEntities.remove(i);
                --i;
            }
            if (this.heldEntities.isEmpty()) {
                this.field_70180_af.func_187227_b(HOLDING, (Object)false);
            } else if (this.isFusion()) {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
            }
        }
        super.func_70636_d();
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.heldEntities.isEmpty()) {
            super.func_82167_n(entityIn);
        }
    }

    public boolean canFuseWith(EntityTopaz other) {
        if (this.func_110143_aJ() < 0.0f || other.func_110143_aJ() < 0.0f) {
            return false;
        }
        return this.canFuse() && other.canFuse() && this.getServitude() == other.getServitude() && this.getGemPlacement() != other.getGemPlacement() && (this.getServitude() == 1 && this.func_184753_b().equals(other.func_184753_b()) || this.getServitude() != 1);
    }

    @Override
    public boolean canFuse() {
        return super.canFuse() && this.wantsToFuse && !this.isFusion();
    }

    public EntityTopaz fuse(EntityTopaz other) {
        ItemStack second;
        EntityTopaz topaz = new EntityTopaz(this.field_70170_p);
        NBTTagCompound primeCompound = new NBTTagCompound();
        this.func_189511_e(primeCompound);
        topaz.fusionMembers.add(primeCompound);
        NBTTagCompound otherCompound = new NBTTagCompound();
        other.func_189511_e(otherCompound);
        topaz.fusionMembers.add(otherCompound);
        if (this.getServitude() == 1) {
            topaz.setOwnerId(this.func_184753_b());
            topaz.setLeader((EntityLivingBase)this.getOwner());
        }
        topaz.setServitude(this.getServitude());
        topaz.setFusionCount(this.getFusionCount() + other.getFusionCount());
        topaz.generateFusionPlacements();
        topaz.func_70107_b((this.field_70165_t + other.field_70165_t) / 2.0, (this.field_70163_u + other.field_70163_u) / 2.0, (this.field_70161_v + other.field_70161_v) / 2.0);
        topaz.setSpecial(this.getSpecial() == other.getSpecial() ? this.getSpecial() : 2);
        topaz.setSkinColor(topaz.generateSkinColor());
        topaz.setHairStyle(topaz.generateHairStyle());
        topaz.setHairColor(topaz.generateHairColor());
        topaz.setInsigniaColor(this.getInsigniaColor());
        topaz.setUniformColor(this.getUniformColor());
        topaz.setGemColor(topaz.generateGemColor());
        topaz.setHasVisor(this.hasVisor());
        topaz.func_70624_b(this.func_70638_az());
        topaz.func_70604_c(this.func_94060_bK());
        topaz.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0 * (double)topaz.getFusionCount());
        topaz.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0 * (double)topaz.getFusionCount());
        topaz.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6 / (double)topaz.getFusionCount());
        topaz.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        topaz.field_70138_W = topaz.getFusionCount();
        topaz.func_70606_j(topaz.func_110138_aP());
        ItemStack weapon = this.func_184586_b(EnumHand.MAIN_HAND);
        if (weapon.func_77973_b() == Items.field_190931_a) {
            weapon = other.func_184586_b(EnumHand.MAIN_HAND);
        }
        if ((second = this.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() == Items.field_190931_a) {
            second = other.func_184586_b(EnumHand.OFF_HAND);
        }
        topaz.setFusionWeapon(weapon);
        topaz.setFusionWeapon(second);
        topaz.func_70105_a(0.9f * (float)topaz.getFusionCount(), 2.3f * (float)topaz.getFusionCount());
        return topaz;
    }

    @Override
    public void unfuse() {
        for (int i = 0; i < this.fusionMembers.size(); ++i) {
            EntityTopaz topaz = new EntityTopaz(this.field_70170_p);
            topaz.func_70020_e((NBTTagCompound)this.fusionMembers.get(i));
            topaz.func_184221_a(MathHelper.func_180182_a((Random)this.field_70170_p.field_73012_v));
            topaz.func_70606_j(topaz.func_110138_aP());
            topaz.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            topaz.func_70604_c(null);
            topaz.func_70624_b(null);
            topaz.wantsToFuse = false;
            this.field_70170_p.func_72838_d((Entity)topaz);
        }
        this.field_70170_p.func_72900_e((Entity)this);
    }

    @Override
    protected int generateSkinColor() {
        int color = this.getSpecial();
        switch (color) {
            case 0: {
                return 16181310;
            }
            case 1: {
                return 5335035;
            }
            case 2: {
                return 5438581;
            }
        }
        return 0;
    }

    @Override
    protected int generateHairStyle() {
        return this.field_70146_Z.nextInt(1);
    }

    @Override
    protected int generateHairColor() {
        int color = this.getSpecial();
        switch (color) {
            case 0: {
                return 16774500;
            }
            case 1: {
                return 10925566;
            }
            case 2: {
                return 10878644;
            }
        }
        return 0;
    }

    @Override
    public boolean hasUniformVariant(GemPlacements placement) {
        switch (placement) {
            default: 
        }
        return false;
    }

    @Override
    public boolean hasHairVariant(GemPlacements placement) {
        switch (placement) {
            case FOREHEAD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return false;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        super.func_82196_d(target, distanceFactor);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (this.getSpecial() == 1) {
            this.droppedGemItem = ModItems.BLUE_TOPAZ_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_TOPAZ_GEM;
        } else {
            this.droppedGemItem = ModItems.TOPAZ_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_TOPAZ_GEM;
        }
        super.func_70645_a(cause);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.TOPAZ_STEP;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.TOPAZ_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.TOPAZ_DEATH;
    }
}

