/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import mod.akrivus.kagic.blocks.BlockRoseTears;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAICommandGems;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIFutureVision;
import mod.akrivus.kagic.entity.ai.EntityAIRetroVision;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.EntityPadparadscha;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntitySapphire
extends EntityGem
implements INpc {
    public static final HashMap<IBlockState, Double> SAPPHIRE_YIELDS = new HashMap();
    public static final double SAPPHIRE_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double SAPPHIRE_DEPTH_THRESHOLD = 0.0;
    public static final HashMap<Integer, ResourceLocation> SAPPHIRE_HAIR_STYLES = new HashMap();
    private int luckTicks = 0;
    private static final List<Integer> SKIN_COLORS = new ArrayList<Integer>(Arrays.asList(0, 4, 4, 4, 4, 6, 6, 6, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 15, 16, 16));
    private static final int NUM_HAIRSTYLES = 2;

    public EntitySapphire(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.2f);
        this.seePastDoors();
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICommandGems(this, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFutureVision(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRetroVision(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.droppedGemItem = ModItems.SAPPHIRE_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_SAPPHIRE_GEM;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int color = SKIN_COLORS.get(this.field_70146_Z.nextInt(SKIN_COLORS.size()));
        this.itemDataToGemData(color);
        return livingdata;
    }

    @Override
    public void itemDataToGemData(int data) {
        this.setSpecial(data);
        if (data == 16) {
            this.func_96094_a(new TextComponentTranslation("entity.kagic.sapphire_16.name", new Object[0]).func_150261_e());
            this.setSkinColor(this.generateSkinColor());
            this.setHairColor(16373181);
            this.setGemColor(this.generateGemColor());
            this.setUniformColor(1);
            this.nativeColor = 1;
            this.setInsigniaColor(1);
        } else {
            this.func_96094_a(new TextComponentTranslation("entity.kagic.sapphire.name", new Object[0]).func_150261_e());
            this.setSkinColor(this.generateSkinColor());
            this.setHairColor(data == 11 ? 12187132 : this.getSkinColor());
            this.setGemColor(this.generateGemColor());
            this.setUniformColor(data);
            this.nativeColor = data;
            this.setInsigniaColor(data);
        }
    }

    @Override
    protected int generateGemColor() {
        switch (this.getSpecial()) {
            case 0: {
                return 0xFFFFFF;
            }
            case 4: {
                return 16711244;
            }
            case 6: {
                return 15234459;
            }
            case 10: {
                return 8076206;
            }
            case 11: {
                return 3888314;
            }
            case 13: {
                return 5006617;
            }
            case 15: {
                return 0x333333;
            }
        }
        return 14579045;
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("skinColor")) {
            if (compound.func_74762_e("skinColor") == 0) {
                this.setSpecial(11);
                this.setSkinColor(this.generateSkinColor());
                this.setHairColor(this.getSkinColor());
                this.setUniformColor(11);
                this.setInsigniaColor(11);
            }
        } else {
            this.setSpecial(11);
            this.setSkinColor(this.generateSkinColor());
            this.setHairColor(this.getSkinColor());
            this.setUniformColor(11);
            this.setInsigniaColor(11);
        }
        super.func_70037_a(compound);
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.FACETED.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.LEFT_EYE.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.CHEST.id);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        if (this.isDefective()) {
            return ModSounds.PADPARADSCHA_LIVING;
        }
        return ModSounds.SAPPHIRE_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.SAPPHIRE_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.SAPPHIRE_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SAPPHIRE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            if (this.isTamed() && this.isOwner((EntityLivingBase)player) && this.isCoreItem(stack)) {
                return super.func_184645_a(player, hand);
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        if (this.isPrimary()) {
            BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(0, 0, 0);
            for (BlockPos.MutableBlockPos blockpos1 : BlockPos.func_177975_b((BlockPos)this.func_180425_c().func_177963_a(-2.0, -1.0, -2.0), (BlockPos)this.func_180425_c().func_177963_a(2.0, -1.0, 2.0))) {
                if (!(blockpos1.func_177957_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) <= 4.0)) continue;
                blockpos.func_181079_c(blockpos1.func_177958_n(), blockpos1.func_177956_o() + 1, blockpos1.func_177952_p());
                IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos);
                if (iblockstate.func_185904_a() != Material.field_151579_a) continue;
                IBlockState iblockstate1 = this.field_70170_p.func_180495_p((BlockPos)blockpos1);
                if (iblockstate1.func_185904_a() == Material.field_151586_h && !(iblockstate1.func_177230_c() instanceof BlockRoseTears) && (Integer)iblockstate1.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && this.field_70170_p.func_190527_a(Blocks.field_185778_de, (BlockPos)blockpos1, false, EnumFacing.DOWN, null)) {
                    this.field_70170_p.func_175656_a((BlockPos)blockpos1, Blocks.field_185778_de.func_176223_P());
                    this.field_70170_p.func_175684_a(blockpos1.func_185334_h(), Blocks.field_185778_de, this.field_70146_Z.nextInt(60) + 60);
                    continue;
                }
                if (iblockstate1.func_185904_a() != Material.field_151587_i || (Integer)iblockstate1.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !this.field_70170_p.func_190527_a(Blocks.field_150347_e, (BlockPos)blockpos1, false, EnumFacing.DOWN, null)) continue;
                this.field_70170_p.func_175656_a((BlockPos)blockpos1, Blocks.field_150347_e.func_176223_P());
            }
        }
        if (this.luckTicks > 80 && !this.field_70128_L && !(this.func_110143_aJ() <= 0.0f)) {
            this.futureVision();
            this.luckTicks = 0;
        }
        ++this.luckTicks;
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.5;
        }
        super.func_70636_d();
    }

    private void futureVision() {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(8.0, (double)this.field_70170_p.func_72800_K(), 8.0);
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase entity : list) {
                if (entity.field_70128_L && !(entity.func_110143_aJ() > 0.0f)) continue;
                if (entity instanceof EntityGem) {
                    EntityGem gem = (EntityGem)entity;
                    if (this.getServitude() == gem.getServitude()) {
                        if (this.getServitude() == 1) {
                            if (this.isOwnerId(gem.func_184753_b())) {
                                if (this.isDefective()) {
                                    entity.func_70690_d(new PotionEffect(MobEffects.field_189112_A, 100));
                                } else {
                                    entity.func_70690_d(new PotionEffect(MobEffects.field_188425_z, 100));
                                }
                            }
                        } else if (this.isDefective()) {
                            entity.func_70690_d(new PotionEffect(MobEffects.field_189112_A, 100));
                        } else {
                            entity.func_70690_d(new PotionEffect(MobEffects.field_188425_z, 100));
                        }
                    }
                }
                if (!this.isOwner(entity)) continue;
                if (this.isDefective()) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_189112_A, 100));
                    continue;
                }
                entity.func_70690_d(new PotionEffect(MobEffects.field_188425_z, 100));
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        switch (this.getSpecial()) {
            case 0: {
                this.droppedGemItem = ModItems.WHITE_SAPPHIRE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_WHITE_SAPPHIRE_GEM;
                break;
            }
            case 1: {
                this.droppedGemItem = ModItems.ORANGE_SAPPHIRE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_ORANGE_SAPPHIRE_GEM;
                break;
            }
            case 4: {
                this.droppedGemItem = ModItems.YELLOW_SAPPHIRE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_YELLOW_SAPPHIRE_GEM;
                break;
            }
            case 6: {
                this.droppedGemItem = ModItems.PINK_SAPPHIRE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PINK_SAPPHIRE_GEM;
                break;
            }
            case 10: {
                this.droppedGemItem = ModItems.PURPLE_SAPPHIRE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PURPLE_SAPPHIRE_GEM;
                break;
            }
            case 11: {
                this.droppedGemItem = ModItems.BLUE_SAPPHIRE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_SAPPHIRE_GEM;
                break;
            }
            case 13: {
                this.droppedGemItem = ModItems.GREEN_SAPPHIRE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GREEN_SAPPHIRE_GEM;
                break;
            }
            case 15: {
                this.droppedGemItem = ModItems.BLACK_SAPPHIRE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLACK_SAPPHIRE_GEM;
                break;
            }
            case 16: {
                this.droppedGemItem = ModItems.PADPARADSCHA_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PADPARADSCHA_GEM;
                break;
            }
            default: {
                this.droppedGemItem = ModItems.SAPPHIRE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_SAPPHIRE_GEM;
            }
        }
        super.func_70645_a(cause);
    }

    @Override
    protected int generateSkinColor() {
        int colorIndex = this.getSpecial();
        int colorValue = 0;
        if (this.getSpecial() == 11) {
            colorValue = 7510251;
        } else if (this.getSpecial() < 16) {
            EnumDyeColor color = EnumDyeColor.values()[colorIndex];
            try {
                colorValue = (Integer)ReflectionHelper.getPrivateValue(EnumDyeColor.class, (Object)color, (String[])new String[]{"colorValue", "field_193351_w", "w"});
            }
            catch (Exception exception) {}
        } else {
            colorValue = 16747826;
        }
        return colorValue;
    }

    @Override
    protected int generateHairStyle() {
        return this.field_70146_Z.nextInt(2);
    }

    @Override
    public boolean hasHairVariant(GemPlacements placement) {
        switch (placement) {
            case RIGHT_EYE: {
                return true;
            }
            case LEFT_EYE: {
                return true;
            }
        }
        return false;
    }

    public static EntitySapphire convertFrom(EntityPadparadscha pad) {
        EntitySapphire sapphire = new EntitySapphire(pad.field_70170_p);
        sapphire.func_70107_b(pad.field_70165_t, pad.field_70163_u, pad.field_70161_v);
        sapphire.itemDataToGemData(16);
        return sapphire;
    }
}

