/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.EntityPepo;
import mod.akrivus.kagic.entity.ai.EntityAIProtectionFuse;
import mod.akrivus.kagic.entity.gem.EntityPearl;
import mod.akrivus.kagic.entity.gem.EntityQuartzSoldier;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.entity.gem.fusion.EntityRainbowQuartz;
import mod.akrivus.kagic.entity.pepo.EntityCactus;
import mod.akrivus.kagic.entity.pepo.EntityMelon;
import mod.akrivus.kagic.entity.pepo.EntityPumpkin;
import mod.akrivus.kagic.entity.pepo.EntityStrawberry;
import mod.akrivus.kagic.init.ModBlocks;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.akrivus.kagic.items.ItemGem;
import mod.heimrarnadalr.kagic.util.Colors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class EntityRoseQuartz
extends EntityQuartzSoldier
implements INpc {
    public static final HashMap<IBlockState, Double> ROSE_QUARTZ_YIELDS = new HashMap();
    public static final double ROSE_QUARTZ_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double ROSE_QUARTZ_DEPTH_THRESHOLD = 72.0;
    public static final HashMap<Integer, ResourceLocation> ROSE_QUARTZ_HAIR_STYLES = new HashMap();
    private BlockPos lastSurgeLocation;
    private int regenTicks = 0;
    public static HashMap<Item, Item> ROSE_RECIPES = new HashMap();
    public static final int SKIN_COLOR_BEGIN = 16636617;
    public static final int SKIN_COLOR_END = 16637131;
    private static final int NUM_HAIRSTYLES = 1;
    public static final int HAIR_COLOR_BEGIN = 16625355;
    public static final int HAIR_COLOR_END = 16735980;

    public EntityRoseQuartz(World worldIn) {
        super(worldIn);
        this.nativeColor = 2;
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_SHOULDER);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_SHOULDER);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_HAND);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_HAND);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BELLY);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_THIGH);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_THIGH);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_KNEE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_KNEE);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, new EntityAIProtectionFuse<EntityPearl, EntityRainbowQuartz>(this, EntityPearl.class, EntityRainbowQuartz.class, 16.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 10, true, false, (Predicate)new Predicate<EntityMob>(){

            public boolean apply(EntityMob input) {
                return input != null && IMob.field_175450_e.apply((Object)input);
            }
        }));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.droppedGemItem = ModItems.ROSE_QUARTZ_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_ROSE_QUARTZ_GEM;
    }

    @Override
    protected int generateGemColor() {
        return 16753382;
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.FACETED.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.CHEST.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.BELLY.id);
            }
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && !this.field_70170_p.field_72995_K && this.isTamed() && this.isOwner((EntityLivingBase)player)) {
            ItemStack stack = player.func_184614_ca();
            Item item = stack.func_77973_b();
            if (item instanceof ItemGem) {
                if (((ItemGem)item).isCracked) {
                    ItemStack result = new ItemStack((Item)ModItems.GEM_TABLE.get(item));
                    result.func_77982_d(stack.func_77978_p());
                    this.func_70099_a(result, 1.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    this.playObeySound();
                    return true;
                }
            } else if (ROSE_RECIPES.containsKey(item)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.func_70099_a(new ItemStack(ROSE_RECIPES.get(item)), 1.0f);
            } else if (item == Items.field_151133_ar && !this.isDefective()) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, FluidUtil.getFilledBucket((FluidStack)new FluidStack(ModBlocks.FLUID_ROSE_TEARS, 1000)));
                } else if (!player.field_71071_by.func_70441_a(FluidUtil.getFilledBucket((FluidStack)new FluidStack(ModBlocks.FLUID_ROSE_TEARS, 1000)))) {
                    player.func_71019_a(FluidUtil.getFilledBucket((FluidStack)new FluidStack(ModBlocks.FLUID_ROSE_TEARS, 1000)), false);
                }
                this.playObeySound();
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void whenDefective() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_70105_a(0.63f, 2.3f);
    }

    @Override
    public void func_70636_d() {
        if (!(this.regenTicks <= 80 || this.isDefective() || this.field_70128_L || this.func_110143_aJ() <= 0.0f)) {
            this.startCryingLikeAnEmo();
            this.regenTicks = 0;
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.5;
        }
        ++this.regenTicks;
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.lastSurgeLocation == null || this.func_180425_c().func_177951_i((Vec3i)this.lastSurgeLocation) > 16.0) {
                for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)this.func_180425_c().func_177982_a(-8, -2, -8), (BlockPos)this.func_180425_c().func_177982_a(8, 2, 8))) {
                    EntityPepo pepo;
                    IBlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
                    if (state.func_177230_c() == Blocks.field_150440_ba) {
                        this.field_70170_p.func_175655_b((BlockPos)pos, false);
                        pepo = new EntityMelon(this.field_70170_p);
                        pepo.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        pepo.func_70606_j(pepo.func_110138_aP());
                        this.field_70170_p.func_72838_d((Entity)pepo);
                        pepo.setMaster(this);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150423_aK) {
                        this.field_70170_p.func_175655_b((BlockPos)pos, false);
                        pepo = new EntityPumpkin(this.field_70170_p);
                        pepo.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        pepo.func_70606_j(pepo.func_110138_aP());
                        this.field_70170_p.func_72838_d((Entity)pepo);
                        pepo.setMaster(this);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150428_aP) {
                        this.field_70170_p.func_175655_b((BlockPos)pos, false);
                        pepo = new EntityPumpkin(this.field_70170_p);
                        pepo.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        pepo.func_70606_j(pepo.func_110138_aP());
                        this.field_70170_p.func_72838_d((Entity)pepo);
                        pepo.setMaster(this);
                        ((EntityPumpkin)pepo).setLit(true);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150434_aF) {
                        this.field_70170_p.func_175655_b((BlockPos)pos, false);
                        pepo = new EntityCactus(this.field_70170_p);
                        pepo.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        pepo.func_70606_j(pepo.func_110138_aP());
                        this.field_70170_p.func_72838_d((Entity)pepo);
                        pepo.setMaster(this);
                        continue;
                    }
                    if (state.func_177230_c() != ModBlocks.GIANT_STRAWBERRY) continue;
                    this.field_70170_p.func_175655_b((BlockPos)pos, false);
                    pepo = new EntityStrawberry(this.field_70170_p);
                    pepo.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    pepo.func_70606_j(pepo.func_110138_aP());
                    this.field_70170_p.func_72838_d((Entity)pepo);
                    pepo.setMaster(this);
                }
            }
            List list = this.field_70170_p.func_72872_a(EntityPepo.class, this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0));
            for (EntityPepo pepo : list) {
                if (pepo.getMaster() != null) continue;
                pepo.setMaster(this);
            }
            this.lastSurgeLocation = this.func_180425_c();
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && cause.func_76346_g() != null && !this.isOwner((EntityLivingBase)cause.func_76346_g())) {
            this.func_145779_a((Item)ModItems.RECORD_ROSES_FOUNTAIN, 1);
        }
        super.func_70645_a(cause);
    }

    private void startCryingLikeAnEmo() {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(16.0, (double)this.field_70170_p.func_72800_K(), 16.0);
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase entity : list) {
                if (entity.field_70128_L && !(entity.func_110143_aJ() > 0.0f)) continue;
                if (entity instanceof EntityGem) {
                    EntityGem gem = (EntityGem)entity;
                    if (this.getServitude() == gem.getServitude()) {
                        if (this.getServitude() == 1) {
                            if (this.isOwnerId(gem.func_184753_b())) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100));
                            }
                        } else {
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100));
                        }
                    }
                }
                if (!this.isOwner(entity)) continue;
                entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100));
            }
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.ROSE_QUARTZ_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.ROSE_QUARTZ_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.ROSE_QUARTZ_DEATH;
    }

    @Override
    protected int generateSkinColor() {
        ArrayList<Integer> skinColors = new ArrayList<Integer>();
        skinColors.add(16636617);
        skinColors.add(16637131);
        return Colors.arbiLerp(skinColors);
    }

    @Override
    protected int generateHairStyle() {
        return this.field_70146_Z.nextInt(1);
    }

    @Override
    protected int generateHairColor() {
        ArrayList<Integer> hairColors = new ArrayList<Integer>();
        hairColors.add(16625355);
        hairColors.add(16735980);
        return Colors.arbiLerp(hairColors);
    }

    @Override
    public boolean hasUniformVariant(GemPlacements placement) {
        switch (placement) {
            case BELLY: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasCape() {
        return true;
    }

    @Override
    public boolean hasHairVariant(GemPlacements placement) {
        switch (placement) {
            case FOREHEAD: {
                return true;
            }
        }
        return false;
    }

    static {
        ROSE_RECIPES.put(Items.field_151170_bI, Items.field_151174_bG);
        ROSE_RECIPES.put(Items.field_151078_bh, Items.field_151116_aA);
        ROSE_RECIPES.put(Items.field_151015_O, Items.field_151025_P);
    }
}

