/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.EntitySlag;
import mod.akrivus.kagic.entity.ai.EntityAIAlignGems;
import mod.akrivus.kagic.entity.ai.EntityAICommandGems;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIHarvestFarmland;
import mod.akrivus.kagic.entity.ai.EntityAIPickUpItems;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.akrivus.kagic.util.injector.InjectorResult;
import mod.heimrarnadalr.kagic.util.Colors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityPeridot
extends EntityGem
implements IInventoryChangedListener,
INpc {
    public static final HashMap<IBlockState, Double> PERIDOT_YIELDS = new HashMap();
    public static final double PERIDOT_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double PERIDOT_DEPTH_THRESHOLD = 72.0;
    public InventoryBasic gemStorage;
    public InvWrapper gemStorageHandler;
    public InventoryBasic harvest;
    public InvWrapper harvestHandler;
    private int harvestTimer = 0;
    private int dropTimer = 100;
    private BlockPos lastCheckPos;
    private long lastCheckTime;
    private InjectorResult lastResult;
    private static final int SKIN_COLOR_BEGIN = 10026866;
    private static final int SKIN_COLOR_END = 10284109;
    private static final int NUM_HAIRSTYLES = 2;
    private static final int HAIR_COLOR_BEGIN = 15726260;
    private static final int HAIR_COLOR_END = 0xFFFF9B;

    public EntityPeridot(World worldIn) {
        super(worldIn);
        this.nativeColor = 13;
        this.func_70105_a(0.7f, 1.9f);
        this.initGemStorage();
        this.seePastDoors();
        this.setCutPlacement(GemCuts.PERIDOT, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.PERIDOT, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.PERIDOT, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.TRIANGULAR, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.TRIANGULAR, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.TRIANGULAR, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICommandGems(this, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPickUpItems(this, 0.9));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAlignGems(this, 0.9));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIHarvestFarmland(this, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlag.class, true, true));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.droppedGemItem = ModItems.PERIDOT_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_PERIDOT_GEM;
    }

    @Override
    protected int generateGemColor() {
        return 3143722;
    }

    @Override
    public void convertGems(int placement) {
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                this.setGemCut(GemCuts.PERIDOT.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.CHEST.id);
                this.setGemCut(GemCuts.TRIANGULAR.id);
            }
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        NBTTagCompound nbttagcompound;
        ItemStack itemstack;
        int i;
        NBTTagList nbttaglist = new NBTTagList();
        for (i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
            itemstack = this.gemStorage.func_70301_a(i);
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("items", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (i = 0; i < this.harvest.func_70302_i_(); ++i) {
            itemstack = this.harvest.func_70301_a(i);
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("harvestItems", (NBTBase)nbttaglist);
        compound.func_74768_a("harvestTimer", this.harvestTimer);
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        int j;
        NBTTagCompound nbttagcompound;
        int i;
        NBTTagList nbttaglist = compound.func_150295_c("items", 10);
        this.initGemStorage();
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound = nbttaglist.func_150305_b(i);
            j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.gemStorage.func_70302_i_()) continue;
            this.gemStorage.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        nbttaglist = compound.func_150295_c("harvestItems", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound = nbttaglist.func_150305_b(i);
            j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.harvest.func_70302_i_()) continue;
            this.harvest.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        this.harvestTimer = compound.func_74762_e("harvestTimer");
        super.func_70037_a(compound);
    }

    @Override
    public void whenDefective() {
        this.func_70105_a(0.7f, 1.7f);
    }

    @Override
    public boolean alternateInteract(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            if (this.isOwner((EntityLivingBase)player)) {
                if (this.isFarmer()) {
                    this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND), 0.0f);
                    this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    this.func_98053_h(false);
                    return true;
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.does_not_serve_you", new Object[]{this.func_70005_c_()}));
                return true;
            }
        }
        return super.alternateInteract(player);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            if (this.isTamed()) {
                if (this.isOwner((EntityLivingBase)player)) {
                    if (this.isCoreItem(stack)) {
                        return super.func_184645_a(player, hand);
                    }
                    if (stack.func_77973_b() instanceof ItemHoe || stack.func_77973_b() instanceof ItemPickaxe) {
                        boolean toolChanged = true;
                        if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_185136_b(stack)) {
                            this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND), 0.0f);
                        } else {
                            toolChanged = false;
                        }
                        if (toolChanged) {
                            ItemStack heldItem = stack.func_77946_l();
                            this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                            this.playObeySound();
                            if (!player.field_71075_bZ.field_75098_d) {
                                stack.func_190918_g(1);
                            }
                        }
                        this.func_98053_h(true);
                        return true;
                    }
                    if (this.isFarmer()) {
                        for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                            ItemStack itemstack = this.gemStorage.func_70301_a(i);
                            this.dropTimer = 0;
                            if (itemstack.func_77973_b() instanceof IPlantable) {
                                if (!(itemstack.func_77973_b() instanceof ItemFood)) continue;
                                ItemStack newstack = itemstack.func_77979_a(itemstack.func_190916_E() - 8);
                                this.gemStorage.func_70299_a(i, itemstack);
                                this.harvest.func_174894_a(newstack);
                                continue;
                            }
                            this.gemStorage.func_70299_a(i, ItemStack.field_190927_a);
                            this.harvest.func_174894_a(itemstack);
                        }
                        if (this.harvest.func_191420_l()) {
                            player.func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.peridot_no_harvest", new Object[0]).func_150261_e()));
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.peridot_harvest", new Object[0]).func_150261_e()));
                        }
                        this.openGUI(player);
                        this.playObeySound();
                        return true;
                    }
                    this.checkSurroundings(this.field_70170_p, this.func_180425_c());
                    this.playObeySound();
                    return true;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.does_not_serve_you", new Object[]{this.func_70005_c_()}));
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void checkSurroundings(World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            InjectorResult result = this.lastCheckPos != null && this.func_174818_b(this.lastCheckPos) > 32.0 || this.lastCheckPos == null || this.field_70170_p.func_82737_E() - this.lastCheckTime > 2400L ? InjectorResult.create(worldIn, pos, false) : this.lastResult;
            String defectivity = Math.round(result.getDefectivity() * 100.0) + "%";
            if (result.getGem() != null) {
                if (result.isPrimary()) {
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.peridot_find_prime_gem", new Object[]{result.getName()}).func_150261_e()));
                } else {
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.peridot_find_gem", new Object[]{result.getName(), defectivity}).func_150261_e()));
                }
            } else {
                this.getOwner().func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.peridot_cant_find_gem", new Object[0]).func_150261_e()));
            }
            this.lastCheckTime = this.field_70170_p.func_82737_E();
            this.lastCheckPos = this.func_180425_c();
            this.lastResult = result;
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.func_98052_bS() && this.dropTimer > 40) {
            this.func_98053_h(this.isFarmer());
        }
        if (this.isFarmer()) {
            ++this.harvestTimer;
        }
        if (this.dropTimer < 100) {
            ++this.dropTimer;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.func_98053_h(false);
        super.func_70645_a(cause);
    }

    public void func_76316_a(IInventory inventory) {
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.gemStorage.func_70301_a(0));
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            if (this.isFarmer()) {
                if (playerEntity.func_70093_af()) {
                    this.gemStorage.func_110133_a(new TextComponentTranslation("command.kagic.peridot_seeds", new Object[]{this.func_70005_c_()}).func_150261_e());
                    playerEntity.func_71007_a((IInventory)this.gemStorage);
                } else {
                    this.harvest.func_110133_a(new TextComponentTranslation("command.kagic.peridot_inventory", new Object[]{this.func_70005_c_()}).func_150261_e());
                    playerEntity.func_71007_a((IInventory)this.harvest);
                }
            } else {
                this.gemStorage.func_110133_a(new TextComponentTranslation("command.kagic.peridot_mine_haul", new Object[]{this.func_70005_c_()}).func_150261_e());
                playerEntity.func_71007_a((IInventory)this.gemStorage);
            }
        }
    }

    private void initGemStorage() {
        InventoryBasic gemStorage = this.gemStorage;
        this.gemStorage = new InventoryBasic("gemStorage", true, 36);
        if (gemStorage != null) {
            for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                ItemStack itemstack = gemStorage.func_70301_a(i);
                this.gemStorage.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        this.gemStorageHandler = new InvWrapper((IInventory)this.gemStorage);
        InventoryBasic harvest = this.harvest;
        this.harvest = new InventoryBasic("harvest", true, 36);
        if (harvest != null) {
            harvest.func_110132_b((IInventoryChangedListener)this);
            for (int i = 0; i < this.harvest.func_70302_i_(); ++i) {
                ItemStack itemstack = harvest.func_70301_a(i);
                this.harvest.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        this.harvest.func_110134_a((IInventoryChangedListener)this);
        this.harvestHandler = new InvWrapper((IInventory)this.harvest);
        this.func_98053_h(this.isTamed());
    }

    protected void func_175445_a(EntityItem itementity) {
        ItemStack itemstack = itementity.func_92059_d();
        if (this.canPickupItem(itemstack.func_77973_b())) {
            ItemStack itemstack1 = this.gemStorage.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itementity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    public boolean canPickupItem(Item itemIn) {
        if (this.isFarmer()) {
            return itemIn instanceof ItemSeeds || itemIn instanceof ItemSeedFood || itemIn instanceof ItemFood || itemIn == Items.field_151015_O;
        }
        return false;
    }

    public boolean isFarmer() {
        return this.isTamed() && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemHoe;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_145779_a((Item)ModItems.RECORD_LITTLE_PERIDOT, 1);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.isTraitor() && entityIn instanceof EntityPlayer) {
            this.sayClod();
            return false;
        }
        return super.func_70652_k(entityIn);
    }

    public void sayClod() {
        this.func_184581_c(DamageSource.field_76377_j);
        if (this.getServitude() == 5) {
            this.sendMessage("command.kagic.peridot_rebel");
        } else {
            int index = this.field_70146_Z.nextInt(20);
            this.sendMessage("command.kagic.peridot_scream_" + index);
        }
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.PERIDOT_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.PERIDOT_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.PERIDOT_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.PERIDOT_DEATH;
    }

    @Override
    protected int generateSkinColor() {
        ArrayList<Integer> skinColors = new ArrayList<Integer>();
        skinColors.add(10026866);
        skinColors.add(10284109);
        return Colors.arbiLerp(skinColors);
    }

    @Override
    protected int generateHairStyle() {
        return this.field_70146_Z.nextInt(2);
    }

    @Override
    protected int generateHairColor() {
        ArrayList<Integer> hairColors = new ArrayList<Integer>();
        hairColors.add(15726260);
        hairColors.add(0xFFFF9B);
        return Colors.arbiLerp(hairColors);
    }
}

