/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAICommandGems;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIPickUpItems;
import mod.akrivus.kagic.entity.ai.EntityAISitStill;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.EntityHoloPearl;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.oredict.DyeUtils;

public class EntityPearl
extends EntityGem
implements IInventoryChangedListener,
INpc {
    public static final HashMap<IBlockState, Double> PEARL_YIELDS = new HashMap();
    public static final double PEARL_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double PEARL_DEPTH_THRESHOLD = 0.0;
    public static final ArrayList<ResourceLocation> PEARL_HAIR_STYLES = new ArrayList();
    public static final ArrayList<ResourceLocation> PEARL_DRESS_STYLES = new ArrayList();
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HAIR_COLOR = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> VISOR_COLOR = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DRESS_STYLE = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> NAKED = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187198_h);
    public String soulSong = "392935392935392939293929395";
    public InventoryBasic gemStorage;
    public InvWrapper gemStorageHandler;

    public EntityPearl(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.9f);
        this.initGemStorage();
        this.seePastDoors();
        this.soulSong = Integer.toString(this.field_70146_Z.nextInt(999998999) + 1000);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPickUpItems(this, 0.9));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICommandGems(this, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISitStill(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.droppedGemItem = ModItems.PEARL_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_PEARL_GEM;
        this.field_70180_af.func_187214_a(COLOR, (Object)this.field_70146_Z.nextInt(16));
        this.field_70180_af.func_187214_a(HAIR_COLOR, this.field_70180_af.func_187225_a(COLOR));
        this.field_70180_af.func_187214_a(VISOR_COLOR, this.field_70180_af.func_187225_a(COLOR));
        this.field_70180_af.func_187214_a(DRESS_STYLE, (Object)1);
        this.field_70180_af.func_187214_a(NAKED, (Object)false);
    }

    @Override
    public int generateGemColor() {
        switch (this.getColor()) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                return 13018763;
            }
            case 2: {
                return 12554961;
            }
            case 3: {
                return 6650257;
            }
            case 4: {
                return 16579760;
            }
            case 5: {
                return 8032613;
            }
            case 6: {
                return 15048887;
            }
            case 7: {
                return 0xB2B2B2;
            }
            case 8: {
                return 0x545454;
            }
            case 9: {
                return 8167602;
            }
            case 10: {
                return 9796013;
            }
            case 11: {
                return 8424375;
            }
            case 12: {
                return 11695678;
            }
            case 13: {
                return 8958508;
            }
            case 14: {
                return 11680057;
            }
            case 15: {
                return 0x4C4C4C;
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public int generateSkinColor() {
        switch (this.getColor()) {
            case 0: {
                return 0xE9ECEC;
            }
            case 1: {
                return 15570778;
            }
            case 2: {
                return 12352696;
            }
            case 3: {
                return 8110552;
            }
            case 4: {
                return 16242033;
            }
            case 5: {
                return 9025360;
            }
            case 6: {
                return 15389658;
            }
            case 7: {
                return 8358801;
            }
            case 8: {
                return 0xD8D8CD;
            }
            case 9: {
                return 6542040;
            }
            case 10: {
                return 9199018;
            }
            case 11: {
                return 6514331;
            }
            case 12: {
                return 12351043;
            }
            case 13: {
                return 9353005;
            }
            case 14: {
                return 15570579;
            }
            case 15: {
                return 0x333333;
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public int generateHairColor() {
        switch (this.getHairColor()) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                return 16740864;
            }
            case 2: {
                return 11403519;
            }
            case 3: {
                return 11720447;
            }
            case 4: {
                return 0xF9F900;
            }
            case 5: {
                return 14155698;
            }
            case 6: {
                return 16757451;
            }
            case 7: {
                return 0xD8D8D8;
            }
            case 8: {
                return 0xAFAFAF;
            }
            case 9: {
                return 11724543;
            }
            case 10: {
                return 12614911;
            }
            case 11: {
                return 11715071;
            }
            case 12: {
                return 13403463;
            }
            case 13: {
                return 12975935;
            }
            case 14: {
                return 0xFF5454;
            }
            case 15: {
                return 0;
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.CABOCHON.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.CHEST.id);
                break;
            }
            case 2: {
                this.setGemPlacement(GemPlacements.BACK.id);
            }
        }
    }

    @Override
    public boolean canChangeInsigniaColorByDefault() {
        return false;
    }

    @Override
    public boolean canChangeUniformColorByDefault() {
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("color", this.getColor());
        compound.func_74768_a("hairColor", this.getHairColor());
        compound.func_74768_a("visorColor", this.getVisorColor());
        compound.func_74768_a("dressStyle", this.getDressStyle());
        compound.func_74757_a("naked", this.isNaked());
        compound.func_74778_a("song", this.soulSong);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
            ItemStack itemstack = this.gemStorage.func_70301_a(i);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("items", (NBTBase)nbttaglist);
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.setColor(compound.func_74762_e("color"));
        if (compound.func_74764_b("hairColor")) {
            this.setHairColor(compound.func_74762_e("hairColor"));
        } else {
            this.setHairColor(this.getColor());
        }
        if (compound.func_74764_b("visorColor")) {
            this.setVisorColor(compound.func_74762_e("visorColor"));
        } else {
            this.setVisorColor(this.getColor());
        }
        this.setDressStyle(compound.func_74762_e("dressStyle"));
        this.setNaked(compound.func_74767_n("naked"));
        this.soulSong = compound.func_74779_i("song");
        NBTTagList nbttaglist = compound.func_150295_c("items", 10);
        this.initGemStorage();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.gemStorage.func_70302_i_()) continue;
            this.gemStorage.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        super.func_70037_a(compound);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setGemCut(GemCuts.CABOCHON.id);
        this.itemDataToGemData(this.getColor());
        this.setDressStyle(this.field_70146_Z.nextInt(PEARL_DRESS_STYLES.size()));
        if (this.isDefective()) {
            this.setHairColor(15 - this.getColor());
        } else {
            this.setHairColor(this.getColor());
        }
        this.nativeColor = this.getColor();
        return livingdata;
    }

    @Override
    public void itemDataToGemData(int data) {
        this.setColor(data);
        this.setHairColor(data);
        this.setVisorColor(data);
        this.setInsigniaColor(data);
        this.setUniformColor(data);
        this.setGemColor(this.generateGemColor());
        this.nativeColor = this.getColor();
    }

    @Override
    protected int generateHairStyle() {
        return this.field_70146_Z.nextInt(PEARL_HAIR_STYLES.size());
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            if (this.isTamed() && this.isOwner((EntityLivingBase)player)) {
                if (stack.func_77973_b() == Items.field_151097_aZ) {
                    if (player.func_70093_af()) {
                        if (!this.isNaked()) {
                            this.func_184185_a(this.getWeirdSound(), this.func_70599_aP(), this.func_70647_i());
                            this.func_184185_a(SoundEvents.field_187763_eJ, this.func_70599_aP(), this.func_70647_i());
                            this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getInsigniaColor()), 0.0f);
                            this.setNaked(true);
                        }
                    } else {
                        int hair = this.getHairStyle() + 1;
                        if (hair >= PEARL_HAIR_STYLES.size() || hair < 0) {
                            hair = 0;
                        }
                        this.setHairStyle(hair);
                    }
                    this.func_184185_a(SoundEvents.field_187763_eJ, this.func_70599_aP(), this.func_70647_i());
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_77972_a(1, (EntityLivingBase)this);
                    }
                    return true;
                }
                if (DyeUtils.isDye((ItemStack)stack)) {
                    if (player.func_70093_af()) {
                        int oldColor = this.getHairColor();
                        this.setHairColor(DyeUtils.metaFromStack((ItemStack)stack).orElse(0));
                        if (!player.field_71075_bZ.field_75098_d && oldColor != this.getHairColor()) {
                            stack.func_190918_g(1);
                        }
                    } else {
                        int oldColor = this.getColor();
                        this.setColor(15 - stack.func_77952_i());
                        if (!player.field_71075_bZ.field_75098_d && oldColor != this.getColor()) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
                    if (player.func_70093_af()) {
                        if (this.hasVisor()) {
                            ItemStack newstack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150397_co));
                            Item.func_150898_a((Block)Blocks.field_150397_co).setDamage(newstack, this.getVisorColor());
                            this.func_70099_a(newstack, 0.0f);
                            this.setHasVisor(false);
                        }
                    } else {
                        if (this.hasVisor()) {
                            ItemStack newstack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150397_co));
                            Item.func_150898_a((Block)Blocks.field_150397_co).setDamage(newstack, this.getVisorColor());
                            this.func_70099_a(newstack, 0.0f);
                        } else {
                            this.setHasVisor(true);
                        }
                        this.setVisorColor(Item.func_150898_a((Block)Blocks.field_150397_co).getMetadata(stack));
                        stack.func_190918_g(1);
                    }
                } else {
                    if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
                        if (this.isNaked()) {
                            this.setInsigniaColor(stack.func_77952_i());
                            this.setNaked(false);
                            stack.func_190918_g(1);
                        }
                        if (stack.func_190916_E() > 0) {
                            if (player.func_70093_af()) {
                                int dress = this.getDressStyle() + 1;
                                if (dress >= PEARL_DRESS_STYLES.size() || dress < 0) {
                                    dress = 0;
                                }
                                this.setDressStyle(dress);
                                this.func_184185_a(SoundEvents.field_187728_s, this.func_70599_aP(), this.func_70647_i());
                                return true;
                            }
                            int oldColor = this.getInsigniaColor();
                            this.setInsigniaColor(stack.func_77952_i());
                            if (!player.field_71075_bZ.field_75098_d && oldColor != this.getInsigniaColor()) {
                                stack.func_190918_g(1);
                            }
                        }
                        return true;
                    }
                    if (this.isCoreItem(stack)) {
                        return super.func_184645_a(player, hand);
                    }
                    this.openGUI(player);
                    this.playObeySound();
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void func_76316_a(IInventory inventory) {
        ItemStack firstItem = this.gemStorage.func_70301_a(0);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, firstItem);
    }

    protected void func_175445_a(EntityItem itementity) {
        ItemStack itemstack = itementity.func_92059_d();
        ItemStack itemstack1 = this.gemStorage.func_174894_a(itemstack);
        if (itemstack1.func_190926_b()) {
            itementity.func_70106_y();
        } else {
            itemstack.func_190920_e(itemstack1.func_190916_E());
        }
    }

    @Override
    public boolean canPickUpItem(Item itemIn) {
        return true;
    }

    @Override
    public void setDefective(boolean defective) {
        if (defective) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, (Predicate)new Predicate<EntityLiving>(){

                public boolean apply(EntityLiving input) {
                    return input != null && IMob.field_175450_e.apply((Object)input);
                }
            }));
            this.setAttackAI();
        }
        super.setDefective(defective);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
        this.setGemColor(this.generateGemColor());
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setVisorColor(int color) {
        this.field_70180_af.func_187227_b(VISOR_COLOR, (Object)color);
    }

    public int getVisorColor() {
        return (Integer)this.field_70180_af.func_187225_a(VISOR_COLOR);
    }

    @Override
    public void setHairColor(int color) {
        this.field_70180_af.func_187227_b(HAIR_COLOR, (Object)color);
    }

    @Override
    public int getHairColor() {
        return (Integer)this.field_70180_af.func_187225_a(HAIR_COLOR);
    }

    public void setDressStyle(int dress) {
        this.field_70180_af.func_187227_b(DRESS_STYLE, (Object)dress);
    }

    public int getDressStyle() {
        return (Integer)this.field_70180_af.func_187225_a(DRESS_STYLE);
    }

    public void setNaked(boolean naked) {
        this.field_70180_af.func_187227_b(NAKED, (Object)naked);
    }

    public boolean isNaked() {
        return (Boolean)this.field_70180_af.func_187225_a(NAKED);
    }

    public String getSpecialSkin() {
        return "_" + this.getSpecial();
    }

    public void setSpecialSkin(int special) {
        super.setSpecial(special);
        switch (special) {
            case 1: {
                this.func_96094_a("Blue Pearl");
                this.setGemPlacement(GemPlacements.CHEST.id);
                this.setSpecial(1);
                this.setColor(3);
                break;
            }
            case 2: {
                this.func_96094_a("Yellow Pearl");
                this.setGemPlacement(GemPlacements.CHEST.id);
                this.setSpecial(2);
                this.setColor(4);
                break;
            }
            case 3: {
                this.func_96094_a("Pink Pearl");
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                this.setSpecial(3);
                this.setColor(0);
            }
        }
    }

    public InventoryBasic getInventory() {
        return this.gemStorage;
    }

    @Override
    public void func_70636_d() {
        if (!this.func_98052_bS()) {
            this.func_98053_h(this.isTamed());
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(Math.cos(this.field_70177_z), 2.0, Math.sin(this.field_70177_z)));
            for (EntityPlayer entity : list) {
                if (!this.isOwnedBy((EntityLivingBase)entity) || !entity.func_70093_af()) continue;
                this.func_184185_a(this.getWeirdSound(), this.func_70599_aP(), this.func_70647_i());
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public void spawnHoloPearl() {
        EntityHoloPearl holoPearl = new EntityHoloPearl(this.field_70170_p, this);
        holoPearl.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
        this.field_70170_p.func_72838_d((Entity)holoPearl);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.func_98053_h(false);
        switch (this.getColor()) {
            case 0: {
                this.droppedGemItem = ModItems.WHITE_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_WHITE_PEARL_GEM;
                break;
            }
            case 1: {
                this.droppedGemItem = ModItems.ORANGE_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_ORANGE_PEARL_GEM;
                break;
            }
            case 2: {
                this.droppedGemItem = ModItems.MAGENTA_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_MAGENTA_PEARL_GEM;
                break;
            }
            case 3: {
                this.droppedGemItem = ModItems.LIGHT_BLUE_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_BLUE_PEARL_GEM;
                break;
            }
            case 4: {
                this.droppedGemItem = ModItems.YELLOW_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_YELLOW_PEARL_GEM;
                break;
            }
            case 5: {
                this.droppedGemItem = ModItems.LIME_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIME_PEARL_GEM;
                break;
            }
            case 6: {
                this.droppedGemItem = ModItems.PINK_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PINK_PEARL_GEM;
                break;
            }
            case 7: {
                this.droppedGemItem = ModItems.GRAY_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GRAY_PEARL_GEM;
                break;
            }
            case 8: {
                this.droppedGemItem = ModItems.LIGHT_GRAY_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_GRAY_PEARL_GEM;
                break;
            }
            case 9: {
                this.droppedGemItem = ModItems.CYAN_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_CYAN_PEARL_GEM;
                break;
            }
            case 10: {
                this.droppedGemItem = ModItems.PURPLE_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PURPLE_PEARL_GEM;
                break;
            }
            case 11: {
                this.droppedGemItem = ModItems.BLUE_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_PEARL_GEM;
                break;
            }
            case 12: {
                this.droppedGemItem = ModItems.BROWN_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BROWN_PEARL_GEM;
                break;
            }
            case 13: {
                this.droppedGemItem = ModItems.GREEN_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GREEN_PEARL_GEM;
                break;
            }
            case 14: {
                this.droppedGemItem = ModItems.RED_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_RED_PEARL_GEM;
                break;
            }
            case 15: {
                this.droppedGemItem = ModItems.BLACK_PEARL_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLACK_PEARL_GEM;
            }
        }
        super.func_70645_a(cause);
    }

    private void initGemStorage() {
        InventoryBasic gemstorage = this.gemStorage;
        this.gemStorage = new InventoryBasic("gemStorage", false, this.getMaxInventorySlots());
        if (gemstorage != null) {
            gemstorage.func_110132_b((IInventoryChangedListener)this);
            for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                ItemStack itemstack = gemstorage.func_70301_a(i);
                this.gemStorage.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        this.gemStorage.func_110134_a((IInventoryChangedListener)this);
        this.gemStorageHandler = new InvWrapper((IInventory)this.gemStorage);
        this.func_98053_h(this.isTamed());
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            this.gemStorage.func_110133_a(this.func_70005_c_());
            playerEntity.func_71007_a((IInventory)this.gemStorage);
        }
    }

    public int getMaxInventorySlots() {
        int slots = 36;
        if (this.getGemPlacement() == GemPlacements.FOREHEAD) {
            slots += 9;
        }
        if (this.isDefective()) {
            slots -= 9;
        } else if (this.isPrimary()) {
            slots += 9;
        }
        return slots;
    }

    public int playNote(int tone) {
        return this.playNote(tone, ModSounds.PEARL_SING);
    }

    public int playNote(int tone, SoundEvent sound) {
        switch (tone) {
            case 0: {
                this.func_184185_a(sound, 20.0f, this.pitch * 1.0f);
            }
            case 5: {
                return 5;
            }
            case 1: {
                this.func_184185_a(sound, 20.0f, this.pitch * 1.5f);
            }
            case 6: {
                return 4;
            }
            case 2: {
                this.func_184185_a(sound, 20.0f, this.pitch * 2.0f);
            }
            case 7: {
                return 3;
            }
            case 3: {
                this.func_184185_a(sound, 20.0f, this.pitch * 2.5f);
            }
            case 8: {
                return 2;
            }
            case 4: {
                this.func_184185_a(sound, 2.0f, this.pitch * 3.0f);
            }
            case 9: {
                return 1;
            }
        }
        return 6;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.PEARL_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.PEARL_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.PEARL_DEATH;
    }

    protected SoundEvent getWeirdSound() {
        return ModSounds.PEARL_WEIRD;
    }
}

