/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAICommandGems;
import mod.akrivus.kagic.entity.ai.EntityAIExtinguishEntities;
import mod.akrivus.kagic.entity.ai.EntityAIExtinguishFires;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIGoToWater;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.ai.EntityAITillFarmland;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.heimrarnadalr.kagic.util.Colors;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityLapisLazuli
extends EntityGem
implements IInventoryChangedListener,
INpc {
    public static final HashMap<IBlockState, Double> LAPIS_LAZULI_YIELDS = new HashMap();
    public static final double LAPIS_LAZULI_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double LAPIS_LAZULI_DEPTH_THRESHOLD = 72.0;
    public static final HashMap<Integer, ResourceLocation> LAPIS_LAZULI_HAIR_STYLES = new HashMap();
    public int ticksFlying = 0;
    public boolean atWater = false;
    public InventoryBasic harvest;
    public InvWrapper harvestHandler;
    private int harvestTimer = 0;
    private static final int SKIN_COLOR_BEGIN = 5238523;
    private static final int SKIN_COLOR_END = 6210298;
    private static final int NUM_HAIRSTYLES = 1;
    private static final int HAIR_COLOR_BEGIN = 1796565;
    private static final int HAIR_COLOR_END = 5065914;

    public EntityLapisLazuli(World worldIn) {
        super(worldIn);
        this.nativeColor = 11;
        this.func_70105_a(0.6f, 1.9f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.initGemStorage();
        this.visorChanceReciprocal = 20;
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICommandGems(this, 0.6));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIExtinguishFires(this, 0.6, 8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIExtinguishEntities(this, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITillFarmland(this, 0.6));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIGoToWater(this, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.droppedGemItem = ModItems.LAPIS_LAZULI_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_LAPIS_LAZULI_GEM;
    }

    @Override
    protected int generateGemColor() {
        return 2002932;
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.TEARDROP.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.CHEST.id);
                break;
            }
            case 2: {
                this.setGemPlacement(GemPlacements.BACK.id);
            }
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.harvest.func_70302_i_(); ++i) {
            ItemStack itemstack = this.harvest.func_70301_a(i);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("harvestItems", (NBTBase)nbttaglist);
        compound.func_74768_a("harvestTimer", this.harvestTimer);
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.initGemStorage();
        NBTTagList nbttaglist = compound.func_150295_c("harvestItems", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.harvest.func_70302_i_()) continue;
            this.harvest.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        this.harvestTimer = compound.func_74762_e("harvestTimer");
        super.func_70037_a(compound);
    }

    @Override
    public boolean alternateInteract(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            if (this.isOwner((EntityLivingBase)player)) {
                if (this.isFarmer() || this.isAngler()) {
                    this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND), 0.0f);
                    this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    return true;
                }
                if (this.isPrimary()) {
                    this.field_70170_p.func_72912_H().func_176142_i(0);
                    this.field_70170_p.func_72912_H().func_76080_g(1200);
                    this.field_70170_p.func_72912_H().func_76090_f(1200);
                    this.field_70170_p.func_72912_H().func_76084_b(true);
                    return true;
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.does_not_serve_you", new Object[]{this.func_70005_c_()}));
                return true;
            }
        }
        return super.alternateInteract(player);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            if (this.isTamed() && this.isOwner((EntityLivingBase)player)) {
                if (this.isCoreItem(stack)) {
                    return super.func_184645_a(player, hand);
                }
                if (stack.func_77973_b() instanceof ItemHoe || stack.func_77973_b() instanceof ItemFishingRod) {
                    boolean toolChanged = true;
                    if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_185136_b(stack)) {
                        this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND), 0.0f);
                    } else {
                        toolChanged = false;
                    }
                    if (toolChanged) {
                        ItemStack heldItem = stack.func_77946_l();
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                        this.playObeySound();
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                if (this.isAngler()) {
                    if (this.harvest.func_191420_l()) {
                        player.func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.lapis_no_harvest", new Object[0]).func_150261_e()));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.lapis_harvest", new Object[0]).func_150261_e()));
                    }
                    this.playObeySound();
                    this.openGUI(player);
                    return true;
                }
                if (!this.isDefective()) {
                    player.field_70177_z = this.field_70177_z;
                    player.field_70125_A = this.field_70125_A;
                    player.func_184220_m((Entity)this);
                    this.playObeySound();
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.func_70107_b(this.field_70165_t, this.field_70163_u - 1.25, this.field_70161_v);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        Entity entity = this.func_184179_bs();
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase rider = (EntityLivingBase)entity;
            return this.isOwner(rider);
        }
        return false;
    }

    @Override
    public void func_191986_a(float strafe, float up, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = Math.max(-90.0f, -90.0f - entity.field_70125_A * 2.0f);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 3.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            forward = ((EntityLivingBase)entity).field_191988_bg;
            strafe = ((EntityLivingBase)entity).field_70702_br;
            if (this.func_184186_bw()) {
                if (this.func_180799_ab()) {
                    this.func_191958_b(strafe, up, 0.91f, 0.02f);
                    this.field_70181_x = forward / 10.0f;
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                } else {
                    float f = 0.91f * (this.isPrimary() ? 1.06f : 1.0f);
                    if (!this.field_70122_E) {
                        float f1 = 0.16277136f / (f * f * f);
                        this.func_191958_b(strafe, up, 0.91f, 0.2f * f1);
                    }
                    this.field_70181_x = forward / 10.0f;
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= (double)f;
                    this.field_70181_x *= (double)f;
                    this.field_70179_y *= (double)f;
                }
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = 0.0f;
            this.field_70721_aZ = 0.0f;
        } else {
            this.field_70138_W = 1.0f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, up, forward);
        }
    }

    public boolean isFarmer() {
        return this.isTamed() && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemHoe;
    }

    public boolean isAngler() {
        return this.isTamed() && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemFishingRod;
    }

    public void func_76316_a(IInventory inventory) {
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.harvest.func_70301_a(0));
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            this.harvest.func_110133_a(new TextComponentTranslation("command.kagic.lapis_inventory", new Object[]{this.func_70005_c_()}).func_150261_e());
            playerEntity.func_71007_a((IInventory)this.harvest);
        }
    }

    private void initGemStorage() {
        InventoryBasic harvest = this.harvest;
        this.harvest = new InventoryBasic("harvest", true, 36);
        if (harvest != null) {
            harvest.func_110132_b((IInventoryChangedListener)this);
            for (int i = 0; i < this.harvest.func_70302_i_(); ++i) {
                ItemStack itemstack = harvest.func_70301_a(i);
                this.harvest.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        this.harvest.func_110134_a((IInventoryChangedListener)this);
        this.harvestHandler = new InvWrapper((IInventory)this.harvest);
    }

    @Override
    public void func_70636_d() {
        this.ticksFlying = this.func_184207_aI() && !this.field_70122_E ? ++this.ticksFlying : 0;
        if (this.isAngler() && this.atWater && this.field_70173_aa % (this.field_70146_Z.nextInt(1000) + 200) == 0) {
            LootTable table = this.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186387_al);
            int luck = 0;
            for (PotionEffect effect : this.func_70651_bq()) {
                if (effect.func_188419_a() == MobEffects.field_189112_A) {
                    luck -= effect.func_76458_c();
                    continue;
                }
                if (effect.func_188419_a() != MobEffects.field_188425_z) continue;
                luck += effect.func_76458_c();
            }
            LootContext context = new LootContext.Builder(this.field_70170_p.func_73046_m().func_71218_a(this.field_71093_bK)).func_186469_a((float)luck).func_186471_a();
            List stacks = table.func_186462_a(this.field_70146_Z, context);
            this.harvest.func_174894_a((ItemStack)stacks.get(this.field_70146_Z.nextInt(stacks.size())));
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_DROP, this.field_70165_t + (double)this.field_70146_Z.nextFloat(), this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70165_t + (double)this.field_70146_Z.nextFloat(), (double)this.field_70146_Z.nextFloat(), (double)this.field_70146_Z.nextFloat(), (double)this.field_70146_Z.nextFloat(), new int[0]);
            }
        } else if (this.isFarmer() && this.field_70173_aa % 20 == 0) {
            for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)this.func_180425_c().func_177982_a(-2, -2, -2), (BlockPos)this.func_180425_c().func_177982_a(2, -1, 2))) {
                IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)pos);
                if (iblockstate.func_177230_c() != Blocks.field_150458_ak || (Integer)iblockstate.func_177229_b((IProperty)BlockFarmland.field_176531_a) >= 7) continue;
                this.field_70170_p.func_180501_a((BlockPos)pos, iblockstate.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            }
        }
        if (this.isTamed() && !this.field_70170_p.field_72995_K && !this.isDefective()) {
            List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0));
            for (EntityPlayer entity : list) {
                if (!entity.func_70026_G() || !this.isOwnedBy((EntityLivingBase)entity) || entity.func_184812_l_()) continue;
                for (int i = 0; i < 2; ++i) {
                    if (this.field_70170_p.func_180495_p(entity.func_180425_c().func_177982_a(0, i, 0)).func_177230_c() != Blocks.field_150355_j) continue;
                    this.field_70170_p.func_175698_g(entity.func_180425_c().func_177982_a(0, i, 0));
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_184207_aI() && source.func_76346_g() != null && ((Entity)this.func_184188_bt().get(0)).equals((Object)source.func_76346_g())) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.func_184207_aI()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.func_184207_aI()) {
            super.func_184231_a(y, onGroundIn, state, pos);
            if (this.isTamed() && !this.field_70170_p.field_72995_K && !this.isDefective()) {
                List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0));
                for (EntityPlayer entity : list) {
                    if (!this.isOwnedBy((EntityLivingBase)entity) || entity.func_184812_l_()) continue;
                    int blocksThatAreAir = 0;
                    for (int i = -4; i < 0; ++i) {
                        if (!this.field_70170_p.func_175623_d(entity.func_180425_c().func_177982_a(0, i, 0))) continue;
                        ++blocksThatAreAir;
                    }
                    if (blocksThatAreAir != 4) continue;
                    entity.func_184220_m((Entity)this);
                }
            }
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && cause.func_76346_g() instanceof EntitySkeleton) {
            this.func_145779_a((Item)ModItems.RECORD_LAPIS_FLIGHT, 1);
        }
        super.func_70645_a(cause);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.LAPIS_LAZULI_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.LAPIS_LAZULI_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.LAPIS_LAZULI_DEATH;
    }

    @Override
    protected int generateSkinColor() {
        ArrayList<Integer> skinColors = new ArrayList<Integer>();
        skinColors.add(5238523);
        skinColors.add(6210298);
        return Colors.arbiLerp(skinColors);
    }

    @Override
    protected int generateHairStyle() {
        return this.field_70146_Z.nextInt(1);
    }

    @Override
    protected int generateHairColor() {
        ArrayList<Integer> hairColors = new ArrayList<Integer>();
        hairColors.add(1796565);
        hairColors.add(5065914);
        return Colors.arbiLerp(hairColors);
    }
}

