/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIProtectionFuse;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.gem.EntityAmethyst;
import mod.akrivus.kagic.entity.gem.EntityLapisLazuli;
import mod.akrivus.kagic.entity.gem.EntityQuartzSoldier;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.entity.gem.fusion.EntityMalachite;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.heimrarnadalr.kagic.util.Colors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityJasper
extends EntityQuartzSoldier
implements IAnimals {
    public static final HashMap<IBlockState, Double> JASPER_YIELDS = new HashMap();
    public static final double JASPER_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double JASPER_DEPTH_THRESHOLD = 128.0;
    public static final HashMap<Integer, ResourceLocation> JASPER_HAIR_STYLES = new HashMap();
    private static final DataParameter<Boolean> CHARGED = EntityDataManager.func_187226_a(EntityJasper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MARK_1_COLOR = EntityDataManager.func_187226_a(EntityJasper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MARK_1 = EntityDataManager.func_187226_a(EntityJasper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MARK_2_COLOR = EntityDataManager.func_187226_a(EntityJasper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MARK_2 = EntityDataManager.func_187226_a(EntityJasper.class, (DataSerializer)DataSerializers.field_187192_b);
    private int charge_ticks = 0;
    private int hit_count = 0;
    private int regenTicks = 0;
    private static final int NUM_HAIRSTYLES = 5;
    private static final Map<Integer, Integer> MARK1S = new LinkedHashMap<Integer, Integer>();
    private static final Map<Integer, Integer> MARK2S;
    private static final Map<Integer, ArrayList<Integer>> SKIN_COLORS;
    private static final Map<Integer, ArrayList<Integer>> HAIR_COLORS;
    private static final Map<Integer, ArrayList<Integer>> MARK_1_COLORS;
    private static final Map<Integer, ArrayList<Integer>> MARK_2_COLORS;

    public EntityJasper(World worldIn) {
        super(worldIn);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.TINY, GemPlacements.NOSE);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BELLY);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BELLY);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(3, new EntityAIProtectionFuse<EntityLapisLazuli, EntityMalachite>(this, EntityLapisLazuli.class, EntityMalachite.class, 16.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(EntityLiving input) {
                return input != null && IMob.field_175450_e.apply((Object)input);
            }
        }));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(16.0);
        this.droppedGemItem = ModItems.JASPER_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_JASPER_GEM;
        this.field_70180_af.func_187214_a(CHARGED, (Object)false);
        this.field_70180_af.func_187214_a(MARK_1_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(MARK_1, (Object)0);
        this.field_70180_af.func_187214_a(MARK_2_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(MARK_2, (Object)0);
    }

    @Override
    protected int generateGemColor() {
        switch (this.getSpecial()) {
            case 1: {
                return 5821391;
            }
            case 2: {
                return 13928296;
            }
            case 3: {
                return 12243381;
            }
            case 4: {
                return 16762243;
            }
            case 5: {
                return 14132198;
            }
            case 6: {
                return 13076595;
            }
            case 7: {
                return 15987449;
            }
            case 8: {
                return 11546150;
            }
        }
        return 16727809;
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.TINY.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.NOSE.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.CHEST.id);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("charged", ((Boolean)this.field_70180_af.func_187225_a(CHARGED)).booleanValue());
        compound.func_74768_a("charge_ticks", this.charge_ticks);
        compound.func_74768_a("hit_count", this.hit_count);
        compound.func_74768_a("mark1color", this.getMark1Color());
        compound.func_74768_a("mark1", this.getMark1());
        compound.func_74768_a("mark2color", this.getMark2Color());
        compound.func_74768_a("mark2", this.getMark2());
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.field_70180_af.func_187227_b(CHARGED, (Object)compound.func_74767_n("charged"));
        this.charge_ticks = compound.func_74762_e("charge_ticks");
        this.hit_count = compound.func_74762_e("hit_count");
        if (compound.func_74764_b("mark1color")) {
            this.setMark1Color(compound.func_74762_e("mark1color"));
        } else {
            this.setMark1Color(this.generateMark1Color());
        }
        if (compound.func_74764_b("mark1")) {
            this.setMark1(compound.func_74762_e("mark1"));
        } else {
            this.setMark1(this.generateMark1());
        }
        if (compound.func_74764_b("mark2color")) {
            this.setMark2Color(compound.func_74762_e("mark2color"));
        } else {
            this.setMark2Color(this.generateMark2Color());
        }
        if (compound.func_74764_b("mark2")) {
            this.setMark2(compound.func_74762_e("mark2"));
        } else {
            this.setMark2(this.generateMark2());
        }
        super.func_70037_a(compound);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        int special = this.field_70146_Z.nextInt(8);
        int biomeSpecial = 0;
        Biome biome = this.field_70170_p.func_180494_b(this.func_180425_c());
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
            biomeSpecial = 0;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            biomeSpecial = 1;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            biomeSpecial = 2;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            biomeSpecial = 3;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
            biomeSpecial = 4;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            biomeSpecial = 5;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            biomeSpecial = 6;
        } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            biomeSpecial = 7;
        }
        special = KAGIC.isChristmas() ? 8 : ((double)this.field_70146_Z.nextFloat() < 0.9 ? biomeSpecial : special);
        this.itemDataToGemData(special);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void itemDataToGemData(int data) {
        if (data == 0) {
            this.nativeColor = 1;
        } else if (data == 1) {
            this.nativeColor = 9;
        } else if (data == 2) {
            this.nativeColor = 12;
        } else if (data == 3) {
            this.nativeColor = 13;
        } else if (data == 4) {
            this.nativeColor = 12;
        } else if (data == 5) {
            this.nativeColor = 10;
        } else if (data == 6) {
            this.nativeColor = 14;
        } else if (data == 7) {
            this.nativeColor = 8;
        } else if (data == 8) {
            this.nativeColor = 4;
        }
        this.func_96094_a(new TextComponentTranslation(String.format("entity.kagic.jasper_%1$d.name", data), new Object[0]).func_150261_e());
        this.setSpecial(data);
        this.setMark1(this.generateMark1());
        this.setMark1Color(this.generateMark1Color());
        this.setUniformColor(this.nativeColor);
        this.setGemColor(this.generateGemColor());
        this.setSkinColor(this.generateSkinColor());
        if (this.hasSecondMarking()) {
            this.setMark2(this.generateMark2());
            this.setMark2Color(this.generateMark2Color());
        }
    }

    @Override
    public void setNewCutPlacement() {
        GemCuts cut = this.isPrimary() ? GemCuts.TINY : (this.getSpecial() == 0 ? GemCuts.CABOCHON : GemCuts.FACETED);
        ArrayList placements = (ArrayList)this.cutPlacements.get((Object)cut);
        int placementIndex = this.field_70146_Z.nextInt(placements.size());
        GemPlacements placement = (GemPlacements)((Object)placements.get(placementIndex));
        this.setGemCut(cut.id);
        this.setGemPlacement(placement.id);
    }

    @Override
    public boolean alternateInteract(EntityPlayer player) {
        super.alternateInteract(player);
        KAGIC.instance.chatInfoMessage("Special is " + this.getSpecial());
        KAGIC.instance.chatInfoMessage("mark1Color is " + this.getMark1Color());
        KAGIC.instance.chatInfoMessage("mark1 is " + this.getMark1());
        KAGIC.instance.chatInfoMessage("mark2Color is " + this.getMark2Color());
        KAGIC.instance.chatInfoMessage("mark2 is " + this.getMark2());
        return false;
    }

    public boolean isCharged() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.field_70180_af.func_187227_b(CHARGED, (Object)charged);
    }

    public String getSpecialSkin() {
        switch (this.getSpecial()) {
            case 0: {
                return "";
            }
            case 1: {
                return "ocean_";
            }
            case 2: {
                return "biggs_";
            }
            case 3: {
                return "green_";
            }
            case 4: {
                return "bruneau_";
            }
            case 5: {
                return "purple_";
            }
            case 6: {
                return "flame_";
            }
            case 7: {
                return "picture_";
            }
            case 8: {
                return "candy_cane_";
            }
        }
        return null;
    }

    @Override
    public int getSpecial() {
        return (Integer)this.field_70180_af.func_187225_a(SPECIAL);
    }

    @Override
    public void whenDefective() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_70105_a(0.63f, 2.3f);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            this.charge_ticks += 20;
            ++this.hit_count;
            if (this.isCharged()) {
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(8.0, (double)this.field_70170_p.func_72800_K(), 8.0);
                List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
                for (EntityLivingBase entity : list) {
                    if (this.isOwner(entity)) continue;
                    boolean shouldAttack = true;
                    if (entity instanceof EntityGem) {
                        EntityGem gem = (EntityGem)entity;
                        if (this.getServitude() == gem.getServitude()) {
                            shouldAttack = this.getServitude() == 1 && this.getOwner() != null ? !this.isOwnerId(gem.func_184753_b()) : false;
                        }
                    }
                    if (!shouldAttack || !entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(7 + this.field_70146_Z.nextInt(15)))) continue;
                    entity.field_70181_x += 0.9;
                    this.func_174815_a((EntityLivingBase)this, (Entity)entity);
                }
            } else if (entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(10 + this.field_70146_Z.nextInt(15)))) {
                entityIn.field_70181_x += 0.4;
                this.func_174815_a((EntityLivingBase)this, entityIn);
            }
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public void func_70636_d() {
        if (!this.func_70090_H() || !this.field_70160_al) {
            ++this.regenTicks;
        }
        if (this.hit_count > 12) {
            --this.charge_ticks;
            this.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 80));
            this.setCharged(true);
            if (this.charge_ticks < 1) {
                this.hit_count = 0;
                this.setCharged(false);
            }
        }
        if (this.regenTicks > 200 && !this.field_70128_L && !(this.func_110143_aJ() <= 0.0f) && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(1.0f);
            this.regenTicks = 0;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && cause.func_76346_g() instanceof EntityAmethyst) {
            this.func_145779_a((Item)ModItems.RECORD_DUEL_OF_THE_QUARTZ, 1);
        }
        switch (this.getSpecial()) {
            case 0: {
                if (this.isPrimary()) {
                    this.droppedGemItem = ModItems.JASPER_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_JASPER_GEM;
                    break;
                }
                this.droppedGemItem = ModItems.NOREENA_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_NOREENA_JASPER_GEM;
                break;
            }
            case 1: {
                this.droppedGemItem = ModItems.OCEAN_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_OCEAN_JASPER_GEM;
                break;
            }
            case 2: {
                this.droppedGemItem = ModItems.BIGGS_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BIGGS_JASPER_GEM;
                break;
            }
            case 3: {
                this.droppedGemItem = ModItems.GREEN_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GREEN_JASPER_GEM;
                break;
            }
            case 4: {
                this.droppedGemItem = ModItems.BRUNEAU_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BRUNEAU_JASPER_GEM;
                break;
            }
            case 5: {
                this.droppedGemItem = ModItems.PURPLE_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PURPLE_JASPER_GEM;
                break;
            }
            case 6: {
                this.droppedGemItem = ModItems.FLAME_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_FLAME_JASPER_GEM;
                break;
            }
            case 7: {
                this.droppedGemItem = ModItems.PICTURE_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PICTURE_JASPER_GEM;
                break;
            }
            case 8: {
                this.droppedGemItem = ModItems.CANDY_CANE_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_CANDY_CANE_JASPER_GEM;
                break;
            }
            default: {
                this.droppedGemItem = ModItems.JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_JASPER_GEM;
            }
        }
        super.func_70645_a(cause);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.JASPER_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.JASPER_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.JASPER_DEATH;
    }

    @Override
    protected int generateSkinColor() {
        return Colors.arbiLerp(SKIN_COLORS.get(this.getSpecial()));
    }

    @Override
    protected int generateHairStyle() {
        return this.field_70146_Z.nextInt(5);
    }

    @Override
    protected int generateHairColor() {
        return Colors.arbiLerp(HAIR_COLORS.get(this.getSpecial()));
    }

    @Override
    public boolean hasUniformVariant(GemPlacements placement) {
        switch (placement) {
            case BELLY: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasCape() {
        return true;
    }

    @Override
    public boolean hasHairVariant(GemPlacements placement) {
        switch (placement) {
            case FOREHEAD: {
                return true;
            }
        }
        return false;
    }

    public boolean hasSecondMarking() {
        switch (this.getSpecial()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
            case 5: {
                return false;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected int generateMark1Color() {
        return Colors.arbiLerp(MARK_1_COLORS.get(this.getSpecial()));
    }

    protected int generateMark1() {
        return this.field_70146_Z.nextInt(MARK1S.get(this.getSpecial()));
    }

    protected int generateMark2Color() {
        return Colors.arbiLerp(MARK_2_COLORS.get(this.getSpecial()));
    }

    protected int generateMark2() {
        if (this.hasSecondMarking()) {
            return this.field_70146_Z.nextInt(MARK2S.get(this.getSpecial()));
        }
        return 0;
    }

    public int getMark1Color() {
        return (Integer)this.field_70180_af.func_187225_a(MARK_1_COLOR);
    }

    public void setMark1Color(int mark1Color) {
        this.field_70180_af.func_187227_b(MARK_1_COLOR, (Object)mark1Color);
    }

    public int getMark1() {
        return (Integer)this.field_70180_af.func_187225_a(MARK_1);
    }

    public void setMark1(int mark1) {
        this.field_70180_af.func_187227_b(MARK_1, (Object)mark1);
    }

    public int getMark2Color() {
        return (Integer)this.field_70180_af.func_187225_a(MARK_2_COLOR);
    }

    public void setMark2Color(int mark2Color) {
        this.field_70180_af.func_187227_b(MARK_2_COLOR, (Object)mark2Color);
    }

    public int getMark2() {
        return (Integer)this.field_70180_af.func_187225_a(MARK_2);
    }

    public void setMark2(int mark2) {
        this.field_70180_af.func_187227_b(MARK_2, (Object)mark2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return this.isCharged() ? 0xF000F0 : super.func_70070_b();
    }

    @Override
    public float func_70013_c() {
        return this.isCharged() ? 1.0f : super.func_70013_c();
    }

    static {
        MARK1S.put(0, 6);
        MARK1S.put(1, 1);
        MARK1S.put(2, 1);
        MARK1S.put(3, 1);
        MARK1S.put(4, 1);
        MARK1S.put(5, 1);
        MARK1S.put(6, 1);
        MARK1S.put(7, 1);
        MARK1S.put(8, 1);
        MARK2S = new LinkedHashMap<Integer, Integer>();
        MARK2S.put(0, 0);
        MARK2S.put(1, 1);
        MARK2S.put(2, 1);
        MARK2S.put(3, 0);
        MARK2S.put(4, 1);
        MARK2S.put(5, 0);
        MARK2S.put(6, 1);
        MARK2S.put(7, 1);
        MARK2S.put(8, 2);
        SKIN_COLORS = new LinkedHashMap<Integer, ArrayList<Integer>>();
        ArrayList<Integer> normal = new ArrayList<Integer>();
        normal.add(16766621);
        normal.add(16555119);
        normal.add(16418409);
        normal.add(16753489);
        normal.add(16089177);
        normal.add(15234139);
        SKIN_COLORS.put(0, normal);
        ArrayList<Integer> ocean = new ArrayList<Integer>();
        ocean.add(7388359);
        ocean.add(4686743);
        SKIN_COLORS.put(1, ocean);
        ArrayList<Integer> biggs = new ArrayList<Integer>();
        biggs.add(12348008);
        SKIN_COLORS.put(2, biggs);
        ArrayList<Integer> green = new ArrayList<Integer>();
        green.add(5144173);
        SKIN_COLORS.put(3, green);
        ArrayList<Integer> bruneau = new ArrayList<Integer>();
        bruneau.add(11757877);
        SKIN_COLORS.put(4, bruneau);
        ArrayList<Integer> purple = new ArrayList<Integer>();
        purple.add(9068679);
        SKIN_COLORS.put(5, purple);
        ArrayList<Integer> flame = new ArrayList<Integer>();
        flame.add(11029309);
        SKIN_COLORS.put(6, flame);
        ArrayList<Integer> picture = new ArrayList<Integer>();
        picture.add(14649961);
        SKIN_COLORS.put(7, picture);
        ArrayList<Integer> candyCane = new ArrayList<Integer>();
        candyCane.add(0xF9FFFE);
        SKIN_COLORS.put(8, candyCane);
        HAIR_COLORS = new LinkedHashMap<Integer, ArrayList<Integer>>();
        normal = new ArrayList();
        normal.add(0xFEFFEC);
        normal.add(16776424);
        normal.add(16773332);
        normal.add(16639961);
        normal.add(16766621);
        HAIR_COLORS.put(0, normal);
        ocean = new ArrayList();
        ocean.add(16447996);
        HAIR_COLORS.put(1, ocean);
        biggs = new ArrayList();
        biggs.add(16644330);
        HAIR_COLORS.put(2, biggs);
        green = new ArrayList();
        green.add(0xDADCCC);
        HAIR_COLORS.put(3, green);
        bruneau = new ArrayList();
        bruneau.add(16436641);
        HAIR_COLORS.put(4, bruneau);
        purple = new ArrayList();
        purple.add(14601681);
        HAIR_COLORS.put(5, purple);
        flame = new ArrayList();
        flame.add(15782598);
        HAIR_COLORS.put(6, flame);
        picture = new ArrayList();
        picture.add(15457482);
        HAIR_COLORS.put(7, picture);
        candyCane = new ArrayList();
        candyCane.add(0xF9FFFE);
        HAIR_COLORS.put(8, candyCane);
        MARK_1_COLORS = new LinkedHashMap<Integer, ArrayList<Integer>>();
        normal = new ArrayList();
        normal.add(16089177);
        normal.add(15551036);
        normal.add(16133958);
        normal.add(15799852);
        normal.add(13637417);
        normal.add(11273506);
        MARK_1_COLORS.put(0, normal);
        ocean = new ArrayList();
        ocean.add(4686743);
        ocean.add(1523541);
        MARK_1_COLORS.put(1, ocean);
        biggs = new ArrayList();
        biggs.add(14134149);
        biggs.add(13011318);
        MARK_1_COLORS.put(2, biggs);
        green = new ArrayList();
        green.add(7187352);
        MARK_1_COLORS.put(3, green);
        bruneau = new ArrayList();
        bruneau.add(15048532);
        MARK_1_COLORS.put(4, bruneau);
        purple = new ArrayList();
        purple.add(8553354);
        MARK_1_COLORS.put(5, purple);
        flame = new ArrayList();
        flame.add(14710633);
        MARK_1_COLORS.put(6, flame);
        picture = new ArrayList();
        picture.add(13266019);
        MARK_1_COLORS.put(7, picture);
        candyCane = new ArrayList();
        candyCane.add(11546150);
        MARK_1_COLORS.put(8, candyCane);
        MARK_2_COLORS = new LinkedHashMap<Integer, ArrayList<Integer>>();
        normal = new ArrayList();
        normal.add(0);
        MARK_2_COLORS.put(0, normal);
        ocean = new ArrayList();
        ocean.add(16022421);
        ocean.add(16761811);
        MARK_2_COLORS.put(1, ocean);
        biggs = new ArrayList();
        biggs.add(10637390);
        MARK_2_COLORS.put(2, biggs);
        green = new ArrayList();
        green.add(0);
        MARK_2_COLORS.put(3, green);
        bruneau = new ArrayList();
        bruneau.add(9064731);
        MARK_2_COLORS.put(4, bruneau);
        purple = new ArrayList();
        purple.add(0);
        MARK_2_COLORS.put(5, purple);
        flame = new ArrayList();
        flame.add(16756114);
        MARK_2_COLORS.put(6, flame);
        picture = new ArrayList();
        picture.add(9535883);
        MARK_2_COLORS.put(7, picture);
        candyCane = new ArrayList();
        candyCane.add(6192150);
        MARK_2_COLORS.put(8, candyCane);
    }
}

