/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.gem.EntityQuartzSoldier;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.heimrarnadalr.kagic.util.Colors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCitrine
extends EntityQuartzSoldier
implements IAnimals {
    public static final HashMap<IBlockState, Double> CITRINE_YIELDS = new HashMap();
    public static final double CITRINE_DEFECTIVITY_MULTIPLIER = 2.0;
    public static final double CITRINE_DEPTH_THRESHOLD = 64.0;
    public static final HashMap<Integer, ResourceLocation> CITRINE_HAIR_STYLES = new HashMap();
    private static final DataParameter<Boolean> CHARGED = EntityDataManager.func_187226_a(EntityCitrine.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DEFECTIVE_COLOR = EntityDataManager.func_187226_a(EntityCitrine.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final int SKIN_COLOR_BEGIN = 16774012;
    public static final int SKIN_COLOR_END = 16749568;
    public static final int HAIR_COLOR_BEGIN = 15850127;
    public static final int HAIR_COLOR_END = 0xFFFF01;
    private static final int NUM_HAIRSTYLES = 5;
    private int charge_ticks = 0;
    private int hit_count = 0;

    public EntityCitrine(World worldIn) {
        super(worldIn);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_SHOULDER);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_SHOULDER);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_HAND);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_HAND);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BELLY);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_THIGH);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_THIGH);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_KNEE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_KNEE);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(EntityLiving input) {
                return input != null && IMob.field_175450_e.apply((Object)input);
            }
        }));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.droppedGemItem = ModItems.AMETHYST_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_AMETHYST_GEM;
        this.field_70180_af.func_187214_a(CHARGED, (Object)false);
        this.field_70180_af.func_187214_a(DEFECTIVE_COLOR, (Object)0);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (this.isDefective()) {
            this.func_96094_a(new TextComponentTranslation("entity.kagic.citrine_1.name", new Object[0]).func_150261_e());
            this.setSpecial(this.field_70146_Z.nextInt(2));
            this.generateDefectiveColor();
        }
        this.nativeColor = this.getSpecial() == 1 ? 8 : 12;
        this.field_70180_af.func_187227_b(DEFECTIVE_COLOR, (Object)this.generateDefectiveColor());
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("charged", ((Boolean)this.field_70180_af.func_187225_a(CHARGED)).booleanValue());
        compound.func_74768_a("charge_ticks", this.charge_ticks);
        compound.func_74768_a("hit_count", this.hit_count);
        compound.func_74768_a("defectiveColors", ((Integer)this.field_70180_af.func_187225_a(DEFECTIVE_COLOR)).intValue());
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.field_70180_af.func_187227_b(CHARGED, (Object)compound.func_74767_n("charged"));
        this.charge_ticks = compound.func_74762_e("charge_ticks");
        this.hit_count = compound.func_74762_e("hit_count");
        this.field_70180_af.func_187227_b(DEFECTIVE_COLOR, (Object)compound.func_74762_e("defectiveColors"));
        super.func_70037_a(compound);
    }

    @Override
    protected int generateGemColor() {
        return this.getSpecial() == 1 ? 14443773 : 15465828;
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.FACETED.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.CHEST.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.RIGHT_SHOULDER.id);
                break;
            }
            case 2: {
                this.setGemPlacement(GemPlacements.BELLY.id);
                break;
            }
            case 3: {
                this.setGemPlacement(GemPlacements.LEFT_SHOULDER.id);
            }
        }
    }

    public boolean isCharged() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.field_70180_af.func_187227_b(CHARGED, (Object)charged);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            this.charge_ticks += 20;
            ++this.hit_count;
            boolean smite = this.field_70146_Z.nextInt(3) == 1;
            this.field_70178_ae = smite;
            if (this.isCharged()) {
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(12.0, (double)this.field_70170_p.func_72800_K(), 12.0);
                List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
                for (EntityLivingBase entity : list) {
                    if (this.isOwner(entity)) continue;
                    boolean shouldAttack = true;
                    if (entity instanceof EntityGem) {
                        EntityGem gem = (EntityGem)entity;
                        if (this.getServitude() == gem.getServitude()) {
                            shouldAttack = this.getServitude() == 1 ? !this.isOwnerId(gem.func_184753_b()) : false;
                        }
                    }
                    if (!shouldAttack) continue;
                    if (smite) {
                        EntityLightningBolt lightningBolt = new EntityLightningBolt(this.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true);
                        this.field_70170_p.func_72942_c((Entity)lightningBolt);
                        entity.func_70015_d(12);
                    }
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 80));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 80));
                }
            } else {
                if (smite) {
                    EntityLightningBolt lightningBolt = new EntityLightningBolt(this.field_70170_p, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, true);
                    this.field_70170_p.func_72942_c((Entity)lightningBolt);
                    entityIn.func_70015_d(12);
                }
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76419_f, 80));
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80));
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 80));
            }
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70652_k((Entity)target);
        }
        super.func_82196_d(target, distanceFactor);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (this.isDefective()) {
            this.droppedGemItem = ModItems.AMETRINE_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_AMETRINE_GEM;
        } else {
            this.droppedGemItem = ModItems.CITRINE_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_CITRINE_GEM;
        }
        super.func_70645_a(cause);
    }

    @Override
    public void func_70636_d() {
        if (this.hit_count > 7) {
            --this.charge_ticks;
            this.setCharged(true);
            if (this.charge_ticks < 7) {
                this.hit_count = 0;
                this.setCharged(false);
            }
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.JASPER_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.JASPER_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.JASPER_DEATH;
    }

    @Override
    public void itemDataToGemData(int data) {
        this.setDefective(data == 1);
        if (this.isDefective()) {
            this.func_96094_a(new TextComponentTranslation("entity.kagic.citrine_1.name", new Object[0]).func_150261_e());
            this.setSpecial(this.field_70146_Z.nextInt(2));
            this.generateDefectiveColor();
        }
        this.nativeColor = this.getSpecial() == 1 ? 8 : 12;
        this.field_70180_af.func_187227_b(DEFECTIVE_COLOR, (Object)this.generateDefectiveColor());
        super.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
    }

    @Override
    public int generateSkinColor() {
        ArrayList<Integer> skinColors = new ArrayList<Integer>();
        if (this.getSpecial() == 1) {
            skinColors.add(13811681);
            skinColors.add(11875965);
        } else {
            skinColors.add(16774012);
            skinColors.add(16749568);
        }
        return Colors.arbiLerp(skinColors);
    }

    public int generateDefectiveColor() {
        ArrayList<Integer> skinColors = new ArrayList<Integer>();
        if (this.getSpecial() == 0) {
            skinColors.add(13811681);
            skinColors.add(11875965);
        } else {
            skinColors.add(16774012);
            skinColors.add(16749568);
        }
        return Colors.arbiLerp(skinColors);
    }

    public int getDefectiveColor() {
        return (Integer)this.field_70180_af.func_187225_a(DEFECTIVE_COLOR);
    }

    @Override
    protected int generateHairStyle() {
        return this.field_70146_Z.nextInt(5);
    }

    @Override
    protected int generateHairColor() {
        ArrayList<Integer> hairColors = new ArrayList<Integer>();
        if (this.getSpecial() == 1) {
            hairColors.add(12417481);
            hairColors.add(12877219);
        } else {
            hairColors.add(15850127);
            hairColors.add(0xFFFF01);
        }
        return Colors.arbiLerp(hairColors);
    }

    @Override
    public boolean hasUniformVariant(GemPlacements placement) {
        switch (placement) {
            case BELLY: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasCape() {
        return true;
    }

    @Override
    public boolean hasHairVariant(GemPlacements placement) {
        switch (placement) {
            case FOREHEAD: {
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return this.isCharged() ? 0xF000F0 : super.func_70070_b();
    }

    @Override
    public float func_70013_c() {
        return this.isCharged() ? 1.0f : super.func_70013_c();
    }
}

