/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAICommandGems;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.event.BismuthInteractEvent;
import mod.akrivus.kagic.init.ModEnchantments;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.heimrarnadalr.kagic.util.Colors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityBismuth
extends EntityGem
implements IInventoryChangedListener,
INpc {
    public static final HashMap<IBlockState, Double> BISMUTH_YIELDS = new HashMap();
    public static final double BISMUTH_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double BISMUTH_DEPTH_THRESHOLD = 0.0;
    public static final HashMap<Integer, ResourceLocation> BISMUTH_HAIR_STYLES = new HashMap();
    private static final int SKIN_COLOR_BEGIN = 9545935;
    private static final int SKIN_COLOR_END = 5255747;
    public InventoryBasic gemStorage;
    public InvWrapper gemStorageHandler;

    public EntityBismuth(World worldIn) {
        super(worldIn);
        this.nativeColor = 7;
        this.field_70178_ae = true;
        this.initGemStorage();
        this.func_70105_a(0.9f, 2.3f);
        this.setCutPlacement(GemCuts.BISMUTH, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.BISMUTH, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.BISMUTH, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.BISMUTH, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICommandGems(this, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.droppedGemItem = ModItems.BISMUTH_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_BISMUTH_GEM;
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.BISMUTH.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.CHEST.id);
            }
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
            ItemStack itemstack = this.gemStorage.func_70301_a(i);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("items", (NBTBase)nbttaglist);
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("items", 10);
        this.initGemStorage();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.gemStorage.func_70302_i_()) continue;
            this.gemStorage.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        super.func_70037_a(compound);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            if (this.isTamed() && this.isOwner((EntityLivingBase)player)) {
                ItemStack result;
                if (this.isCoreItem(stack)) {
                    return super.func_184645_a(player, hand);
                }
                BismuthInteractEvent e1 = new BismuthInteractEvent(this, player, stack);
                if (MinecraftForge.EVENT_BUS.post((Event)e1)) {
                    return false;
                }
                if (player.func_70093_af() && !this.isDefective()) {
                    this.openGUI(player);
                    this.playObeySound();
                    return true;
                }
                if (stack.func_77984_f() && !this.isDefective()) {
                    if (stack.func_77951_h()) {
                        int damage = stack.func_77952_i() - stack.func_77958_k();
                        stack.func_77972_a(damage, (EntityLivingBase)this);
                        if (!stack.func_77948_v() && stack.func_77956_u() && this.field_70146_Z.nextInt(300) == 0) {
                            List list = EnchantmentHelper.func_77513_b((Random)this.field_70146_Z, (ItemStack)stack, (int)(damage / 10), (boolean)true);
                            for (int i = 0; i < list.size(); ++i) {
                                EnchantmentData data = (EnchantmentData)list.get(i);
                                stack.func_77966_a(data.field_76302_b, data.field_76303_c);
                            }
                            if (list.size() > 1 && this.field_70146_Z.nextInt(30) == 0) {
                                if (this.field_70146_Z.nextInt(90) == 0) {
                                    stack.func_77966_a((Enchantment)ModEnchantments.BREAKING_POINT, 1);
                                } else {
                                    stack.func_77966_a((Enchantment)ModEnchantments.FAIR_FIGHT, 1);
                                }
                            }
                        }
                    }
                } else if (!(stack.func_190926_b() || this.isDefective() || (result = this.smeltItem(stack)).func_190926_b())) {
                    if (player.field_71071_by.func_70447_i() > -1) {
                        player.field_71071_by.func_70441_a(result);
                    } else {
                        this.func_70099_a(result, 0.0f);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void func_76316_a(IInventory inventory) {
        ItemStack firstItem = this.gemStorage.func_70301_a(0);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, firstItem);
    }

    protected void func_175445_a(EntityItem itementity) {
        ItemStack itemstack = itementity.func_92059_d();
        ItemStack itemstack1 = this.gemStorage.func_174894_a(itemstack);
        if (itemstack1.func_190926_b()) {
            itementity.func_70106_y();
        } else {
            itemstack.func_190920_e(itemstack1.func_190916_E());
        }
    }

    @Override
    public boolean canPickUpItem(Item itemIn) {
        return true;
    }

    public InventoryBasic getInventory() {
        return this.gemStorage;
    }

    public ItemStack smeltItem(ItemStack stack) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
        return result;
    }

    private void initGemStorage() {
        InventoryBasic gemstorage = this.gemStorage;
        this.gemStorage = new InventoryBasic("gemStorage", false, 36);
        if (gemstorage != null) {
            gemstorage.func_110132_b((IInventoryChangedListener)this);
            for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                ItemStack itemstack = gemstorage.func_70301_a(i);
                this.gemStorage.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        this.gemStorage.func_110134_a((IInventoryChangedListener)this);
        this.gemStorageHandler = new InvWrapper((IInventory)this.gemStorage);
        this.func_98053_h(this.isTamed());
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            this.gemStorage.func_110133_a(this.func_70005_c_());
            playerEntity.func_71007_a((IInventory)this.gemStorage);
        }
    }

    @Override
    public void whenDefective() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_70105_a(0.6f, 2.07f);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        ItemStack heldItem;
        if (!this.field_70170_p.field_72995_K && cause.func_76346_g() instanceof EntityLivingBase && (heldItem = ((EntityLivingBase)cause.func_76346_g()).func_184614_ca()).func_77948_v()) {
            NBTTagList enchantments = heldItem.func_77986_q();
            for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                if (enchantments.func_150305_b(i).func_74762_e("id") != Enchantment.func_185258_b((Enchantment)ModEnchantments.BREAKING_POINT)) continue;
                this.func_145779_a((Item)ModItems.RECORD_THE_BREAKING_POINT, 1);
            }
        }
        super.func_70645_a(cause);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.BISMUTH_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.BISMUTH_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.BISMUTH_DEATH;
    }

    @Override
    protected int generateSkinColor() {
        ArrayList<Integer> skinColors = new ArrayList<Integer>();
        skinColors.add(9545935);
        skinColors.add(5255747);
        return Colors.arbiLerp(skinColors);
    }
}

