/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import mod.akrivus.kagic.entity.ai.EntityAIScareMobs;
import mod.akrivus.kagic.entity.ai.EntityAISitStill;
import mod.akrivus.kagic.entity.gem.EntityQuartzSoldier;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityAgate
extends EntityQuartzSoldier
implements IAnimals {
    public static final HashMap<IBlockState, Double> AGATE_YIELDS = new HashMap();
    public static final double AGATE_DEFECTIVITY_MULTIPLIER = 1.0;
    public static final double AGATE_DEPTH_THRESHOLD = 64.0;
    public static final ArrayList<ResourceLocation> AGATE_HAIR_STYLES = new ArrayList();
    public static final ArrayList<ResourceLocation> AGATE_BAND_STYLES = new ArrayList();
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityAgate.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final float[][] AGATECOLORS = new float[][]{{0.9764706f, 1.0f, 0.99607843f}, {0.9764706f, 0.5019608f, 0.11372549f}, {0.78039217f, 0.30588236f, 0.7411765f}, {0.22745098f, 0.7019608f, 0.85490197f}, {0.99607843f, 0.84705883f, 0.23921569f}, {0.5019608f, 0.78039217f, 0.12156863f}, {0.9529412f, 0.54509807f, 0.6666667f}, {0.2784314f, 0.30980393f, 0.32156864f}, {0.6156863f, 0.6156863f, 0.5921569f}, {0.08627451f, 0.6117647f, 0.6117647f}, {0.5372549f, 0.19607843f, 0.72156864f}, {0.23529412f, 0.26666668f, 0.6666667f}, {0.5137255f, 0.32941177f, 0.19607843f}, {0.36862746f, 0.4862745f, 0.08627451f}, {0.6901961f, 0.18039216f, 0.14901961f}, {0.11372549f, 0.11372549f, 0.12941177f}};
    public static final float[][] BANDCOLORS = new float[][]{{0.9764706f, 1.0f, 0.99607843f}, {0.9764706f, 0.5019608f, 0.11372549f}, {0.6156863f, 0.6156863f, 0.5921569f}, {0.9529412f, 0.54509807f, 0.6666667f}, {0.99607843f, 0.84705883f, 0.23921569f}, {0.9764706f, 1.0f, 0.99607843f}, {0.9529412f, 0.54509807f, 0.6666667f}, {0.2784314f, 0.30980393f, 0.32156864f}, {0.6156863f, 0.6156863f, 0.5921569f}, {0.99607843f, 0.84705883f, 0.23921569f}, {0.9764706f, 0.5019608f, 0.11372549f}, {0.22745098f, 0.7019608f, 0.85490197f}, {0.22745098f, 0.7019608f, 0.85490197f}, {0.6156863f, 0.6156863f, 0.5921569f}, {0.9764706f, 1.0f, 0.99607843f}, {0.9764706f, 1.0f, 0.99607843f}};

    public EntityAgate(World worldIn) {
        super(worldIn);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_SHOULDER);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_SHOULDER);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_HAND);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_HAND);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BELLY);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_THIGH);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_THIGH);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_KNEE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_KNEE);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISitStill(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIScareMobs(this));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.droppedGemItem = ModItems.AGATE_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_AGATE_GEM;
        this.field_70180_af.func_187214_a(COLOR, (Object)new Random().nextInt(16));
        this.nativeColor = (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    @Override
    protected int generateGemColor() {
        switch (this.getColor()) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                return 13333030;
            }
            case 2: {
                return 11421908;
            }
            case 3: {
                return 2184339;
            }
            case 4: {
                return 16711244;
            }
            case 5: {
                return 4625152;
            }
            case 6: {
                return 15234459;
            }
            case 7: {
                return 0x939393;
            }
            case 8: {
                return 0x8F8F8F;
            }
            case 9: {
                return 6724019;
            }
            case 10: {
                return 8076206;
            }
            case 11: {
                return 3888314;
            }
            case 12: {
                return 5125147;
            }
            case 13: {
                return 5006617;
            }
            case 14: {
                return 9842736;
            }
            case 15: {
                return 0x333333;
            }
        }
        return 9660408;
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.TEARDROP.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.BACK_OF_HEAD.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                break;
            }
            case 2: {
                this.setGemPlacement(GemPlacements.RIGHT_SHOULDER.id);
                break;
            }
            case 3: {
                this.setGemPlacement(GemPlacements.LEFT_SHOULDER.id);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("color", ((Integer)this.field_70180_af.func_187225_a(COLOR)).intValue());
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74762_e("color"));
        if (compound.func_74764_b("holly")) {
            this.setSpecial(compound.func_74767_n("holly") ? 1 : 0);
            this.setGemPlacement(GemPlacements.BACK_OF_HEAD.id);
            this.setGemCut(GemCuts.TEARDROP.id);
            if (this.getUniformColor() > 15) {
                this.setUniformColor(3);
                this.nativeColor = 3;
                this.setSpecial(1);
            }
        }
        super.func_70037_a(compound);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        boolean holly = this.field_70146_Z.nextInt(9) == 0 || this.getSpecial() == 1;
        this.itemDataToGemData((Integer)this.field_70180_af.func_187225_a(COLOR));
        if (holly) {
            this.func_96094_a(new TextComponentTranslation("entity.kagic.agate_16.name", new Object[0]).func_150261_e());
            this.setGemPlacement(GemPlacements.BACK_OF_HEAD.id);
            this.setGemCut(GemCuts.TEARDROP.id);
            this.nativeColor = 3;
            this.setSpecial(1);
        } else {
            this.func_96094_a(new TextComponentTranslation(String.format("entity.kagic.agate_%1$d.name", this.getColor()), new Object[0]).func_150261_e());
            this.setUniformColor((Integer)this.field_70180_af.func_187225_a(COLOR));
            this.nativeColor = this.getUniformColor();
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void itemDataToGemData(int data) {
        this.field_70180_af.func_187227_b(COLOR, (Object)data);
        this.setSkinColor(this.generateSkinColor());
        this.setHairStyle(this.generateHairStyle());
        this.setHairColor(this.generateHairColor());
        this.setGemColor(this.generateGemColor());
        this.func_96094_a(new TextComponentTranslation(String.format("entity.kagic.agate_%1$d.name", data), new Object[0]).func_150261_e());
        if (data > 15) {
            this.setUniformColor(3);
            this.nativeColor = 3;
            this.setSpecial(1);
        } else {
            this.setUniformColor(data);
            this.nativeColor = data;
            this.setSpecial(0);
        }
    }

    @Override
    public boolean alternateInteract(EntityPlayer player) {
        super.alternateInteract(player);
        KAGIC.instance.chatInfoMessage("Agate type is " + this.getColor());
        return false;
    }

    public int getColor() {
        if (this.isHolly()) {
            return 3;
        }
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public boolean isHolly() {
        return this.getSpecial() == 1 || this.func_70005_c_().toLowerCase().contains("holly");
    }

    @Override
    public void whenDefective() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_70105_a(0.72f, 1.84f);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        switch (this.getColor()) {
            case 0: {
                this.droppedGemItem = ModItems.WHITE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_WHITE_AGATE_GEM;
                break;
            }
            case 1: {
                this.droppedGemItem = ModItems.ORANGE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_ORANGE_AGATE_GEM;
                break;
            }
            case 2: {
                this.droppedGemItem = ModItems.MAGENTA_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_MAGENTA_AGATE_GEM;
                break;
            }
            case 3: {
                this.droppedGemItem = ModItems.LIGHT_BLUE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_BLUE_AGATE_GEM;
                break;
            }
            case 4: {
                this.droppedGemItem = ModItems.YELLOW_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_YELLOW_AGATE_GEM;
                break;
            }
            case 5: {
                this.droppedGemItem = ModItems.LIME_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIME_AGATE_GEM;
                break;
            }
            case 6: {
                this.droppedGemItem = ModItems.PINK_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PINK_AGATE_GEM;
                break;
            }
            case 7: {
                this.droppedGemItem = ModItems.GRAY_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GRAY_AGATE_GEM;
                break;
            }
            case 8: {
                this.droppedGemItem = ModItems.LIGHT_GRAY_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_GRAY_AGATE_GEM;
                break;
            }
            case 9: {
                this.droppedGemItem = ModItems.CYAN_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_CYAN_AGATE_GEM;
                break;
            }
            case 10: {
                this.droppedGemItem = ModItems.PURPLE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PURPLE_AGATE_GEM;
                break;
            }
            case 11: {
                this.droppedGemItem = ModItems.BLUE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_AGATE_GEM;
                break;
            }
            case 12: {
                this.droppedGemItem = ModItems.BROWN_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BROWN_AGATE_GEM;
                break;
            }
            case 13: {
                this.droppedGemItem = ModItems.GREEN_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GREEN_AGATE_GEM;
                break;
            }
            case 14: {
                this.droppedGemItem = ModItems.RED_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_RED_AGATE_GEM;
                break;
            }
            case 15: {
                this.droppedGemItem = ModItems.BLACK_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLACK_AGATE_GEM;
            }
        }
        if (this.isHolly()) {
            this.droppedGemItem = ModItems.HOLLY_BLUE_AGATE_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_HOLLY_BLUE_AGATE_GEM;
        }
        super.func_70645_a(cause);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.AGATE_HURT;
    }

    @Override
    protected SoundEvent getObeySound() {
        return ModSounds.AGATE_OBEY;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.AGATE_DEATH;
    }

    @Override
    protected int generateHairStyle() {
        if (this.isHolly()) {
            return 0;
        }
        return this.field_70146_Z.nextInt(AGATE_HAIR_STYLES.size());
    }

    @Override
    public boolean hasUniformVariant(GemPlacements placement) {
        switch (placement) {
            case BELLY: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasCape() {
        return true;
    }

    public boolean hasBands() {
        if (this.isHolly()) {
            return false;
        }
        switch (this.getColor()) {
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 5: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }
}

