/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.ai;

import mod.akrivus.kagic.entity.gem.EntityRutile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;

public class EntityAIFindDarkSpots
extends EntityAIBase {
    private final EntityRutile gem;
    private final double movementSpeed;
    private final int searchRadius;
    private int currentLight = 8;
    private boolean placed = false;
    private double posX;
    private double posY;
    private double posZ;
    private int delay;

    public EntityAIFindDarkSpots(EntityRutile gemIn, double speedIn, int radius) {
        this.gem = gemIn;
        this.movementSpeed = speedIn;
        this.searchRadius = radius;
        this.delay = 0;
        this.func_75248_a(0);
    }

    public boolean func_75250_a() {
        if (!this.gem.func_184614_ca().func_190926_b() && Block.func_149634_a((Item)this.gem.func_184614_ca().func_77973_b()) == Blocks.field_150478_aa) {
            if (this.delay > 0) {
                --this.delay;
                return false;
            }
            this.delay = this.gem.func_70681_au().nextInt(20);
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        boolean found = false;
        for (int x = -this.searchRadius; x <= this.searchRadius && !found; ++x) {
            block1: for (int y = -2; y <= 2 && !found; ++y) {
                for (int z = -this.searchRadius; z <= this.searchRadius && !found; ++z) {
                    BlockPos tempPos = this.gem.func_180425_c().func_177971_a((Vec3i)new BlockPos(x, y, z));
                    if (this.gem.field_70170_p.func_175623_d(tempPos) && this.gem.field_70170_p.isSideSolid(tempPos.func_177977_b(), EnumFacing.UP)) {
                        int tempLight = this.gem.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, tempPos);
                        if (tempLight >= this.currentLight) continue;
                        this.posX = tempPos.func_177958_n();
                        this.posY = tempPos.func_177956_o();
                        this.posZ = tempPos.func_177952_p();
                        found = true;
                        continue block1;
                    }
                    if (!this.isFallingBlock(tempPos)) continue;
                    int numberOfBlocks = 0;
                    for (int i = 1; i < 5; ++i) {
                        if (!this.isFallingBlock(tempPos.func_177981_b(i))) continue;
                        ++numberOfBlocks;
                    }
                    if (numberOfBlocks <= 3) continue;
                    this.posX = tempPos.func_177958_n();
                    this.posY = tempPos.func_177956_o();
                    this.posZ = tempPos.func_177952_p();
                    found = true;
                    continue block1;
                }
            }
        }
        if (found) {
            this.gem.func_70661_as().func_75492_a(this.posX, this.posY, this.posZ, this.movementSpeed);
        }
    }

    public boolean func_75253_b() {
        return !this.gem.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.gem.func_70661_as().func_75499_g();
        this.placed = false;
    }

    public void func_75246_d() {
        BlockPos pos = new BlockPos(this.posX, this.posY, this.posZ);
        this.gem.func_70661_as().func_75492_a(this.posX, this.posY, this.posZ, this.movementSpeed);
        if (this.gem.func_70092_e(this.posX, this.posY, this.posZ) < 5.0 && (this.gem.field_70170_p.func_175623_d(pos) || this.isFallingBlock(pos)) && !this.placed) {
            this.gem.placeBlock(Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP), new BlockPos(this.posX, this.posY, this.posZ));
            if (this.isFallingBlock(new BlockPos(this.posX, this.posY + 1.0, this.posZ))) {
                this.gem.field_70170_p.func_175655_b(new BlockPos(this.posX, this.posY + 1.0, this.posZ), true);
            }
            this.gem.func_184614_ca().func_190918_g(1);
            this.placed = true;
        }
    }

    public boolean isFallingBlock(BlockPos pos) {
        return this.gem.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockFalling;
    }
}

