/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.KAGIC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityFusionGem
extends EntityGem {
    private NBTTagList fusionGems = new NBTTagList();
    private ArrayList<Class<? extends EntityGem>> gemTypes = new ArrayList();
    private ArrayList<GemCuts> fusionGemCuts = new ArrayList();
    private ArrayList<GemPlacements> fusionGemPlacements = new ArrayList();
    protected static final DataParameter<String> FUSION_TYPES = EntityDataManager.func_187226_a(EntityFusionGem.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Integer> DEFECTIVE_COUNT = EntityDataManager.func_187226_a(EntityFusionGem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> PRIME_COUNT = EntityDataManager.func_187226_a(EntityFusionGem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> FUSION_COLOR = EntityDataManager.func_187226_a(EntityFusionGem.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityFusionGem(World world) {
        super(world);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(EntityLiving input) {
                return input != null && IMob.field_175450_e.apply((Object)input);
            }
        }));
        this.isSoldier = true;
        this.field_70180_af.func_187214_a(FUSION_TYPES, (Object)"");
        this.field_70180_af.func_187214_a(DEFECTIVE_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(PRIME_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(FUSION_COLOR, (Object)0);
        this.setFusionCount(0);
        this.pitch = 0.0f;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound comp) {
        comp.func_74782_a("gems", (NBTBase)this.fusionGems);
        NBTTagList types = new NBTTagList();
        for (int i = 0; i < this.gemTypes.size(); ++i) {
            NBTTagString nbt = new NBTTagString(this.gemTypes.get(i).getName());
            types.func_74742_a((NBTBase)nbt);
        }
        comp.func_74782_a("types", (NBTBase)types);
        NBTTagList cuts = new NBTTagList();
        for (int i = 0; i < this.fusionGemCuts.size(); ++i) {
            int cut = this.fusionGemCuts.get((int)i).id;
            NBTTagInt nbt = new NBTTagInt(cut);
            cuts.func_74742_a((NBTBase)nbt);
        }
        comp.func_74782_a("cuts", (NBTBase)cuts);
        NBTTagList placements = new NBTTagList();
        for (int i = 0; i < this.fusionGemPlacements.size(); ++i) {
            int placement = this.fusionGemPlacements.get((int)i).id;
            NBTTagInt nbt = new NBTTagInt(placement);
            placements.func_74742_a((NBTBase)nbt);
        }
        comp.func_74782_a("places", (NBTBase)placements);
        comp.func_74768_a("defectiveCount", this.getDefectiveCount());
        comp.func_74768_a("primeCount", this.getPrimeCount());
        comp.func_74768_a("fusionColor", this.getFusionColor());
        return super.func_189511_e(comp);
    }

    public void func_70020_e(NBTTagCompound comp) {
        super.func_70020_e(comp);
        this.fusionGems = (NBTTagList)comp.func_74781_a("gems");
        NBTTagList types = comp.func_150295_c("types", 8);
        for (int i = 0; i < types.func_74745_c(); ++i) {
            try {
                this.gemTypes.add(Class.forName(types.func_150307_f(i)));
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        NBTTagList cuts = comp.func_150295_c("cuts", 3);
        for (int i = 0; i < cuts.func_74745_c(); ++i) {
            this.fusionGemCuts.add(GemCuts.getCut(cuts.func_186858_c(i)));
        }
        NBTTagList placements = comp.func_150295_c("places", 3);
        for (int i = 0; i < placements.func_74745_c(); ++i) {
            this.fusionGemPlacements.add(GemPlacements.getPlacement(placements.func_186858_c(i)));
        }
        this.setFusionColor(comp.func_74762_e("fusionColor"));
        this.setDefectiveCount(comp.func_74762_e("defectiveCount"));
        this.setPrimeCount(comp.func_74762_e("primeCount"));
        this.setAdjustedSize();
        this.setFusionCount(types.func_74745_c());
        this.setFusionPlacements(this.generateFusionPlacements());
        this.setFusionTypes(this.generateFusionTypes());
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        float pitch = this.pitch;
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        this.pitch = pitch;
        return data;
    }

    public boolean addGem(EntityGem gem) {
        ItemStack second;
        ItemStack weapon;
        NBTTagCompound comp = new NBTTagCompound();
        gem.func_189511_e(comp);
        this.fusionGems.func_74742_a((NBTBase)comp);
        this.gemTypes.add(((Object)((Object)gem)).getClass());
        this.fusionGemCuts.add(gem.getGemCut());
        this.fusionGemPlacements.add(gem.getGemPlacement());
        this.setServitude(gem.getServitude());
        this.jointOwners.addAll(gem.jointOwners);
        if (gem.getServitude() == 1) {
            this.setOwnerId(gem.func_184753_b());
            this.setLeader((EntityLivingBase)gem.getOwner());
        }
        if (this.getFusionCount() == 0) {
            this.func_70012_b(gem.field_70165_t, gem.field_70163_u, gem.field_70161_v, gem.field_70177_z, gem.field_70125_A);
        } else {
            this.func_70012_b((this.field_70165_t + gem.field_70165_t) / 2.0, (this.field_70163_u + gem.field_70163_u) / 2.0, (this.field_70161_v + gem.field_70161_v) / 2.0, this.field_70177_z, this.field_70125_A);
        }
        if (gem.isSoldier) {
            this.setInsigniaColor(gem.getInsigniaColor());
            this.setUniformColor(gem.getUniformColor());
        }
        if ((weapon = this.func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() == Items.field_190931_a) {
            weapon = gem.func_184586_b(EnumHand.MAIN_HAND);
            this.setFusionWeapon(weapon);
        }
        if ((second = this.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() == Items.field_190931_a) {
            second = gem.func_184586_b(EnumHand.OFF_HAND);
            this.setFusionWeapon(second);
        }
        if (gem.isDefective()) {
            this.setDefectiveCount(this.getDefectiveCount() + 1);
        }
        if (gem.isPrimary()) {
            this.setPrimeCount(this.getPrimeCount() + 1);
        }
        this.setAdjustedSize();
        this.setFusionCount(this.getFusionCount() + 1);
        this.setFusionPlacements(this.generateFusionPlacements());
        this.setFusionTypes(this.generateFusionTypes());
        this.pitch = (this.pitch + gem.pitch) / (float)this.getFusionCount();
        return true;
    }

    @Override
    public void unfuse() {
        super.unfuse();
        KAGIC.instance.chatInfoMessage("Fusion poofed");
        if (this.fusionGems == null) {
            KAGIC.instance.chatInfoMessage("ERROR: no fusion data found!");
            KAGIC.instance.chatInfoMessage("Did you use the /summon command to get this fusion?");
            KAGIC.instance.chatInfoMessage("Fusions can only be properly obtained by combining two existing gems.");
        } else {
            for (int i = 0; i < this.fusionGems.func_74745_c(); ++i) {
                try {
                    EntityGem gem = this.gemTypes.get(i).getDeclaredConstructor(World.class).newInstance(this.field_70170_p);
                    gem.func_70020_e(this.fusionGems.func_150305_b(i));
                    gem.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    gem.setServitude(this.getServitude());
                    this.field_70170_p.func_72838_d((Entity)gem);
                    continue;
                }
                catch (Exception e) {
                    KAGIC.instance.chatInfoMessage("ERROR: could not properly unfuse gem. See game log for details.");
                    e.printStackTrace();
                }
            }
        }
        this.field_70170_p.func_72900_e((Entity)this);
    }

    @Override
    public String generateFusionPlacements() {
        String fusionPlacements = "";
        for (int i = 0; i < this.getFusionCount(); ++i) {
            fusionPlacements = i > 0 ? fusionPlacements + " " + this.fusionGemPlacements.get((int)i).id + "_" + this.fusionGemCuts.get((int)i).id : fusionPlacements + this.fusionGemPlacements.get((int)i).id + "_" + this.fusionGemCuts.get((int)i).id;
        }
        return fusionPlacements;
    }

    public String getFusionTypes() {
        return (String)this.field_70180_af.func_187225_a(FUSION_TYPES);
    }

    public void setFusionTypes(String fusionTypes) {
        this.field_70180_af.func_187227_b(FUSION_TYPES, (Object)fusionTypes);
    }

    public int getDefectiveCount() {
        return (Integer)this.field_70180_af.func_187225_a(DEFECTIVE_COUNT);
    }

    public void setDefectiveCount(int defectiveCount) {
        this.field_70180_af.func_187227_b(DEFECTIVE_COUNT, (Object)defectiveCount);
    }

    public int getPrimeCount() {
        return (Integer)this.field_70180_af.func_187225_a(PRIME_COUNT);
    }

    public void setPrimeCount(int primeCount) {
        this.field_70180_af.func_187227_b(PRIME_COUNT, (Object)primeCount);
    }

    public int getFusionColor() {
        return (Integer)this.field_70180_af.func_187225_a(FUSION_COLOR);
    }

    public void setFusionColor(int fusionColor) {
        this.field_70180_af.func_187227_b(FUSION_COLOR, (Object)fusionColor);
    }

    public String generateFusionTypes() {
        String fusionTypes = "";
        for (int i = 0; i < this.getFusionCount(); ++i) {
            fusionTypes = i > 0 ? fusionTypes + " " + this.gemTypes.get(i).getSimpleName() : fusionTypes + this.gemTypes.get(i).getSimpleName();
        }
        return fusionTypes;
    }

    @Override
    public boolean isFusion() {
        return true;
    }

    @Override
    public void setNewCutPlacement() {
    }

    @Override
    public boolean isCorrectCutPlacement() {
        return true;
    }

    @Override
    public boolean isGemPlacementDefined() {
        return !this.fusionGemPlacements.isEmpty();
    }

    @Override
    public boolean isGemCutDefined() {
        return !this.fusionGemCuts.isEmpty();
    }

    public ArrayList<Class<? extends EntityGem>> getGemTypes() {
        return this.gemTypes;
    }

    public ArrayList<GemCuts> getGemCuts() {
        return this.fusionGemCuts;
    }

    public ArrayList<GemPlacements> getGemPlacements() {
        return this.fusionGemPlacements;
    }

    public float getSizeFactor() {
        float sizeMultiplier = this.getFusionCount() - this.getDefectiveCount() + this.getPrimeCount();
        return sizeMultiplier / (float)this.getFusionCount();
    }

    public void setAdjustedSize() {
    }
}

