/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.skills.SkillBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityCrystalSkills
extends EntityCreature {
    private static final DataParameter<Boolean> SELECTED = EntityDataManager.func_187226_a(EntityCrystalSkills.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final ArrayList<Class<? extends SkillBase>> SKILLS = new ArrayList();
    public HashMap<Class<? extends SkillBase>, SkillBase> skills = new HashMap();
    public HashMap<String, Object> savedVariables = new HashMap();
    public EntityPlayer lastPlayerSpokenTo;

    public EntityCrystalSkills(World world) {
        super(world);
        this.field_70180_af.func_187214_a(SELECTED, (Object)false);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_70606_j(this.func_110138_aP());
        for (SkillBase skill : this.skills.values()) {
            skill.create(this);
        }
        return livingdata;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("selected", this.isSelected());
        for (SkillBase skill : this.skills.values()) {
            skill.write(this, compound);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSelected(compound.func_74767_n("selected"));
        for (SkillBase skill : this.skills.values()) {
            skill.read(this, compound);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean result = false;
        ItemStack stack = player.func_184586_b(hand);
        for (Class<? extends SkillBase> skillClass : SKILLS) {
            try {
                SkillBase skill = this.skills.containsKey(skillClass) ? this.skills.get(skillClass) : skillClass.newInstance();
                if (!skill.interact(this, player, hand, stack)) continue;
                this.addSkill(skill, player);
                result = true;
            }
            catch (Exception ex) {
                CrashReport.func_85055_a((Throwable)ex, (String)"Something went wrong loading skills.");
            }
        }
        return result ? result : super.func_184645_a(player, hand);
    }

    public boolean spokenTo(EntityPlayer player, String message) {
        boolean result = false;
        this.lastPlayerSpokenTo = player;
        boolean canRunCommands = this.isSelected();
        for (String name : this.getNames(new ArrayList<String>())) {
            if (name == null) continue;
            canRunCommands = Pattern.compile("\\b" + name.toLowerCase() + "\\b").matcher(message.toLowerCase()).find() || canRunCommands;
        }
        if (canRunCommands) {
            for (Class clazz : SKILLS) {
                try {
                    SkillBase skill = (SkillBase)clazz.newInstance();
                    if (!skill.speak(this, player, message)) continue;
                    skill.commandingPlayer = player;
                    this.addSkill(skill, player);
                    result = true;
                }
                catch (Exception ex) {
                    CrashReport.func_85055_a((Throwable)ex, (String)"Something went wrong loading skills.");
                }
            }
        }
        return result;
    }

    public void setCallibleNames(ArrayList<String> list) {
        list.add(this.func_70005_c_());
    }

    public String[] getNames(ArrayList<String> list) {
        this.setCallibleNames(list);
        return list.toArray(new String[0]);
    }

    public void func_70636_d() {
        super.func_70636_d();
        for (int i = 0; i < this.skills.size(); ++i) {
            ArrayList<SkillBase> skills = new ArrayList<SkillBase>(Arrays.asList(this.skills.values().toArray(new SkillBase[0])));
            if (!skills.get((int)i).readyForRemoval) continue;
            this.removeSkill(skills.get(i));
            --i;
        }
        for (SkillBase skill : this.skills.values()) {
            skill.update(this);
            if (skill.continueExecuting(this)) {
                skill.run(this);
                continue;
            }
            skill.resetTask(this);
        }
        this.func_184195_f(this.isSelected());
    }

    public void addSkill(SkillBase skill, EntityPlayer player) {
        skill.commandingPlayer = player;
        this.setSelected(false);
        this.skills.put(skill.getClass(), skill);
        if (skill.shouldExecute(this)) {
            skill.init(this);
        }
        KAGIC.instance.chatInfoMessage("Task Enlisted: " + skill.getClass().getSimpleName());
    }

    public void removeSkill(SkillBase skill) {
        this.skills.remove(skill.getClass());
    }

    public void feedback(final String message) {
        for (final EntityPlayer player : this.field_70170_p.field_73010_i) {
            if (!(player.func_70032_d((Entity)this) < 16.0f)) continue;
            final String name = this.func_70005_c_();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        player.func_145747_a((ITextComponent)new TextComponentString("<" + name + "> " + message));
                    }
                }
            }).start();
        }
    }

    public void feedback(final EntityPlayer player, final String message) {
        final String name = this.func_70005_c_();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    player.func_145747_a((ITextComponent)new TextComponentString("<" + name + "> " + message));
                }
            }
        }).start();
    }

    public boolean tryToMoveTo(int x, int y, int z) {
        return this.func_70661_as().func_75492_a((double)x, (double)y, (double)z, (double)0.8f);
    }

    public boolean tryToMoveTo(BlockPos pos) {
        return this.tryToMoveTo(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
    }

    public void lookAt(Entity entity) {
        if (entity != null) {
            this.func_70671_ap().func_75651_a(entity, 60.0f, 60.0f);
        }
    }

    public void lookAt(int x, int y, int z) {
        this.func_70671_ap().func_75650_a((double)x, (double)y, (double)z, 60.0f, 60.0f);
    }

    public void lookAt(BlockPos pos) {
        this.lookAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean placeBlock(IBlockState block, int x, int y, int z) {
        boolean canPlace = this.field_70170_p.func_190527_a(block.func_177230_c(), new BlockPos(x, y, z), true, EnumFacing.UP, null);
        if (canPlace) {
            this.func_184609_a(EnumHand.MAIN_HAND);
            return this.field_70170_p.func_180501_a(new BlockPos(x, y, z), block, 3);
        }
        return false;
    }

    public boolean placeBlock(IBlockState block, BlockPos pos) {
        return this.placeBlock(block, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean tryToBreakBlock(int x, int y, int z) {
        IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(x, y, z));
        if (!state.func_185904_a().func_76229_l()) {
            return this.func_184614_ca().func_150998_b(state);
        }
        return true;
    }

    public boolean tryToBreakBlock(BlockPos pos) {
        return this.tryToBreakBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean breakBlock(int x, int y, int z) {
        if (this.tryToBreakBlock(x, y, z)) {
            this.func_184609_a(EnumHand.MAIN_HAND);
            return this.field_70170_p.func_175655_b(new BlockPos(x, y, z), true);
        }
        return false;
    }

    public boolean breakBlock(BlockPos pos) {
        return this.breakBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean isSelected() {
        return (Boolean)this.field_70180_af.func_187225_a(SELECTED);
    }

    public void setSelected(boolean selected) {
        this.field_70180_af.func_187227_b(SELECTED, (Object)selected);
    }
}

