/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.client.render.layers;

import mod.akrivus.kagic.client.model.ModelGem;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.gem.EntityHessonite;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerQuartzCape
implements LayerRenderer<EntityGem> {
    private final RenderLivingBase<?> gemRenderer;
    private final boolean isBack;
    private final boolean useInsigniaColors;

    public LayerQuartzCape(RenderLivingBase<?> gemRenderer) {
        this(gemRenderer, false, false);
    }

    public LayerQuartzCape(RenderLivingBase<?> gemRenderer, boolean isBack, boolean useInsigniaColors) {
        this.gemRenderer = gemRenderer;
        this.isBack = isBack;
        this.useInsigniaColors = useInsigniaColors;
    }

    public void doRenderLayer(EntityGem gem, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if ((gem.isPrimary() || gem instanceof EntityHessonite) && !gem.func_82150_aj() && gem.hasCape()) {
            this.gemRenderer.func_110776_a(this.getTexture(gem));
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.125f);
            double d0 = gem.prevChasingPosX + (gem.chasingPosX - gem.prevChasingPosX) * (double)partialTicks - (gem.field_70169_q + (gem.field_70165_t - gem.field_70169_q) * (double)partialTicks);
            double d1 = gem.prevChasingPosY + (gem.chasingPosY - gem.prevChasingPosY) * (double)partialTicks - (gem.field_70167_r + (gem.field_70163_u - gem.field_70167_r) * (double)partialTicks);
            double d2 = gem.prevChasingPosZ + (gem.chasingPosZ - gem.prevChasingPosZ) * (double)partialTicks - (gem.field_70166_s + (gem.field_70161_v - gem.field_70166_s) * (double)partialTicks);
            float f = gem.field_70760_ar + (gem.field_70761_aq - gem.field_70760_ar) * partialTicks;
            double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
            double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            f1 += MathHelper.func_76126_a((float)((gem.field_70141_P + (gem.field_70140_Q - gem.field_70141_P) * partialTicks) * 6.0f)) * 32.0f;
            if (gem.func_70093_af()) {
                f1 += 25.0f;
            }
            GlStateManager.func_179114_b((float)(6.0f + f2 / 2.0f + f1), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f3 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-f3 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float[] afloat = this.useInsigniaColors ? EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.values()[gem.getInsigniaColor()]) : EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.values()[gem.getUniformColor()]);
            GlStateManager.func_179124_c((float)(afloat[0] * 2.0f), (float)(afloat[1] * 2.0f), (float)(afloat[2] * 2.0f));
            ((ModelGem)this.gemRenderer.func_177087_b()).renderCape(0.0625f);
            GlStateManager.func_179121_F();
        }
    }

    public String getName(EntityGem gem) {
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        if (loc.func_110624_b().equals("kagic")) {
            return loc.func_110623_a().replaceFirst("kagic.", "");
        }
        return loc.func_110623_a();
    }

    public ResourceLocation getTexture(EntityGem gem) {
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        if (this.isBack) {
            return new ResourceLocation(loc.func_110624_b() + ":textures/entities/" + this.getName(gem) + "/cape_back.png");
        }
        return new ResourceLocation(loc.func_110624_b() + ":textures/entities/" + this.getName(gem) + "/cape.png");
    }

    public boolean func_177142_b() {
        return true;
    }
}

