/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.client.render.layers;

import mod.akrivus.kagic.entity.EntityGem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;

public class LayerInsignia
implements LayerRenderer<EntityGem> {
    private final RenderLivingBase<?> gemRenderer;
    private final ModelBase gemModel;
    private final String name;

    public LayerInsignia(RenderLivingBase<?> gemRenderer) {
        this(gemRenderer, null);
    }

    public LayerInsignia(RenderLivingBase<?> gemRenderer, String name) {
        this.gemRenderer = gemRenderer;
        this.gemModel = gemRenderer.func_177087_b();
        this.name = name;
    }

    public void doRenderLayer(EntityGem gem, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.gemRenderer.func_110776_a(this.getTexture(gem));
        float[] insigniaColor = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.values()[gem.getInsigniaColor()]);
        GlStateManager.func_179124_c((float)insigniaColor[0], (float)insigniaColor[1], (float)insigniaColor[2]);
        this.gemModel.func_178686_a(this.gemRenderer.func_177087_b());
        this.gemModel.func_78088_a((Entity)gem, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179084_k();
    }

    public ResourceLocation getTexture(EntityGem gem) {
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        if (gem.hasInsigniaVariant(gem.getGemPlacement())) {
            return new ResourceLocation(loc.func_110624_b() + ":textures/entities/" + this.getName(gem) + "/insignia_" + gem.getGemPlacement().toString().toLowerCase() + ".png");
        }
        return new ResourceLocation(loc.func_110624_b() + ":textures/entities/" + this.getName(gem) + "/insignia.png");
    }

    public String getName(EntityGem gem) {
        if (this.name == null) {
            ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
            if (loc.func_110624_b().equals("kagic")) {
                return loc.func_110623_a().replaceFirst("kagic.", "");
            }
            return loc.func_110623_a();
        }
        return this.name;
    }

    public boolean func_177142_b() {
        return true;
    }
}

