/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.client.render.layers;

import mod.akrivus.kagic.entity.EntityGem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;

public class LayerHair
implements LayerRenderer<EntityGem> {
    private final RenderLivingBase<?> gemRenderer;
    private final ModelBase gemModel;
    private float offset;
    private String name;

    public LayerHair(RenderLivingBase<?> gemRenderer) {
        this(gemRenderer, 0.0f);
    }

    public LayerHair(RenderLivingBase<?> gemRenderer, float offset) {
        this(gemRenderer, offset, null);
    }

    public LayerHair(RenderLivingBase<?> gemRenderer, float offset, String name) {
        this.gemRenderer = gemRenderer;
        this.gemModel = gemRenderer.func_177087_b();
        this.offset = offset;
        this.name = name;
    }

    public void doRenderLayer(EntityGem gem, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.gemRenderer.func_110776_a(this.getHairStyle(gem, gem.getHairStyle()));
        int hairColor = gem.getHairColor();
        float r = (float)((hairColor & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((hairColor & 0xFF00) >> 8) / 255.0f;
        float b = (float)((hairColor & 0xFF) >> 0) / 255.0f;
        GlStateManager.func_179124_c((float)(r + this.offset), (float)(g + this.offset), (float)(b + this.offset));
        this.gemModel.func_178686_a(this.gemRenderer.func_177087_b());
        this.gemModel.func_78088_a((Entity)gem, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179084_k();
    }

    public ResourceLocation getHairStyle(EntityGem gem, int hairstyle) {
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        if (gem.hasHairVariant(gem.getGemPlacement())) {
            return new ResourceLocation(loc.func_110624_b() + ":textures/entities/" + this.getName(gem) + "/hair_" + gem.getGemPlacement().toString().toLowerCase() + ".png");
        }
        return new ResourceLocation(loc.func_110624_b() + ":textures/entities/" + this.getName(gem) + "/hair_" + gem.getHairStyle() + ".png");
    }

    public String getName(EntityGem gem) {
        if (this.name != null) {
            return this.name;
        }
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        if (loc.func_110624_b().equals("kagic")) {
            return loc.func_110623_a().replaceFirst("kagic.", "");
        }
        return loc.func_110623_a();
    }

    public boolean func_177142_b() {
        return true;
    }
}

